using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace Taskman2.SqlServer.Models.Base
{
    /// <summary>
    /// table PRIORITIESɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class PrioritiesTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>[PRIORITY_ID]</summary>
        public FieldProperty priorityId;
        ///<summary>[PRIORITY_NAME]</summary>
        public FieldProperty priorityName;
        ///<summary>[IS_DEFAULT]</summary>
        public FieldProperty isDefault;
        ///<summary>[CREATED_BY]</summary>
        public FieldProperty createdBy;
        ///<summary>[CREATED_AT]</summary>
        public FieldProperty createdAt;
        ///<summary>[MODIFIED_BY]</summary>
        public FieldProperty modifiedBy;
        ///<summary>[MODIFIED_AT]</summary>
        public FieldProperty modifiedAt;
        ///<summary>[DELETED]</summary>
        public FieldProperty deleted;
        

        /// <summary>
        /// default construct
        /// </summary>
        public PrioritiesTableProperty()
        {
            this.EntityName = "PRIORITIES";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";
            
            priorityId = FieldProperty.NewInstance("int", "PRIORITIES", "PRIORITY_ID","[PRIORITY_ID]", 4, 10, 0, false, 0,true);
            priorityName = FieldProperty.NewInstance("varchar", "PRIORITIES", "PRIORITY_NAME","[PRIORITY_NAME]", 200, 200, 0, true, "",false);
            isDefault = FieldProperty.NewInstance("int", "PRIORITIES", "IS_DEFAULT","[IS_DEFAULT]", 4, 10, 0, true, null,false);
            createdBy = FieldProperty.NewInstance("varchar", "PRIORITIES", "CREATED_BY","[CREATED_BY]", 16, 16, 0, false, "system",false);
            createdAt = FieldProperty.NewInstance("datetime", "PRIORITIES", "CREATED_AT","[CREATED_AT]", 16, 23, 3, false, null,false);
            modifiedBy = FieldProperty.NewInstance("varchar", "PRIORITIES", "MODIFIED_BY","[MODIFIED_BY]", 16, 16, 0, false, "system",false);
            modifiedAt = FieldProperty.NewInstance("datetime", "PRIORITIES", "MODIFIED_AT","[MODIFIED_AT]", 16, 23, 3, false, null,false);
            deleted = FieldProperty.NewInstance("int", "PRIORITIES", "DELETED","[DELETED]", 4, 10, 0, false, 0,false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.priorityId;
            yield return this.priorityName;
            yield return this.isDefault;
            yield return this.createdBy;
            yield return this.createdAt;
            yield return this.modifiedBy;
            yield return this.modifiedAt;
            yield return this.deleted;
            
        }
                /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> PrimaryKeys()
        {
            yield return  this.priorityId;
            
        }
                
    }
}