using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using Taskman2.SqlServer.Models.Base;

namespace Taskman2.SqlServer.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table USERS Field`
    /// </summary>
    public class UsersTableFormAdapter : CFW.Forms.FormAdapter
	{
		private UsersTableRow theEntity;

		///<summary>[USER_ID]</summary>
		public FormAdapterElement userId;
		///<summary>[USER_NAME]</summary>
		public FormAdapterElement userName;
		///<summary>[PASSWORD]</summary>
		public FormAdapterElement password;
		///<summary>[CREATED_BY]</summary>
		public FormAdapterElement createdBy;
		///<summary>[CREATED_AT]</summary>
		public FormAdapterElement createdAt;
		///<summary>[MODIFIED_BY]</summary>
		public FormAdapterElement modifiedBy;
		///<summary>[MODIFIED_AT]</summary>
		public FormAdapterElement modifiedAt;
		///<summary>[DELETED]</summary>
		public FormAdapterElement deleted;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.userId != null) this.userId.Render();
			if(this.userName != null) this.userName.Render();
			if(this.password != null) this.password.Render();
			if(this.createdBy != null) this.createdBy.Render();
			if(this.createdAt != null) this.createdAt.Render();
			if(this.modifiedBy != null) this.modifiedBy.Render();
			if(this.modifiedAt != null) this.modifiedAt.Render();
			if(this.deleted != null) this.deleted.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (UsersTableRow)entity;
			if(this.userId != null) this.userId.SetValue(this.theEntity.userId);
			if(this.userName != null) this.userName.SetValue(this.theEntity.userName);
			if(this.password != null) this.password.SetValue(this.theEntity.password);
			if(this.createdBy != null) this.createdBy.SetValue(this.theEntity.createdBy);
			if(this.createdAt != null) this.createdAt.SetValue(this.theEntity.createdAt);
			if(this.modifiedBy != null) this.modifiedBy.SetValue(this.theEntity.modifiedBy);
			if(this.modifiedAt != null) this.modifiedAt.SetValue(this.theEntity.modifiedAt);
			if(this.deleted != null) this.deleted.SetValue(this.theEntity.deleted);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.userId != null) this.theEntity.userId = StringUtil.StringValue(this.userId.GetValue());
			if(this.userName != null) this.theEntity.userName = StringUtil.StringValue(this.userName.GetValue());
			if(this.password != null) this.theEntity.password = StringUtil.StringValue(this.password.GetValue());
			if(this.createdBy != null) this.theEntity.createdBy = StringUtil.StringValue(this.createdBy.GetValue());
			if(this.createdAt != null) this.theEntity.createdAt = DateUtil.DateValue(this.createdAt.GetValue());
			if(this.modifiedBy != null) this.theEntity.modifiedBy = StringUtil.StringValue(this.modifiedBy.GetValue());
			if(this.modifiedAt != null) this.theEntity.modifiedAt = DateUtil.DateValue(this.modifiedAt.GetValue());
			if(this.deleted != null) this.theEntity.deleted = NumberUtil.Value<Int32>(this.deleted.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.userId != null) this.userId.UpdateField();
			if(this.userName != null) this.userName.UpdateField();
			if(this.password != null) this.password.UpdateField();
			if(this.createdBy != null) this.createdBy.UpdateField();
			if(this.createdAt != null) this.createdAt.UpdateField();
			if(this.modifiedBy != null) this.modifiedBy.UpdateField();
			if(this.modifiedAt != null) this.modifiedAt.UpdateField();
			if(this.deleted != null) this.deleted.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.userId != null){
			    if(!this.userId.Validate()){
				    valid = false;
				    this.messages.Add(this.userId.ErrorMessage);
			    }
			}
			
			if(this.userName != null){
			    if(!this.userName.Validate()){
				    valid = false;
				    this.messages.Add(this.userName.ErrorMessage);
			    }
			}
			
			if(this.password != null){
			    if(!this.password.Validate()){
				    valid = false;
				    this.messages.Add(this.password.ErrorMessage);
			    }
			}
			
			if(this.createdBy != null){
			    if(!this.createdBy.Validate()){
				    valid = false;
				    this.messages.Add(this.createdBy.ErrorMessage);
			    }
			}
			
			if(this.createdAt != null){
			    if(!this.createdAt.Validate()){
				    valid = false;
				    this.messages.Add(this.createdAt.ErrorMessage);
			    }
			}
			
			if(this.modifiedBy != null){
			    if(!this.modifiedBy.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedBy.ErrorMessage);
			    }
			}
			
			if(this.modifiedAt != null){
			    if(!this.modifiedAt.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedAt.ErrorMessage);
			    }
			}
			
			if(this.deleted != null){
			    if(!this.deleted.Validate()){
				    valid = false;
				    this.messages.Add(this.deleted.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private UsersFormAdapter formAdapter;
    //     private UsersProperty property;
    //     private UsersEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new UsersFormAdapter();

	
    formAdapter.userId= new TextBoxAdapterElement(
        userId,
        new CFW.Forms.Filters.StringFilter(property.userId),
        CFW.Validators.FieldValidator.GetInstance(property.userId)
    );
	
    formAdapter.userName= new TextBoxAdapterElement(
        userName,
        new CFW.Forms.Filters.StringFilter(property.userName),
        CFW.Validators.FieldValidator.GetInstance(property.userName)
    );
	
    formAdapter.password= new TextBoxAdapterElement(
        password,
        new CFW.Forms.Filters.StringFilter(property.password),
        CFW.Validators.FieldValidator.GetInstance(property.password)
    );
	
    formAdapter.createdBy= new TextBoxAdapterElement(
        createdBy,
        new CFW.Forms.Filters.StringFilter(property.createdBy),
        CFW.Validators.FieldValidator.GetInstance(property.createdBy)
    );
	
    formAdapter.createdAt= new TextBoxAdapterElement(
        createdAt,
        new CFW.Forms.Filters.StringFilter(property.createdAt),
        CFW.Validators.FieldValidator.GetInstance(property.createdAt)
    );
	
    formAdapter.modifiedBy= new TextBoxAdapterElement(
        modifiedBy,
        new CFW.Forms.Filters.StringFilter(property.modifiedBy),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedBy)
    );
	
    formAdapter.modifiedAt= new TextBoxAdapterElement(
        modifiedAt,
        new CFW.Forms.Filters.StringFilter(property.modifiedAt),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedAt)
    );
	
    formAdapter.deleted= new TextBoxAdapterElement(
        deleted,
        new CFW.Forms.Filters.StringFilter(property.deleted),
        CFW.Validators.FieldValidator.GetInstance(property.deleted)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}