using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace Taskman2.Oracle.Models.Base
{
    /// <summary>
    /// table STATUSESɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class StatusesTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>[STATUS_ID]</summary>
        public FieldProperty statusId;
        ///<summary>[STATUS_NAME]</summary>
        public FieldProperty statusName;
        ///<summary>[CLOSED]</summary>
        public FieldProperty closed;
        ///<summary>[CREATED_BY]</summary>
        public FieldProperty createdBy;
        ///<summary>[CREATED_AT]</summary>
        public FieldProperty createdAt;
        ///<summary>[MODIFIED_BY]</summary>
        public FieldProperty modifiedBy;
        ///<summary>[MODIFIED_AT]</summary>
        public FieldProperty modifiedAt;
        ///<summary>[DELETED]</summary>
        public FieldProperty deleted;
        

        /// <summary>
        /// default construct
        /// </summary>
        public StatusesTableProperty()
        {
            this.EntityName = "STATUSES";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";

            statusId = FieldProperty.NewInstance("decimal", "STATUSES", "STATUS_ID", "[STATUS_ID]", 4, 10, 0, false, 0, true);
            statusName = FieldProperty.NewInstance("varchar", "STATUSES", "STATUS_NAME","[STATUS_NAME]", 40, 40, 0, true, "",false);
            closed = FieldProperty.NewInstance("decimal", "STATUSES", "CLOSED", "[CLOSED]", 4, 10, 0, false, 0, false);
            createdBy = FieldProperty.NewInstance("varchar", "STATUSES", "CREATED_BY","[CREATED_BY]", 16, 16, 0, false, "system",false);
            createdAt = FieldProperty.NewInstance("datetime", "STATUSES", "CREATED_AT","[CREATED_AT]", 16, 23, 3, false, null,false);
            modifiedBy = FieldProperty.NewInstance("varchar", "STATUSES", "MODIFIED_BY","[MODIFIED_BY]", 16, 16, 0, false, "system",false);
            modifiedAt = FieldProperty.NewInstance("datetime", "STATUSES", "MODIFIED_AT","[MODIFIED_AT]", 16, 23, 3, false, null,false);
            deleted = FieldProperty.NewInstance("decimal", "STATUSES", "DELETED", "[DELETED]", 4, 10, 0, false, 0, false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.statusId;
            yield return this.statusName;
            yield return this.closed;
            yield return this.createdBy;
            yield return this.createdAt;
            yield return this.modifiedBy;
            yield return this.modifiedAt;
            yield return this.deleted;
            
        }
                /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> PrimaryKeys()
        {
            yield return  this.statusId;
            
        }
                
    }
}