using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Models;
using CFW.Database;
using CFW.Database.Conditions;


namespace TaskManager.Models 
{
    /// <summary>
    /// Statuses f`
    /// </summary>
    [Serializable()]
	public class StatusesModel : DbModel<StatusesEntity,StatusesProperty>
	{
        private static Enumerations statuses;
        /// <summary>
        /// default construct  
        /// </summary>
        public StatusesModel() : base()
        {
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        public StatusesModel(Connection connection) : base(connection)
        {
        }
        /// <summary>
        /// ̐ڑAvpeBgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        /// <param name="property">̃vpeB</param>
        public StatusesModel(Connection connection, StatusesProperty property) : base(connection,property)
        {
        }
        public Enumerations getEnumerations()
        {
            if (statuses != null) return statuses.clone();
            try
            {

                this.connect("sample", "task");

                Criteria c = new Criteria();
                c.AddWhere(new ColumnValueCondition(property.deleted, 0, "="));
                c.AddOrderBy(property.id);

                DataSource<StatusesEntity> datasource = new DataSource<StatusesEntity>();
                datasource.setConnection(connection);
                datasource.setProperty(property);
                List<StatusesEntity> list = datasource.find(c);
                statuses = new Enumerations(list.ToArray());
                return statuses;
            }
            catch (Exception)
            {
                throw;
            }
            finally
            {
                this.disconnect();
            }

        }
        public short getDefaultValue()
        {
            return NumberUtil.Value<short>( getEnumerations().getDefaultValue() );
        }
        public bool isClosed(short id)
        {
            StatusesEntity status = getEnumerations().findById(id) as StatusesEntity;
            if (status == null) return false;
            return NumberUtil.BoolValue( status.closed );

        }

        public List<StatusesEntity> findAll()
        {
            related();
            connect();
            AssociationSelect<StatusesEntity> select = new AssociationSelect<StatusesEntity>(connection);
            select.from(new StatusesProperty());

            Association statusTasksAssociation = new Association(
                "tasks", 
                Association.Multiplicity.TO_MANY, 
                new TasksProperty(), 
                new StringCondition("STATUSES.ID = TASKS.STATUS_ID"));
            statusTasksAssociation.add(
                new Association(
                    "category", 
                    Association.Multiplicity.TO_ONE, 
                    new CategoriesProperty(), 
                    new StringCondition("TASKS.CATEGORY_ID = CATEGORIES.ID")));

            select.associate(statusTasksAssociation);

            Criteria criteria = new Criteria();
            criteria.AddOrderBy("STATUSES.ID");
            criteria.AddOrderBy("TASKS.CREATED_AT", "DESC");
            select.setCriteria(criteria);
            List<StatusesEntity> list = select.queryAsEntity();
            disconnect();
            return list;
        }
        public List<StatusesEntity> related()
        {
            List<StatusesEntity> list = new List<StatusesEntity>();
            Association assoc = new Association("statuses",Association.Multiplicity.NONE,new StatusesProperty());

            Association assocTasks = new Association(
                "tasks",
                 Association.Multiplicity.TO_MANY,
                  new TasksProperty(),
                  new StringCondition("STATUSES.ID = TASKS.STATUS_ID")
                );


            Association assocCategories = new Association(
                "category",
                 Association.Multiplicity.TO_ONE,
                 new CategoriesProperty(),
                 new StringCondition("TASKS.CATEGORY_ID = CATEGORIES.ID")
                );

            assocTasks.add(assocCategories);

            assoc.add(assocTasks);


            assoc.dump();

            return list;
        }


	}

}