using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace TaskManager.Models.Base
{
    /// <summary>
    /// table acl_resources Field`
    /// </summary>
    [Serializable()]
    public class AclResourcesTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[id]</summary>
        protected Int32 _id;
        ///<summary>[id]</summary>
        public Int32 id{
            get{return _id;}
            set{_id = value;}
        }
        ///<summary>[name]</summary>
        protected string _name;
        ///<summary>[name]</summary>
        public string name{
            get{return _name;}
            set{_name = value;}
        }
        ///<summary>[left_side]</summary>
        protected Int32 _leftSide;
        ///<summary>[left_side]</summary>
        public Int32 leftSide{
            get{return _leftSide;}
            set{_leftSide = value;}
        }
        ///<summary>[right_side]</summary>
        protected Int32 _rightSide;
        ///<summary>[right_side]</summary>
        public Int32 rightSide{
            get{return _rightSide;}
            set{_rightSide = value;}
        }
        ///<summary>[description]</summary>
        protected string _description;
        ///<summary>[description]</summary>
        public string description{
            get{return _description;}
            set{_description = value;}
        }
        ///<summary>[deleted]</summary>
        protected Int32 _deleted;
        ///<summary>[deleted]</summary>
        public Int32 deleted{
            get{return _deleted;}
            set{_deleted = value;}
        }
        ///<summary>[created_at]</summary>
        protected DateTime? _createdAt;
        ///<summary>[created_at]</summary>
        public DateTime? createdAt{
            get{return _createdAt;}
            set{_createdAt = value;}
        }
        ///<summary>[modified_at]</summary>
        protected DateTime? _modifiedAt;
        ///<summary>[modified_at]</summary>
        public DateTime? modifiedAt{
            get{return _modifiedAt;}
            set{_modifiedAt = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public AclResourcesTableRow() : base()
        {
            this._id = 0;
            this._name = "";
            this._leftSide = 0;
            this._rightSide = 0;
            this._description = "";
            this._deleted = 0;
            this._createdAt = null;
            this._modifiedAt = null;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "id"){ this._id = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "name"){ this._name = StringUtil.StringValue( value );return; }
            if(name ==  "left_side"){ this._leftSide = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "right_side"){ this._rightSide = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "description"){ this._description = StringUtil.StringValue( value );return; }
            if(name ==  "deleted"){ this._deleted = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "created_at"){ this._createdAt = DateUtil.DateValue( value );return; }
            if(name ==  "modified_at"){ this._modifiedAt = DateUtil.DateValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "id") return this._id;
            if(name ==  "name") return this._name;
            if(name ==  "left_side") return this._leftSide;
            if(name ==  "right_side") return this._rightSide;
            if(name ==  "description") return this._description;
            if(name ==  "deleted") return this._deleted;
            if(name ==  "created_at") return this._createdAt;
            if(name ==  "modified_at") return this._modifiedAt;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            AclResourcesTableRow clone = new AclResourcesTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(AclResourcesTableRow source)
        {
            this.id = source.id;
            this.name = source.name;
            this.leftSide = source.leftSide;
            this.rightSide = source.rightSide;
            this.description = source.description;
            this.deleted = source.deleted;
            this.createdAt = source.createdAt;
            this.modifiedAt = source.modifiedAt;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("id")){ this._id = NumberUtil.Value<Int32>(row["id"]); }
            if (cols.Contains("name")){ this._name = StringUtil.StringValue(row["name"]); }
            if (cols.Contains("left_side")){ this._leftSide = NumberUtil.Value<Int32>(row["left_side"]); }
            if (cols.Contains("right_side")){ this._rightSide = NumberUtil.Value<Int32>(row["right_side"]); }
            if (cols.Contains("description")){ this._description = StringUtil.StringValue(row["description"]); }
            if (cols.Contains("deleted")){ this._deleted = NumberUtil.Value<Int32>(row["deleted"]); }
            if (cols.Contains("created_at")){ this._createdAt = DateUtil.DateValue(row["created_at"]); }
            if (cols.Contains("modified_at")){ this._modifiedAt = DateUtil.DateValue(row["modified_at"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "id");if (cols.Contains(columnName)){ this._id = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "name");if (cols.Contains(columnName)){ this._name = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "left_side");if (cols.Contains(columnName)){ this._leftSide = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "right_side");if (cols.Contains(columnName)){ this._rightSide = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "description");if (cols.Contains(columnName)){ this._description = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "deleted");if (cols.Contains(columnName)){ this._deleted = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "created_at");if (cols.Contains(columnName)){ this._createdAt = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "modified_at");if (cols.Contains(columnName)){ this._modifiedAt = DateUtil.DateValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._id = NumberUtil.Value<Int32>(reader[0]);
            this._name = StringUtil.StringValue(reader[1]);
            this._leftSide = NumberUtil.Value<Int32>(reader[2]);
            this._rightSide = NumberUtil.Value<Int32>(reader[3]);
            this._description = StringUtil.StringValue(reader[4]);
            this._deleted = NumberUtil.Value<Int32>(reader[5]);
            this._createdAt = DateUtil.DateValue(reader[6]);
            this._modifiedAt = DateUtil.DateValue(reader[7]);
            
            this.IsNew = false;
        }
    }

}