using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using TaskManager.Models;

namespace TaskManager.Forms
{
    public partial class StatusViewForm : Form
    {
        System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
        List<StatusesEntity> statuses;
        public StatusViewForm()
        {
            InitializeComponent();
        }

        private void StatusViewForm_Load(object sender, EventArgs e)
        {
            loadData();
            render();
        }
        private void loadData()
        {
            sw.Reset();
            sw.Start();
            StatusesModel model = new StatusesModel();
            statuses = model.findAll();
            sw.Stop();
        }
        private void render()
        {
            foreach (StatusesEntity entity in statuses)
            {
                textBox1.AppendText(entity.id.ToString() + " ");
                textBox1.AppendText(entity.name.ToString() + " ");
                textBox1.AppendText(entity.createdAt.ToString());
                textBox1.AppendText(Environment.NewLine);

                if (entity.tasks != null)
                {
                    foreach (TasksEntity task in entity.tasks)
                    {
                        textBox1.AppendText("    ");
                        textBox1.AppendText(task.id.ToString() + " ");
                        textBox1.AppendText(task.subject.ToString() + " ");
                        textBox1.AppendText(task.categoryName.ToString() + " ");
                        textBox1.AppendText(task.createdBy.ToString() + " ");
                        textBox1.AppendText(task.createdAt.ToString());
                        textBox1.AppendText(Environment.NewLine);
                    }
                }
            }

            textBox1.AppendText(Environment.NewLine);
            textBox1.AppendText(Environment.NewLine);
            textBox1.AppendText("elapsed " + sw.ElapsedMilliseconds.ToString());


        }
    }
}