using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using TaskManager.Models.Base;

namespace TaskManager.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table TASKS Field`
    /// </summary>
    public class TasksTableFormAdapter : CFW.Forms.FormAdapter
	{
		private TasksTableRow theEntity;

		///<summary>[ID]</summary>
		public FormAdapterElement id;
		///<summary>[SUBJECT]</summary>
		public FormAdapterElement subject;
		///<summary>[STATUS_ID]</summary>
		public FormAdapterElement statusId;
		///<summary>[FROM_DATE]</summary>
		public FormAdapterElement fromDate;
		///<summary>[TO_DATE]</summary>
		public FormAdapterElement toDate;
		///<summary>[DESCRIPTION]</summary>
		public FormAdapterElement description;
		///<summary>[CREATED_BY]</summary>
		public FormAdapterElement createdBy;
		///<summary>[CREATED_AT]</summary>
		public FormAdapterElement createdAt;
		///<summary>[MODIFIED_BY]</summary>
		public FormAdapterElement modifiedBy;
		///<summary>[MODIFIED_AT]</summary>
		public FormAdapterElement modifiedAt;
		///<summary>[DELETED]</summary>
		public FormAdapterElement deleted;
		///<summary>[CATEGORY_ID]</summary>
		public FormAdapterElement categoryId;
		///<summary>[PRIORITY]</summary>
		public FormAdapterElement priority;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.id != null) this.id.Render();
			if(this.subject != null) this.subject.Render();
			if(this.statusId != null) this.statusId.Render();
			if(this.fromDate != null) this.fromDate.Render();
			if(this.toDate != null) this.toDate.Render();
			if(this.description != null) this.description.Render();
			if(this.createdBy != null) this.createdBy.Render();
			if(this.createdAt != null) this.createdAt.Render();
			if(this.modifiedBy != null) this.modifiedBy.Render();
			if(this.modifiedAt != null) this.modifiedAt.Render();
			if(this.deleted != null) this.deleted.Render();
			if(this.categoryId != null) this.categoryId.Render();
			if(this.priority != null) this.priority.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (TasksTableRow)entity;
			if(this.id != null) this.id.SetValue(this.theEntity.id);
			if(this.subject != null) this.subject.SetValue(this.theEntity.subject);
			if(this.statusId != null) this.statusId.SetValue(this.theEntity.statusId);
			if(this.fromDate != null) this.fromDate.SetValue(this.theEntity.fromDate);
			if(this.toDate != null) this.toDate.SetValue(this.theEntity.toDate);
			if(this.description != null) this.description.SetValue(this.theEntity.description);
			if(this.createdBy != null) this.createdBy.SetValue(this.theEntity.createdBy);
			if(this.createdAt != null) this.createdAt.SetValue(this.theEntity.createdAt);
			if(this.modifiedBy != null) this.modifiedBy.SetValue(this.theEntity.modifiedBy);
			if(this.modifiedAt != null) this.modifiedAt.SetValue(this.theEntity.modifiedAt);
			if(this.deleted != null) this.deleted.SetValue(this.theEntity.deleted);
			if(this.categoryId != null) this.categoryId.SetValue(this.theEntity.categoryId);
			if(this.priority != null) this.priority.SetValue(this.theEntity.priority);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.id != null) this.theEntity.id = NumberUtil.Value<Int32>(this.id.GetValue());
			if(this.subject != null) this.theEntity.subject = StringUtil.StringValue(this.subject.GetValue());
			if(this.statusId != null) this.theEntity.statusId = NumberUtil.Value<Int16>(this.statusId.GetValue());
			if(this.fromDate != null) this.theEntity.fromDate = DateUtil.DateValue(this.fromDate.GetValue());
			if(this.toDate != null) this.theEntity.toDate = DateUtil.DateValue(this.toDate.GetValue());
			if(this.description != null) this.theEntity.description = StringUtil.StringValue(this.description.GetValue());
			if(this.createdBy != null) this.theEntity.createdBy = StringUtil.StringValue(this.createdBy.GetValue());
			if(this.createdAt != null) this.theEntity.createdAt = DateUtil.DateValue(this.createdAt.GetValue());
			if(this.modifiedBy != null) this.theEntity.modifiedBy = StringUtil.StringValue(this.modifiedBy.GetValue());
			if(this.modifiedAt != null) this.theEntity.modifiedAt = DateUtil.DateValue(this.modifiedAt.GetValue());
			if(this.deleted != null) this.theEntity.deleted = NumberUtil.Value<Byte>(this.deleted.GetValue());
			if(this.categoryId != null) this.theEntity.categoryId = NumberUtil.Value<Int32?>(this.categoryId.GetValue());
			if(this.priority != null) this.theEntity.priority = NumberUtil.Value<Byte?>(this.priority.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.id != null) this.id.UpdateField();
			if(this.subject != null) this.subject.UpdateField();
			if(this.statusId != null) this.statusId.UpdateField();
			if(this.fromDate != null) this.fromDate.UpdateField();
			if(this.toDate != null) this.toDate.UpdateField();
			if(this.description != null) this.description.UpdateField();
			if(this.createdBy != null) this.createdBy.UpdateField();
			if(this.createdAt != null) this.createdAt.UpdateField();
			if(this.modifiedBy != null) this.modifiedBy.UpdateField();
			if(this.modifiedAt != null) this.modifiedAt.UpdateField();
			if(this.deleted != null) this.deleted.UpdateField();
			if(this.categoryId != null) this.categoryId.UpdateField();
			if(this.priority != null) this.priority.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.id != null){
			    if(!this.id.Validate()){
				    valid = false;
				    this.messages.Add(this.id.ErrorMessage);
			    }
			}
			
			if(this.subject != null){
			    if(!this.subject.Validate()){
				    valid = false;
				    this.messages.Add(this.subject.ErrorMessage);
			    }
			}
			
			if(this.statusId != null){
			    if(!this.statusId.Validate()){
				    valid = false;
				    this.messages.Add(this.statusId.ErrorMessage);
			    }
			}
			
			if(this.fromDate != null){
			    if(!this.fromDate.Validate()){
				    valid = false;
				    this.messages.Add(this.fromDate.ErrorMessage);
			    }
			}
			
			if(this.toDate != null){
			    if(!this.toDate.Validate()){
				    valid = false;
				    this.messages.Add(this.toDate.ErrorMessage);
			    }
			}
			
			if(this.description != null){
			    if(!this.description.Validate()){
				    valid = false;
				    this.messages.Add(this.description.ErrorMessage);
			    }
			}
			
			if(this.createdBy != null){
			    if(!this.createdBy.Validate()){
				    valid = false;
				    this.messages.Add(this.createdBy.ErrorMessage);
			    }
			}
			
			if(this.createdAt != null){
			    if(!this.createdAt.Validate()){
				    valid = false;
				    this.messages.Add(this.createdAt.ErrorMessage);
			    }
			}
			
			if(this.modifiedBy != null){
			    if(!this.modifiedBy.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedBy.ErrorMessage);
			    }
			}
			
			if(this.modifiedAt != null){
			    if(!this.modifiedAt.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedAt.ErrorMessage);
			    }
			}
			
			if(this.deleted != null){
			    if(!this.deleted.Validate()){
				    valid = false;
				    this.messages.Add(this.deleted.ErrorMessage);
			    }
			}
			
			if(this.categoryId != null){
			    if(!this.categoryId.Validate()){
				    valid = false;
				    this.messages.Add(this.categoryId.ErrorMessage);
			    }
			}
			
			if(this.priority != null){
			    if(!this.priority.Validate()){
				    valid = false;
				    this.messages.Add(this.priority.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private TasksFormAdapter formAdapter;
    //     private TasksProperty property;
    //     private TasksEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new TasksFormAdapter();

	
    formAdapter.id= new TextBoxAdapterElement(
        id,
        new CFW.Forms.Filters.StringFilter(property.id),
        CFW.Validators.FieldValidator.GetInstance(property.id)
    );
	
    formAdapter.subject= new TextBoxAdapterElement(
        subject,
        new CFW.Forms.Filters.StringFilter(property.subject),
        CFW.Validators.FieldValidator.GetInstance(property.subject)
    );
	
    formAdapter.statusId= new TextBoxAdapterElement(
        statusId,
        new CFW.Forms.Filters.StringFilter(property.statusId),
        CFW.Validators.FieldValidator.GetInstance(property.statusId)
    );
	
    formAdapter.fromDate= new TextBoxAdapterElement(
        fromDate,
        new CFW.Forms.Filters.StringFilter(property.fromDate),
        CFW.Validators.FieldValidator.GetInstance(property.fromDate)
    );
	
    formAdapter.toDate= new TextBoxAdapterElement(
        toDate,
        new CFW.Forms.Filters.StringFilter(property.toDate),
        CFW.Validators.FieldValidator.GetInstance(property.toDate)
    );
	
    formAdapter.description= new TextBoxAdapterElement(
        description,
        new CFW.Forms.Filters.StringFilter(property.description),
        CFW.Validators.FieldValidator.GetInstance(property.description)
    );
	
    formAdapter.createdBy= new TextBoxAdapterElement(
        createdBy,
        new CFW.Forms.Filters.StringFilter(property.createdBy),
        CFW.Validators.FieldValidator.GetInstance(property.createdBy)
    );
	
    formAdapter.createdAt= new TextBoxAdapterElement(
        createdAt,
        new CFW.Forms.Filters.StringFilter(property.createdAt),
        CFW.Validators.FieldValidator.GetInstance(property.createdAt)
    );
	
    formAdapter.modifiedBy= new TextBoxAdapterElement(
        modifiedBy,
        new CFW.Forms.Filters.StringFilter(property.modifiedBy),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedBy)
    );
	
    formAdapter.modifiedAt= new TextBoxAdapterElement(
        modifiedAt,
        new CFW.Forms.Filters.StringFilter(property.modifiedAt),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedAt)
    );
	
    formAdapter.deleted= new TextBoxAdapterElement(
        deleted,
        new CFW.Forms.Filters.StringFilter(property.deleted),
        CFW.Validators.FieldValidator.GetInstance(property.deleted)
    );
	
    formAdapter.categoryId= new TextBoxAdapterElement(
        categoryId,
        new CFW.Forms.Filters.StringFilter(property.categoryId),
        CFW.Validators.FieldValidator.GetInstance(property.categoryId)
    );
	
    formAdapter.priority= new TextBoxAdapterElement(
        priority,
        new CFW.Forms.Filters.StringFilter(property.priority),
        CFW.Validators.FieldValidator.GetInstance(property.priority)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}