using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using TaskManager.Models.Base;

namespace TaskManager.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table auth_users Field`
    /// </summary>
    public class AuthUsersTableFormAdapter : CFW.Forms.FormAdapter
	{
		private AuthUsersTableRow theEntity;

		///<summary>[login_id]</summary>
		public FormAdapterElement loginId;
		///<summary>[name]</summary>
		public FormAdapterElement name;
		///<summary>[password]</summary>
		public FormAdapterElement password;
		///<summary>[description]</summary>
		public FormAdapterElement description;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.loginId != null) this.loginId.Render();
			if(this.name != null) this.name.Render();
			if(this.password != null) this.password.Render();
			if(this.description != null) this.description.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (AuthUsersTableRow)entity;
			if(this.loginId != null) this.loginId.SetValue(this.theEntity.loginId);
			if(this.name != null) this.name.SetValue(this.theEntity.name);
			if(this.password != null) this.password.SetValue(this.theEntity.password);
			if(this.description != null) this.description.SetValue(this.theEntity.description);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.loginId != null) this.theEntity.loginId = StringUtil.StringValue(this.loginId.GetValue());
			if(this.name != null) this.theEntity.name = StringUtil.StringValue(this.name.GetValue());
			if(this.password != null) this.theEntity.password = StringUtil.StringValue(this.password.GetValue());
			if(this.description != null) this.theEntity.description = StringUtil.StringValue(this.description.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.loginId != null) this.loginId.UpdateField();
			if(this.name != null) this.name.UpdateField();
			if(this.password != null) this.password.UpdateField();
			if(this.description != null) this.description.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.loginId != null){
			    if(!this.loginId.Validate()){
				    valid = false;
				    this.messages.Add(this.loginId.ErrorMessage);
			    }
			}
			
			if(this.name != null){
			    if(!this.name.Validate()){
				    valid = false;
				    this.messages.Add(this.name.ErrorMessage);
			    }
			}
			
			if(this.password != null){
			    if(!this.password.Validate()){
				    valid = false;
				    this.messages.Add(this.password.ErrorMessage);
			    }
			}
			
			if(this.description != null){
			    if(!this.description.Validate()){
				    valid = false;
				    this.messages.Add(this.description.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private AuthUsersFormAdapter formAdapter;
    //     private AuthUsersProperty property;
    //     private AuthUsersEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new AuthUsersFormAdapter();

	
    formAdapter.loginId= new TextBoxAdapterElement(
        loginId,
        new CFW.Forms.Filters.StringFilter(property.loginId),
        CFW.Validators.FieldValidator.GetInstance(property.loginId)
    );
	
    formAdapter.name= new TextBoxAdapterElement(
        name,
        new CFW.Forms.Filters.StringFilter(property.name),
        CFW.Validators.FieldValidator.GetInstance(property.name)
    );
	
    formAdapter.password= new TextBoxAdapterElement(
        password,
        new CFW.Forms.Filters.StringFilter(property.password),
        CFW.Validators.FieldValidator.GetInstance(property.password)
    );
	
    formAdapter.description= new TextBoxAdapterElement(
        description,
        new CFW.Forms.Filters.StringFilter(property.description),
        CFW.Validators.FieldValidator.GetInstance(property.description)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}