using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Reflection;

using System.DirectoryServices;
using System.DirectoryServices.Protocols;

using CFW.common;
namespace LdapTest
{
    public partial class Form1 : Form
    {
        string ldapPrincipal;
        string ldapHost;
        string ldapCredential;
        LdapConnection ldap;
        
        public Form1()
        {
            InitializeComponent();

            ldapHost = CFW.common.Config.ConfigFile.GetAppSettingString("ldapHost");
            ldapPrincipal = CFW.common.Config.ConfigFile.GetAppSettingString("ldapPrincipal");
            ldapCredential = CFW.common.Config.ConfigFile.GetAppSettingString("ldapCredential");

            createTree("");
        }
        void createTree(string dn)
        {
            try
            {
                ldap = new LdapConnection(ldapHost);
                ldap.AuthType = AuthType.Basic;
                ldap.Bind(new System.Net.NetworkCredential(ldapPrincipal, ldapCredential));

                string filter = "(objectClass=*)";
                SearchRequest request = new SearchRequest("dc=craft-net,dc=co,dc=jp",filter,System.DirectoryServices.Protocols.SearchScope.OneLevel,null);

                SearchResponse response = (SearchResponse)ldap.SendRequest(request);


                foreach (SearchResultEntry r in response.Entries)
                {

                    TreeNode n = new TreeNode();
                    n.Text = r.DistinguishedName;
                    n.Tag = r.DistinguishedName;
                    SearchRequest request2 = new SearchRequest(r.DistinguishedName, filter, System.DirectoryServices.Protocols.SearchScope.OneLevel, null);
                    SearchResponse response2 = (SearchResponse)ldap.SendRequest(request2);
                    foreach (SearchResultEntry r2 in response2.Entries)
                    {
                        TreeNode child = new TreeNode();
                        child.Text = r2.DistinguishedName;
                        child.Tag = r2.DistinguishedName;
                        n.Nodes.Add(child);

                    }                    

                    treeView1.Nodes.Add(n);
                }


            }
            catch (Exception ex)
            {
                
                throw;
            }

        }
        /// <summary>
        /// LDAPʂvpeBǂݎ
        /// </summary>
        /// <param name="result">LDAP</param>
        /// <param name="propertyName">wvpeB</param>
        /// <returns>vpeB΂̓e𕶎񉻁AȂ΋󕶎</returns>
        string getProperty(SearchResult result, string propertyName)
        {
            ResultPropertyValueCollection col = result.Properties[propertyName];
            if (col == null) return "";
            if (col.Count == 0) return "";

            if (col[0] == null) return "";
            if (col[0] is string) return StringUtil.StringValue(col[0]);
            if (col[0] is byte[]) return System.Text.Encoding.ASCII.GetString((byte[])col[0]);

            return "";
        }

        private void treeView1_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            TreeNode node = e.Node;
            string tag = (string)node.Tag;

            textBox1.Text = tag;
            DataTable t = new DataTable();
            t.Columns.Add("attrName");
            t.Columns.Add("attrValue");

            Dictionary<string, object> list = new Dictionary<string, object>();

            SearchRequest request2 = new SearchRequest(tag, "objectClass=*", System.DirectoryServices.Protocols.SearchScope.Base, null);
            SearchResponse response2 = (SearchResponse)ldap.SendRequest(request2);
            Encoding enc = Encoding.GetEncoding("utf-8");
            SearchResultEntry entry = response2.Entries[0];
            foreach (string k  in entry.Attributes.AttributeNames)
            {
                DirectoryAttribute da = entry.Attributes[k];
                IEnumerator attrValueEnum = da.GetEnumerator();
                while (attrValueEnum.MoveNext())
                {
                    DataRow row = t.NewRow();
                    row["attrName"] = da.Name;

                    row["attrValue"] = enc.GetString( (byte[]) attrValueEnum.Current );

                    t.Rows.Add(row);
                }
            }

            dataGridView1.DataSource = t;
            dataGridView1.Refresh();
            

        }

    }
}