﻿<%@ Page Language="C#" MasterPageFile="~/Basic.master" AutoEventWireup="true" CodeFile="Cart.aspx.cs" Inherits="Cart" Title="カート" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
    <asp:Panel ID="cartView" runat="server" CssClass="cartView">
    <asp:Label ID="message" runat="server"></asp:Label>
    <asp:GridView ID="cartItems" runat="server" AutoGenerateColumns="False" ShowFooter="True"  GridLines="None" FooterStyle-CssClass="footer">
        <Columns>
            <asp:TemplateField  ItemStyle-BorderWidth="0"
             >
                <HeaderTemplate>商品</HeaderTemplate>
                <ItemTemplate><%# HttpUtility.HtmlEncode(DataBinder.Eval(Container.DataItem, "ProductName").ToString())%></ItemTemplate>
                <FooterTemplate>合計</FooterTemplate>
            </asp:TemplateField>
            <asp:TemplateField  ItemStyle-Width="10em" ItemStyle-CssClass="num">
                <HeaderTemplate>ご注文数</HeaderTemplate>
                <ItemTemplate><%# HttpUtility.HtmlEncode(CFW.Util.NumberUtil.Format(DataBinder.Eval(Container.DataItem, "Quantity"),"#,##0"))%>個</ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField ItemStyle-Width="10em" ItemStyle-CssClass="money" FooterStyle-CssClass="money" FooterStyle-Font-Bold="true">
                <HeaderTemplate>金額</HeaderTemplate>
                <ItemTemplate>@<%# HttpUtility.HtmlEncode(CFW.Util.NumberUtil.Format(DataBinder.Eval(Container.DataItem, "UnitPrice"),"#,##0"))%><br />
                <%# HttpUtility.HtmlEncode(CFW.Util.NumberUtil.Format(DataBinder.Eval(Container.DataItem, "Price"),"#,##0"))%>円
                </ItemTemplate>
                <FooterTemplate><%# HttpUtility.HtmlEncode(CFW.Util.NumberUtil.Format(TotalPrice,"#,##0" ))%>円</FooterTemplate>
            </asp:TemplateField>
        </Columns>
    </asp:GridView>
    </asp:Panel>
	<asp:Button ID="Settlement" runat="server" Text="この内容で清算"  PostBackUrl="~/Settlement.aspx"/>
    
</asp:Content>

