using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;
using Konozama.Shop.Model.TableProperty;

namespace Konozama.Shop.Model.TableRow
{
    /// <summary>
    /// table orders Field`
    /// </summary>
    [Serializable()]
    public class OrdersTableRow : CFW.Models.Entity, ICloneable
    {
        ///<summary>[id]</summary>
        protected Int32 _Id;
        ///<summary>[id]</summary>
        public Int32 Id{
            get{return _Id;}
            set{_Id = value;}
        }
        ///<summary>[customer_id]</summary>
        protected Int32 _CustomerId;
        ///<summary>[customer_id]</summary>
        public Int32 CustomerId{
            get{return _CustomerId;}
            set{_CustomerId = value;}
        }
        ///<summary>[order_date]</summary>
        protected object _OrderDate;
        ///<summary>[order_date]</summary>
        public object OrderDate{
            get{return _OrderDate;}
            set{_OrderDate = value;}
        }
        ///<summary>[payment_method]</summary>
        protected System.Nullable<Int32> _PaymentMethod;
        ///<summary>[payment_method]</summary>
        public System.Nullable<Int32> PaymentMethod{
            get{return _PaymentMethod;}
            set{_PaymentMethod = value;}
        }
        ///<summary>[delivery_place]</summary>
        protected string _DeliveryPlace;
        ///<summary>[delivery_place]</summary>
        public string DeliveryPlace{
            get{return _DeliveryPlace;}
            set{_DeliveryPlace = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public OrdersTableRow() : base()
        {
            _Id = 0;
            _CustomerId = 0;
            _OrderDate = null;
            _PaymentMethod = null;
            _DeliveryPlace = "";
            
        }
        
        /// <summary>
        /// DataRowWJč\z
        /// </summary>
        public override void Map(DataRow row,string alias)
        {
            string columnName = "";
            columnName = BuildColumnName(alias, "id");if(ColumnExists(row,columnName)) _Id = NumberUtil.Value<Int32>( row[columnName] );
            columnName = BuildColumnName(alias, "customer_id");if(ColumnExists(row,columnName)) _CustomerId = NumberUtil.Value<Int32>( row[columnName] );
            columnName = BuildColumnName(alias, "order_date");if(ColumnExists(row,columnName)) _OrderDate = DateUtil.DateValue( row[columnName] );
            columnName = BuildColumnName(alias, "payment_method");if(ColumnExists(row,columnName)) _PaymentMethod = NumberUtil.Value<Int32?>( row[columnName] );
            columnName = BuildColumnName(alias, "delivery_place");if(ColumnExists(row,columnName)) _DeliveryPlace = StringUtil.StringValue( row[columnName] );
            
        }
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "id") _Id = NumberUtil.Value<Int32>( value );
            if(name ==  "customer_id") _CustomerId = NumberUtil.Value<Int32>( value );
            if(name ==  "order_date") _OrderDate = DateUtil.DateValue( value );
            if(name ==  "payment_method") _PaymentMethod = NumberUtil.Value<Int32?>( value );
            if(name ==  "delivery_place") _DeliveryPlace = StringUtil.StringValue( value );
            
        }
        public override object GetValue(string name)
        {
            throw new Exception("The method or operation is not implemented.");
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            OrdersTableRow clone = new OrdersTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(OrdersTableRow source)
        {
            this.Id = source.Id;
            this.CustomerId = source.CustomerId;
            this.OrderDate = source.OrderDate;
            this.PaymentMethod = source.PaymentMethod;
            this.DeliveryPlace = source.DeliveryPlace;
            
        }
    }

}