using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;
using Konozama.Shop.Model.TableProperty;

namespace Konozama.Shop.Model.TableRow
{
    /// <summary>
    /// table categories Field`
    /// </summary>
    [Serializable()]
    public class CategoriesTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[id]</summary>
        protected Int32 _Id;
        ///<summary>[id]</summary>
        public Int32 Id{
            get{return _Id;}
            set{_Id = value;}
        }
        ///<summary>[name]</summary>
        protected string _Name;
        ///<summary>[name]</summary>
        public string Name{
            get{return _Name;}
            set{_Name = value;}
        }
        ///<summary>[left_side]</summary>
        protected System.Nullable<Int32> _LeftSide;
        ///<summary>[left_side]</summary>
        public System.Nullable<Int32> LeftSide{
            get{return _LeftSide;}
            set{_LeftSide = value;}
        }
        ///<summary>[right_side]</summary>
        protected System.Nullable<Int32> _RightSide;
        ///<summary>[right_side]</summary>
        public System.Nullable<Int32> RightSide{
            get{return _RightSide;}
            set{_RightSide = value;}
        }
        ///<summary>[description]</summary>
        protected string _Description;
        ///<summary>[description]</summary>
        public string Description{
            get{return _Description;}
            set{_Description = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public CategoriesTableRow() : base()
        {
            _Id = 0;
            _Name = "";
            _LeftSide = null;
            _RightSide = null;
            _Description = "";
            
        }
        
        /// <summary>
        /// DataRowWJč\z
        /// </summary>
        public override void Map(DataRow row,string alias)
        {
            string columnName = "";
            columnName = BuildColumnName(alias, "id");if(ColumnExists(row,columnName)) _Id = NumberUtil.Value<Int32>( row[columnName] );
            columnName = BuildColumnName(alias, "name");if(ColumnExists(row,columnName)) _Name = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "left_side");if(ColumnExists(row,columnName)) _LeftSide = NumberUtil.Value<Int32?>( row[columnName] );
            columnName = BuildColumnName(alias, "right_side");if(ColumnExists(row,columnName)) _RightSide = NumberUtil.Value<Int32?>( row[columnName] );
            columnName = BuildColumnName(alias, "description");if(ColumnExists(row,columnName)) _Description = StringUtil.StringValue( row[columnName] );
            
        }
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "id") _Id = NumberUtil.Value<Int32>( value );
            if(name ==  "name") _Name = StringUtil.StringValue( value );
            if(name ==  "left_side") _LeftSide = NumberUtil.Value<Int32?>( value );
            if(name ==  "right_side") _RightSide = NumberUtil.Value<Int32?>( value );
            if(name ==  "description") _Description = StringUtil.StringValue( value );
            
        }
        public override object GetValue(string name)
        {
            throw new Exception("The method or operation is not implemented.");
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            CategoriesTableRow clone = new CategoriesTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(CategoriesTableRow source)
        {
            this.Id = source.Id;
            this.Name = source.Name;
            this.LeftSide = source.LeftSide;
            this.RightSide = source.RightSide;
            this.Description = source.Description;
            
        }
    }

}