using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;

namespace Konozama.Shop.Model.TableProperty
{
    /// <summary>
    /// table categoriesɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class CategoriesTableProperty : FieldPropertiesBase
    {
    	///<summary>ftHg̃e[u</summary>
    	string DefaultTableName;
		///<summary>[id]</summary>
		public FieldProperty Id;
		///<summary>[name]</summary>
		public FieldProperty Name;
		///<summary>[left_side]</summary>
		public FieldProperty LeftSide;
		///<summary>[right_side]</summary>
		public FieldProperty RightSide;
		///<summary>[description]</summary>
		public FieldProperty Description;
		

	    /// <summary>
	    /// default construct
	    /// </summary>
        public CategoriesTableProperty()
        {
        	this.DefaultTableName = "categories";
			Id = FieldProperty.NewInstance("int", "categories", "id","[id]", 4, 10, 0, false, 0,true);
			Name = FieldProperty.NewInstance("varchar", "categories", "name","[name]", 100, 0, 0, true, "",false);
			LeftSide = FieldProperty.NewInstance("int", "categories", "left_side","[left_side]", 4, 10, 0, true, null,false);
			RightSide = FieldProperty.NewInstance("int", "categories", "right_side","[right_side]", 4, 10, 0, true, null,false);
			Description = FieldProperty.NewInstance("varchar", "categories", "description","[description]", 500, 0, 0, true, "",false);
			
        }

	    /// <summary>
	    /// DoUpdateꊇݒ
	    /// </summary>
	    /// <param name="doUpdate">ݒl</param>
        public void SetUpdate()
        {
        	this.SetUpdate(true);
        }
	    /// <summary>
	    /// DoUpdateꊇݒ
	    /// </summary>
	    /// <param name="doUpdate">ݒl</param>
        public void SetUpdate(bool doUpdate)
        {
			Id.DoUpdate = doUpdate;
			Name.DoUpdate = doUpdate;
			LeftSide.DoUpdate = doUpdate;
			RightSide.DoUpdate = doUpdate;
			Description.DoUpdate = doUpdate;
			
        }
	    /// <summary>
	    /// TableNameꊇݒ
	    /// TableCommandgꍇAliasꊇݒ肷B
	    /// </summary>
	    /// <param name="alias">Vɐݒ肷e[u</param>
        public void SetTableName(string alias)
        {
			Id.TableName = alias;
			Name.TableName = alias;
			LeftSide.TableName = alias;
			RightSide.TableName = alias;
			Description.TableName = alias;
			
        }
	    /// <summary>
	    /// TableName߂
	    /// </summary>
        public void ResetTableName()
        {
        	this.SetTableName(this.DefaultTableName);
        }
	    /// <summary>
	    /// e[uIR}hɑSĂ̗I悤Ɏw
	    /// </summary>
        public void SetSelectTo(ref CFW.Database.TableCommand.TableSelectCommand command)
        {
			command.AddSelect(this.Id);
			command.AddSelect(this.Name);
			command.AddSelect(this.LeftSide);
			command.AddSelect(this.RightSide);
			command.AddSelect(this.Description);
			
        }
    }
}