using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;
using Konozama.Shop.Model.TableProperty;
using Konozama.Shop.Model.TableValidator;


namespace Konozama.Shop.Model.TableFormAdapter
{
    /// <summary>
    /// table products Field`
    /// </summary>
    public class ProductsTableFormAdapter : CFW.Forms.FormAdapter
	{
		private ProductsTableRow table;

		///<summary>[id]</summary>
		public FormAdapterElement Id;
		///<summary>[name]</summary>
		public FormAdapterElement Name;
		///<summary>[unit_price]</summary>
		public FormAdapterElement UnitPrice;
		///<summary>[description]</summary>
		public FormAdapterElement Description;
		///<summary>[category_id]</summary>
		public FormAdapterElement CategoryId;
		

        public override CFW.Models.Entity GetEntity()
        {
            return this.table;
        }

        public override void RenderView()
        {
			this.Id.Render();
			this.Name.Render();
			this.UnitPrice.Render();
			this.Description.Render();
			this.CategoryId.Render();
			
        }

        public override void SetEntity(CFW.Models.Entity dataSource)
        {
        	this.table = (ProductsTableRow)dataSource;
			this.Id.SetValue(this.table.Id);
			this.Name.SetValue(this.table.Name);
			this.UnitPrice.SetValue(this.table.UnitPrice);
			this.Description.SetValue(this.table.Description);
			this.CategoryId.SetValue(this.table.CategoryId);
			

        }

        public override void UpdateEntity()
        {
			this.table.Id = NumberUtil.Value<Int32>(this.Id.GetValue());
			this.table.Name = StringUtil.StringValue(this.Name.GetValue());
			this.table.UnitPrice = NumberUtil.Value<Decimal?>(this.UnitPrice.GetValue());
			this.table.Description = StringUtil.StringValue(this.Description.GetValue());
			this.table.CategoryId = NumberUtil.Value<Int32?>(this.CategoryId.GetValue());
			
        }

        public override void UpdateFields()
        {
			this.Id.UpdateField();
			this.Name.UpdateField();
			this.UnitPrice.UpdateField();
			this.Description.UpdateField();
			this.CategoryId.UpdateField();
			
        }

        public override bool Validate()
        {
            bool valid = true;
			if(!this.Id.Validate()) valid = false;
			if(!this.Name.Validate()) valid = false;
			if(!this.UnitPrice.Validate()) valid = false;
			if(!this.Description.Validate()) valid = false;
			if(!this.CategoryId.Validate()) valid = false;
			

            return valid;
        }
		
	}

}