using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;
using Konozama.Shop.Model.TableProperty;
using Konozama.Shop.Model.TableValidator;


namespace Konozama.Shop.Model.TableFormAdapter
{
    /// <summary>
    /// table categories Field`
    /// </summary>
    public class CategoriesTableFormAdapter : CFW.Forms.FormAdapter
	{
		private CategoriesTableRow table;

		///<summary>[id]</summary>
		public FormAdapterElement Id;
		///<summary>[name]</summary>
		public FormAdapterElement Name;
		///<summary>[left_side]</summary>
		public FormAdapterElement LeftSide;
		///<summary>[right_side]</summary>
		public FormAdapterElement RightSide;
		///<summary>[description]</summary>
		public FormAdapterElement Description;
		
        
        public override void RenderView()
        {
			this.Id.Render();
			this.Name.Render();
			this.LeftSide.Render();
			this.RightSide.Render();
			this.Description.Render();
			
        }


        public override void UpdateFields()
        {
			this.Id.UpdateField();
			this.Name.UpdateField();
			this.LeftSide.UpdateField();
			this.RightSide.UpdateField();
			this.Description.UpdateField();
			
        }

        public override bool Validate()
        {
            bool valid = true;
			if(!this.Id.Validate()) valid = false;
			if(!this.Name.Validate()) valid = false;
			if(!this.LeftSide.Validate()) valid = false;
			if(!this.RightSide.Validate()) valid = false;
			if(!this.Description.Validate()) valid = false;
			

            return valid;
        }


        public override void SetEntity(CFW.Models.Entity entity)
        {
            this.table = entity as CategoriesTableRow;
        }

        public override CFW.Models.Entity GetEntity()
        {
            return this.table;
        }

        public override void UpdateEntity()
        {
            this.table.Id = NumberUtil.Value<Int32>(this.Id.GetValue());
            this.table.Name = StringUtil.StringValue(this.Name.GetValue());
            this.table.LeftSide = NumberUtil.Value<Int32?>(this.LeftSide.GetValue());
            this.table.RightSide = NumberUtil.Value<Int32?>(this.RightSide.GetValue());
            this.table.Description = StringUtil.StringValue(this.Description.GetValue());
        }
    }

}