using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Xml;
using System.Xml.Serialization;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.TableCommand;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;
using Konozama.Shop.Model.TableProperty;


namespace Konozama.Shop.Model.TableAccess
{
    /// <summary>
    /// table[categories]ɑ΂鑀
    /// </summary>
    [Serializable()]
    public class CategoriesTableAccess
    {
        /// <summary>
        /// f[^\[Xւ̐ڑ
        /// </summary>
        private Connection connection;
        /// <summary>
        /// categoriesɑΉvpeB
        /// </summary>
        private CategoriesTableProperty property;



#region constructors
        /// <summary>
        /// default construct  gps
        /// </summary>
        private CategoriesTableAccess()
        {
            this.connection = ConnectionFactory.GetConnectionByName("default");
            this.property = new CategoriesTableProperty();
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        public CategoriesTableAccess(Connection db)
        {
            this.connection = db;
            this.property = new  CategoriesTableProperty();
        }
        /// <summary>
        /// ̐ڑAvpeBgp\z
        /// </summary>
        /// <param name="db">̐ڑBJĂO</param>
        public CategoriesTableAccess(Connection db, CategoriesTableProperty property)
        {
            this.connection = db;
            this.property = property;
        }
#endregion

#region public interface
        /// <summary>
        /// categories֍s̑}
        /// </summary>
        /// <param name="data">}sf[^</param>
        public int Insert(CategoriesTableRow data)
        {
            TableInsertCommand command = BuildInsertCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }

        /// <summary>
        /// categories֍s̍XV
        /// </summary>
        /// <param name="data">XVsf[^</param>
        public int Update(CategoriesTableRow data)
        {
            TableUpdateCommand command = BuildUpdateCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// categories֍s̍XV
        /// </summary>
        /// <remarks>where͌ĂяogݗāAp[^Ăяo</remarks>
        /// <param name="data">XVsf[^</param>
        /// <param name="condition"></param>
        public int Update(CategoriesTableRow data,  TableCommandCondition condition)
        {
            TableUpdateCommand command = BuildUpdateCommand(data,condition);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// categoriess̍폜
        /// </summary>
        /// <param name="data">폜sf[^BL[̂݃ZbgłĂOK</param>
        public int Delete(CategoriesTableRow data)
        {
            TableDeleteCommand command = BuildDeleteCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// categoriess̍폜
        /// </summary>
        /// <remarks>where͌ĂяogݗāAp[^Ăяo
        /// <param name="condition"></param>
        public int Delete(TableCommandCondition condition)
        {
            TableDeleteCommand command = BuildDeleteCommand(condition);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// categories̍s݊mF
        /// </summary>
        /// <param name="data">L[ݒ肵f[^</param>
        /// <return>ݒ肵L[ɊYs݂鎞true</return>
        public bool Exists(CategoriesTableRow data)
        {
            TableSelectCommand command = BuildExistsCommand(data);
            DataSet result = connection.ExecuteQuery(command.GetCommand());

            int cnt = NumberUtil.IntValue(result.Tables[0].Rows[0][0]);
            if(cnt > 0) return true;
            else return false;
        }
        /// <summary>
        /// categories̍s擾
        /// L[1s擾B
        /// قƂǂ̃NCAg͎gpȂ͂AeXgpƂĎgp\
        /// </summary>
        /// <param name="condition">L[ݒ肵f[^</param>
        public CategoriesTableRow Get(CategoriesTableRow condition)
        {
            TableSelectCommand command = BuildSelectCommand(condition);
            DataSet result = connection.ExecuteQuery(command.GetCommand());

            CategoriesTableRow data = null;

            if(result.Tables[0].Rows.Count>0){
                data = new CategoriesTableRow();
                data.Map(result.Tables[0].Rows[0],"categories");
                data.IsNew = false;
            }
            return data;
        }
        /// <summary>
        /// categories̍s擾
        /// [U[ݒɊYsׂĎ擾B
        /// قƂǂ̃NCAg͎gpȂ͂AeXgpƂĎgp\
        /// </summary>
        /// <param name="condition">WHERE</param>
        /// <param name="order">\[g</param>
        public List<CategoriesTableRow> GetList( TableCommandCondition condition,List<TableCommandColumn> order)
        {
            CategoriesTableRow data = null;

            TableSelectCommand command = BuildSelectCommand(condition,order);

            DataSet result = connection.ExecuteQuery(command.GetCommand());

			List<CategoriesTableRow> list = new List<CategoriesTableRow>();
            if(result.Tables[0].Rows.Count>0){
                for (int i = 0; i < result.Tables[0].Rows.Count; i++)
                {
	                data = new CategoriesTableRow();
	                data.Map(result.Tables[0].Rows[0],"categories");
                    data.IsNew = false;
                    list.Add(data);
                }
            }
            return list;
        }
#endregion
        /// <summary>
        /// categoriesւinsert sqlR}h
        /// </summary>
        /// <param name="data">ǉf[^</param>
        public TableInsertCommand BuildInsertCommand(CategoriesTableRow data)
        {
            TableInsertCommand command = new TableInsertCommand("categories");

            if (property.Id.DoUpdate) command.AddInsert(property.Id, data.Id);
            if (property.Name.DoUpdate) command.AddInsert(property.Name, data.Name);
            if (property.LeftSide.DoUpdate) command.AddInsert(property.LeftSide, data.LeftSide);
            if (property.RightSide.DoUpdate) command.AddInsert(property.RightSide, data.RightSide);
            if (property.Description.DoUpdate) command.AddInsert(property.Description, data.Description);
            
            return command;
        }
        /// <summary>
        /// categoriesւupdate sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">ύXf[^</param>
        public TableUpdateCommand BuildUpdateCommand(CategoriesTableRow data)
        {
            TableUpdateCommand command = new TableUpdateCommand("categories");

            //XV`
            if (property.Id.DoUpdate) command.AddUpdate(property.Id, data.Id);
            if (property.Name.DoUpdate) command.AddUpdate(property.Name, data.Name);
            if (property.LeftSide.DoUpdate) command.AddUpdate(property.LeftSide, data.LeftSide);
            if (property.RightSide.DoUpdate) command.AddUpdate(property.RightSide, data.RightSide);
            if (property.Description.DoUpdate) command.AddUpdate(property.Description, data.Description);
            

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            
            return command;
        }

        /// <summary>
        /// categoriesւ̍XVSqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="data">ύXf[^</param>
        /// <param name="condition">Ώۏ</param>
        public TableUpdateCommand BuildUpdateCommand(CategoriesTableRow data, TableCommandCondition condition)
        {
            TableUpdateCommand command = new TableUpdateCommand("categories");

            //XV`
            if (property.Id.DoUpdate) command.AddUpdate(property.Id, data.Id);
            if (property.Name.DoUpdate) command.AddUpdate(property.Name, data.Name);
            if (property.LeftSide.DoUpdate) command.AddUpdate(property.LeftSide, data.LeftSide);
            if (property.RightSide.DoUpdate) command.AddUpdate(property.RightSide, data.RightSide);
            if (property.Description.DoUpdate) command.AddUpdate(property.Description, data.Description);
            

            //XV`
            command.AddWhere(condition);

            return command;
        }

        /// <summary>
        /// categoriesւselect sqlR}h(WHERE͊O炤
        /// </summary>
        /// <param name="condition">Ώۏ</param>
        public TableDeleteCommand BuildDeleteCommand(TableCommandCondition condition)
        {
            TableDeleteCommand command = new TableDeleteCommand("categories");


            //XV`
            command.AddWhere(condition);

            return command;
        }
        /// <summary>
        /// categoriesւdelete sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableDeleteCommand BuildDeleteCommand(CategoriesTableRow data)
        {
            TableDeleteCommand command = new TableDeleteCommand("categories");

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// categoriesւselect count(*)(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableSelectCommand BuildExistsCommand(CategoriesTableRow data)
        {
            TableSelectCommand command = new TableSelectCommand("categories");

            //XV`
            command.AddSelect(new TableCommandColumn("CNT","COUNT(*)"));

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// categoriesւselect sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableSelectCommand BuildSelectCommand(CategoriesTableRow data)
        {
            TableSelectCommand command = new TableSelectCommand("categories");

            //XV`
            command.AddSelect(property.Id);
            command.AddSelect(property.Name);
            command.AddSelect(property.LeftSide);
            command.AddSelect(property.RightSide);
            command.AddSelect(property.Description);
            

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// categoriesւselect sqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="condition">Ώۏ</param>
        /// <param name="order">\[g</param>
        public TableSelectCommand BuildSelectCommand(TableCommandCondition condition,List<TableCommandColumn> order)
        {
            TableSelectCommand command = new TableSelectCommand("categories");

            //XV`
            command.AddSelect(property.Id);
            command.AddSelect(property.Name);
            command.AddSelect(property.LeftSide);
            command.AddSelect(property.RightSide);
            command.AddSelect(property.Description);
            

            //XV`
            if(condition != null)   command.AddWhere(condition);
            //
            if (order != null) command.OrderBy.AddRange(order);

            return command;
        }
        /// <summary>
        /// categoriesselect list
        /// </summary>
        /// <param name="tableAlias">e[uɕtʖ</param>
        /// <param name="columnAliasPrefix">ɕtʖ̐ړ</param>
        public string  GetSelectListString(string tableAlias , string columnAliasPrefix)
        {
        	StringBuilder builder = new StringBuilder();

            //XV`
            builder.AppendLine(", "+ tableAlias + ".id AS " + columnAliasPrefix + "id" );
            builder.AppendLine(", "+ tableAlias + ".name AS " + columnAliasPrefix + "name" );
            builder.AppendLine(", "+ tableAlias + ".left_side AS " + columnAliasPrefix + "left_side" );
            builder.AppendLine(", "+ tableAlias + ".right_side AS " + columnAliasPrefix + "right_side" );
            builder.AppendLine(", "+ tableAlias + ".description AS " + columnAliasPrefix + "description" );
            

            return builder.ToString().Substring(1);
        }
    }
}
