using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;
using Konozama.Shop.Model.TableAccess;
using Konozama.Shop.Model.TableProperty;
using Konozama.Shop.Model.TableValidator;
using Konozama.Shop.Model.Entity;

namespace Konozama.Shop.Model.Access
{
    /// <summary>
    /// Products ANZX`
    /// </summary>
    [Serializable()]
	public class ProductsAccess
	{
        /// <summary>
        /// JeS[ʏiXg擾
        /// </summary>
        /// <param name="categoryId">ΏۃJeS[ID</param>
        /// <returns>YiXg</returns>
        public List<ProductsEntity> GetListByCategory(int categoryId)
        {
            Connection connection = ConnectionFactory.GetConnectionByName("default");
            connection.Open();
            try
            {
                Command command = new Command("select * from products where category_id=@category_id order by id", CommandType.Text);
                command.SetParameter(new Parameter("@category_id",DbType.Int32,categoryId));

                List<ProductsEntity> list = connection.ExecuteQueryAsTableRows<ProductsEntity>(command);
                return list;

            }
            finally
            {
                connection.Close();
            }

        }
        /// <summary>
        /// w菤i擾
        /// </summary>
        /// <param name="productId">ΏۏiID</param>
        /// <returns>Yi</returns>
        public ProductsEntity Get(int productId)
        {
            Connection connection = ConnectionFactory.GetConnectionByName("default");
            connection.Open();
            try
            {
                Command command = new Command("select * from products where id=@productId order by id", CommandType.Text);
                command.SetParameter(new Parameter("@productId", DbType.Int32, productId));

                List<ProductsEntity> list = connection.ExecuteQueryAsTableRows<ProductsEntity>(command);
                if (list.Count == 0) return null;
                else return list[0];

            }
            finally
            {
                connection.Close();
            }

        }
    }

}