using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.Util;
using CFW.Auth;
using CFW.Models;

namespace Hash
{
    public partial class Form1 : Form
    {
        List<String> validationMessages = new List<string>();

        public Form1()
        {
            InitializeComponent();
            initializeView();

        }
        void initializeView()
        {
            Models.Encodings encodingsModel = new Hash.Models.Encodings();
            encodingSelect.DisplayMember = "Name";
            encodingSelect.ValueMember = "Id";
            encodingSelect.DataSource = encodingsModel.getEncodings();

            Models.HashMethods hashMethodsModel = new Hash.Models.HashMethods();
            hashMethodSelect.DisplayMember = "Name";
            hashMethodSelect.ValueMember = "Id";
            hashMethodSelect.DataSource = hashMethodsModel.getHashMethods();

            passwordInput.Text = "";
            passwordRetypeInput.Text = "";
            hashResultText.Text = "";
            saltLengthInput.Enabled = false;
            saltLengthInput.Text = "8";
        }
        
        private void doHashButton_Click(object sender, EventArgs e)
        {
            
            if (!validateInput())
            {
                displayValidationMessage();
                return;
            }
            clearValidationMessage();

            doHash();
        }
        private bool validateInput()
        {
            bool valid = true;
            validationMessages.Clear();
            if (hashMethodSelect.SelectedIndex < 0)
            {
                valid = false;
                validationMessages.Add("select one or more from hash methods");
            }
            if (encodingSelect.SelectedIndex < 0)
            {
                valid = false;
                validationMessages.Add("select one or more from encoding");
            }
            if (passwordInput.Text.Trim() == "")
            {
                valid = false;
                validationMessages.Add("password required");
            }
            if (passwordRetypeInput.Text.Trim() == "")
            {
                valid = false;
                validationMessages.Add("password retype required");
            }

            if (passwordRetypeInput.Text.Trim() != passwordInput.Text.Trim())
            {
                valid = false;
                validationMessages.Add("password verification failed");
            }
            return valid;


        }
        void displayValidationMessage()
        {
            foreach(string message in validationMessages){
                validationMessageDisplay.AppendText(message + Environment.NewLine);
            }
        }
        void clearValidationMessage()
        {
            validationMessageDisplay.Text = "";
        }

        private void copyClipBoardButton_Click(object sender, EventArgs e)
        {
            Clipboard.SetText(hashResultText.Text, TextDataFormat.Text);
        }
        void doHash()
        {
            IEnumerationItem encoding = encodingSelect.SelectedItem as IEnumerationItem;
            IEnumerationItem hashMethod = hashMethodSelect.SelectedItem as IEnumerationItem;

            AbstractPasswordHash hash = AbstractPasswordHash.GetInstance(hashMethod.Id.ToString(), encoding.Id.ToString(),NumberUtil.Value<int>(saltLengthInput.Text));

            hashResultText.Text = hash.CreateHash(passwordInput.Text);
        }

        private void hashMethodSelect_SelectedIndexChanged(object sender, EventArgs e)
        {
            IEnumerationItem hashMethod = hashMethodSelect.SelectedItem as IEnumerationItem;
            if (hashMethod.idEqualsTo("SMD5") || hashMethod.idEqualsTo("SSHA"))
            {
                saltLengthInput.Enabled = true;
            }
            else
            {
                saltLengthInput.Enabled = false;
            }
        }
    }
}