using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace ErrorHandling
{
    public partial class SampleForm : Form
    {
        Forms.SampleFormAdapter formAdapter;
        Model.SampleEntity entity;
        public SampleForm()
        {
            InitializeComponent();
            resultLabel.Text = "";
            formAdapter = new Forms.SampleFormAdapter();

            formAdapter.valueA = new CFW.Windows.Forms.Adapters.TextBoxAdapterElement(
                this.textBox1,
                new CFW.Forms.Filters.NumberFilter<decimal>(),
                null
                );
            formAdapter.valueB = new CFW.Windows.Forms.Adapters.TextBoxAdapterElement(
                this.textBox2,
                new CFW.Forms.Filters.NumberFilter<decimal>(),
                null
                );
            entity = new Model.SampleEntity();
            formAdapter.SetDataSource(entity);
            formAdapter.RenderView();
        }

        private void addButton_Click(object sender, EventArgs e)
        {
            formAdapter.Bind();
            if (!formAdapter.IsValid)
            {
                resultLabel.Text = "vZł܂.";
                formAdapter.RenderView();//Bindʕ\
                return;
            }

            entity = formAdapter.GetDataSource() as Model.SampleEntity;

            resultLabel.Text = CFW.Util.NumberUtil.Format(entity.Add(),"#,##0.00");
            formAdapter.RenderView();

        }

        private void subtractButton_Click(object sender, EventArgs e)
        {
            formAdapter.Bind();
            if (!formAdapter.IsValid)
            {
                resultLabel.Text = "vZł܂.";
                formAdapter.RenderView();//Bindʕ\
                return;
            }

            entity = formAdapter.GetDataSource() as Model.SampleEntity;

            resultLabel.Text = CFW.Util.NumberUtil.Format(entity.Subtract(), "#,##0.00");
            formAdapter.RenderView();
        }

        private void multiplyButton_Click(object sender, EventArgs e)
        {
            formAdapter.Bind();
            if (!formAdapter.IsValid)
            {
                resultLabel.Text = "vZł܂.";
                formAdapter.RenderView();//Bindʕ\
                return;
            }

            entity = formAdapter.GetDataSource() as Model.SampleEntity;

            resultLabel.Text = CFW.Util.NumberUtil.Format(entity.Multiply(), "#,##0.00");
            formAdapter.RenderView();
        }

        private void divideButton_Click(object sender, EventArgs e)
        {
            formAdapter.Bind();
            if (!formAdapter.IsValid)
            {
                resultLabel.Text = "vZł܂.";
                formAdapter.RenderView();//Bindʕ\
                return;
            }

            entity = formAdapter.GetDataSource() as Model.SampleEntity;

            resultLabel.Text = CFW.Util.NumberUtil.Format(entity.Divide(), "#,##0.00");
            formAdapter.RenderView();

        }
    }
}