using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Remoting;  
using System.Runtime.Remoting.Messaging;  
using System.Runtime.Remoting.Proxies;  
using System.Runtime.Remoting.Activation;  
using System.Runtime.Remoting.Services;  
using System.Reflection;  

namespace Connection
{
    [BusinessLogicProxy()]
    public class BusinessLogic : ContextBoundObject
    {
        [TimeLimit]
        public string GetMessage1()
        {
            return DateTime.Now.ToString();
        }

        [TimeLimit]
        public string GetMessage2()
        {
            return DateTime.Now.DayOfWeek.ToString();
        }
    }
    public class BusinessLogicProxy : RealProxy  
    {
        private readonly MarshalByRefObject _target;  
          
        /// <summary>  
        /// RXgN^  
        /// </summary>  
        /// <param name="target">ΏۂBussinessLogicIuWFNg</param>  
        /// <param name="t">BussinessLogič^</param>  
        public BusinessLogicProxy(MarshalByRefObject target, Type t)
            : base(t)  
        {  
            _target = target;  
        }  
  
        /// <summary>  
        /// ۂ̃\bhĂяo܂B  
        /// </summary>  
        /// <param name="request">IMessage</param>  
        /// <returns>IMessage</returns>  
        public override IMessage Invoke(IMessage request)  
        {  
            IMessage response = null;  
  
            IMethodCallMessage call = (IMethodCallMessage)request;  
          
            IConstructionCallMessage ctor = call as IConstructionCallMessage;  
  
            if (ctor != null)   
            {  
                // CX^XȂꍇ́ARXgN^s  
                RealProxy rp = RemotingServices.GetRealProxy(_target);  
                rp.InitializeServerObject(ctor);  
                MarshalByRefObject tp = this.GetTransparentProxy() as MarshalByRefObject;  
                response = EnterpriseServicesHelper.CreateConstructionReturnMessage(ctor, tp);  
            }   
            else   
            {  
                response = Invoke(call);  
            }  
              
            return response;  
      
        }  
  
        /// <summary>  
        /// sۂ̔fsĂA\bhs܂B  
        /// </summary>  
        /// <param name="call">\bhR[bZ[W</param>  
        private IMessage Invoke(IMethodCallMessage call)  
        {  
            ReturnMessage response;  
  
            // 擾  
            TimeLimitAttribute timelimitAttr = GetAttribute(call.MethodBase);

            timelimitAttr.before(call.MethodName);
            //\bhs  
            response =  RemotingServices.ExecuteMessage(_target, call) as ReturnMessage;  
            if (response.Exception != null)  
            {  
                throw response.Exception;  
            }
            timelimitAttr.after(call.MethodName);
  
            return response;  
        }  
  
        /// <summary>  
        /// 擾܂B  
        /// </summary>  
        /// <param name="m">\bh</param>  
        /// <returns>\bhɕtĂ鑮Bw肪ȂꍇNullTimeLimitAttributeԂ܂B</returns>  
        private TimeLimitAttribute GetAttribute(MethodBase m)  
        {  
            object[] atts = m.GetCustomAttributes(true);  
            TimeLimitAttribute timelimitAttr = null;  
  
            if (atts.Length > 0)  
            {  
                timelimitAttr = atts[0] as TimeLimitAttribute;  
            }  
  
            if (timelimitAttr == null)   
            {  
                timelimitAttr = new NullTimeLimitAttribute();  
            }  
            return timelimitAttr;  
        }      
    }
    [AttributeUsage(AttributeTargets.Class)]
    public sealed class BusinessLogicProxyAttribute : ProxyAttribute
    {
        /// <summary>  
        /// RXgN^  
        /// </summary>  
        public BusinessLogicProxyAttribute()
        {
        }

        /// <summary>  
        /// ߃vLVIuWFNg𐶐܂B  
        /// </summary>  
        /// <param name="t">^[QbgNX̃^Cv</param>  
        /// <returns>߃vLVIuWFNg</returns>  
        public override MarshalByRefObject CreateInstance(Type t)
        {
            MarshalByRefObject target = base.CreateInstance(t) as MarshalByRefObject;

            BusinessLogicProxy proxy = new BusinessLogicProxy((BusinessLogic)target, t);
            return (MarshalByRefObject)proxy.GetTransparentProxy();
        }
    }


    public class TimeLimitAttribute : System.Attribute
    {
        static CFW.Log.Logger logger = CFW.Log.LoggerFactory.GetLogger("default", "Proxy");

        /// <summary>  
        /// pۂ𔻒f܂B  
        /// </summary>  
        public virtual bool CanInvoke()
        {
            bool canUse = false; //ps  
            DateTime now = DateTime.Now;

            if (now.Second < 30)
            {
                //ԊȌꍇ  
                canUse = true; //p  
            }
            return canUse;

        }

        /// <summary>  
        /// NCAgɕԂbZ[W쐬܂  
        /// </summary>  
        /// <returns>ps̂ƂɕԂbZ[W</returns>  
        public virtual string CreateResponse()
        {
            return "݁A̋@\͎g܂B";
        }
        public virtual void before(string methodName)
        {
            logger.Log(CFW.Log.LogLevel.INFO, methodName, "start");
        }
        public virtual void after(string methodName)
        {
            logger.Log(CFW.Log.LogLevel.INFO, methodName, "end");
        }
    }

    /// <summary>  
    /// ȂƂ錾܂B  
    /// tȂ\bhɓKp܂B  
    /// </summary>  
    public sealed class NullTimeLimitAttribute : TimeLimitAttribute
    {
        /// <summary>  
        /// RXgN^  
        /// </summary>  
        public NullTimeLimitAttribute() { }


        public override bool CanInvoke()
        {
            return true;//łp\  
        }

        public override string CreateResponse()
        {
            return null;
        }


    }  
}
