using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Sample.Test4;
using CFW.Sample.Test4.TableRow;

namespace CFW.Sample.Test4.TableProperty
{
    /// <summary>
    /// table usersɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class UsersTableProperty : FieldPropertiesBase
    {
    	///<summary>ftHg̃e[u</summary>
    	string DefaultTableName;
		///<summary>[user_id]</summary>
		public FieldProperty UserId;
		///<summary>[password]</summary>
		public FieldProperty Password;
		///<summary>[user_name]</summary>
		public FieldProperty UserName;
		///<summary>[num_fields]</summary>
		public FieldProperty NumFields;
		///<summary>[birthday]</summary>
		public FieldProperty Birthday;
		///<summary>[created_at]</summary>
		public FieldProperty CreatedAt;
		///<summary>[modified_at]</summary>
		public FieldProperty ModifiedAt;
		

	    /// <summary>
	    /// default construct
	    /// </summary>
        public UsersTableProperty()
        {
        	this.DefaultTableName = "users";
			UserId = FieldProperty.NewInstance("varchar", "users", "user_id","[user_id]", 50, 0, 0, false, "",true);
			Password = FieldProperty.NewInstance("varchar", "users", "password","[password]", 128, 0, 0, true, "",false);
			UserName = FieldProperty.NewInstance("varchar", "users", "user_name","[user_name]", 100, 0, 0, true, "",false);
			NumFields = FieldProperty.NewInstance("int", "users", "num_fields","[num_fields]", 4, 10, 0, true, null,false);
			Birthday = FieldProperty.NewInstance("datetime", "users", "birthday","[birthday]", 16, 23, 3, true, null,false);
			CreatedAt = FieldProperty.NewInstance("datetime", "users", "created_at","[created_at]", 16, 23, 3, true, null,false);
			ModifiedAt = FieldProperty.NewInstance("datetime", "users", "modified_at","[modified_at]", 16, 23, 3, true, null,false);
			
        }

	    /// <summary>
	    /// DoUpdateꊇݒ
	    /// </summary>
        public void SetUpdate()
        {
        	this.SetUpdate(true);
        }
	    /// <summary>
	    /// DoUpdateꊇݒ
	    /// </summary>
	    /// <param name="doUpdate">ݒl</param>
        public void SetUpdate(bool doUpdate)
        {
			UserId.DoUpdate = doUpdate;
			Password.DoUpdate = doUpdate;
			UserName.DoUpdate = doUpdate;
			NumFields.DoUpdate = doUpdate;
			Birthday.DoUpdate = doUpdate;
			CreatedAt.DoUpdate = doUpdate;
			ModifiedAt.DoUpdate = doUpdate;
			
        }
	    /// <summary>
	    /// TableNameꊇݒ
	    /// TableCommandgꍇAliasꊇݒ肷B
	    /// </summary>
	    /// <param name="alias">Vɐݒ肷e[u</param>
        public void SetTableName(string alias)
        {
			UserId.TableName = alias;
			Password.TableName = alias;
			UserName.TableName = alias;
			NumFields.TableName = alias;
			Birthday.TableName = alias;
			CreatedAt.TableName = alias;
			ModifiedAt.TableName = alias;
			
        }
	    /// <summary>
	    /// TableName߂
	    /// </summary>
        public void ResetTableName()
        {
        	this.SetTableName(this.DefaultTableName);
        }
	    /// <summary>
	    /// e[uIR}hɑSĂ̗I悤Ɏw
	    /// </summary>
        public void SetSelectTo(ref CFW.Database.TableCommand.TableSelectCommand command)
        {
			command.AddSelect(this.UserId);
			command.AddSelect(this.Password);
			command.AddSelect(this.UserName);
			command.AddSelect(this.NumFields);
			command.AddSelect(this.Birthday);
			command.AddSelect(this.CreatedAt);
			command.AddSelect(this.ModifiedAt);
			
        }
    }
}