using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Reflection;
using System.Threading;

namespace Menu2
{
    public partial class Form1 : Form
    {
        protected static CFW.common.Logger.AbstractLogger log = CFW.common.Logger.LoggerFactory.GetLogger("default", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName);
        Menu2.localhost.User user;
        DataSet menus;

        public Form1()
        {
            InitializeComponent();


            log.Debug(this.GetType().FullName + " start");

            log.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name + " stat initialize ");
            localhost.MenuAccess access = new localhost.MenuAccess();
            user = access.Login("test", "test");
            label1.Text = "hello " + user.UserName;

            menus = access.GetMenuList();
            menus.Tables[0].PrimaryKey = new DataColumn[] { menus.Tables[0].Columns["menu_id"] };
            log.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name + " stat createMenu");
            createMenu();
            log.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name + " end createMenu");

        }
        void createMenu()
        {
            if (menus == null) return;
            DataTable table = menus.Tables[0];
            DataRowCollection rows = table.Rows;
            int top = 0;
            foreach (DataRow row in rows)
            {
                Button b = new Button();
                b.Text = CFW.common.StringUtil.StringValue(row["menu_name"]);
                b.Width = 200;
                b.Height = 20;
                b.Top = top;
                b.Click += MenuButton_Click;
                b.Tag = CFW.common.StringUtil.StringValue(row["menu_id"]);
                panel1.Controls.Add(b);

                top += 21;
            }
        }
        void MenuButton_Click(object sender, EventArgs e)
        {
            Button b = (Button)sender;
            string id = (string)b.Tag;

            ExecuteMenu(id);
        }
        void ExecuteMenu(string id)
        {
            DataRow row = menus.Tables[0].Rows.Find(id);
            if (row == null) return;

            log.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name + " start");
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            string path = CFW.common.StringUtil.StringValue(row["path"]);
            string className = CFW.common.StringUtil.StringValue(row["form_name"]);
            Form frm = (Form)CFW.common.ClassLoader.CreateInstance(className, path);
            if (frm == null) return;

            sw.Stop();
            log.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name + " ellapsed=" + sw.Elapsed.Milliseconds.ToString());

            frm.ShowDialog();
            log.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name + " end");


        }

    }
}