﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Reflection;
namespace CoMenu2
{
    static class Program
    {
        static CFW.common.Logger.AbstractLogger log = CFW.common.Logger.LoggerFactory.GetLogger("default", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName);

        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            AppDomain currentDomain = AppDomain.CurrentDomain;
            currentDomain.AssemblyLoad += new AssemblyLoadEventHandler(MyAssemblyLoadEventHandler);

            PrintLoadedAssemblies(currentDomain);


            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Application.Run(new Form1());
        }
        static void PrintLoadedAssemblies(AppDomain domain)
        {
            log.Debug( "LOADED ASSEMBLIES:");
            foreach (Assembly a in domain.GetAssemblies())
            {
                log.Debug(a.FullName);
            }
            
        }

        static void MyAssemblyLoadEventHandler(object sender, AssemblyLoadEventArgs args)
        {
            log.Debug("ASSEMBLY LOADED: " + args.LoadedAssembly.FullName);
            log.Debug("ASSEMBLY CODEBASE: " + args.LoadedAssembly.CodeBase);
        }
    }
}