using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Models;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.Expressions;
using System.Reflection;

namespace Sample.Data.Models 
{
    /// <summary>
    /// MastSite f`
    /// </summary>
    [Serializable()]
	public class MastSiteModel : DbModel<MastSiteEntity,MastSiteProperty>
	{
        /// <summary>
        /// default construct  
        /// </summary>
        public MastSiteModel() : base()
        {
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        public MastSiteModel(Connection connection) : base(connection)
        {
        }
        /// <summary>
        /// ̐ڑAvpeBgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        /// <param name="property">̃vpeB</param>
        public MastSiteModel(Connection connection, MastSiteProperty property) : base(connection,property)
        {
        }
        public List<MastSiteEntity> findAll()
        {
            try
            {
                connect();
                MastSiteProperty siteTable = new MastSiteProperty();
                DataSource<MastSiteEntity> datasource = connection.getDataSource<MastSiteEntity>();
                datasource.setProperty(siteTable);
                ExpressionFactory ef = connection.getExpressionFactory();
                Criteria c = new Criteria();
                c.where(ef.columnValue(siteTable.validFlag, 1));
                //c.where(ef.columnValue(menuTable.validFlag, 1));
                //c.where(ef.columnValue(manuscriptTable.validFlag, 1));
                //c.where(ef.columnValue(siteTable.siteCode, "S0383"));//SɂĂ݂ĊmFB
                c.orderBy(siteTable.siteCode);
                c.limit = 1000;

                List<MastSiteEntity> sites = datasource.find(c);
                return sites;

            }
            finally
            {
                disconnect();
            }

        }
        public List<MastSiteEntity> findAll1()
        {
            try
            {
                connect();
                ExpressionFactory ef = connection.getExpressionFactory();
                MastSiteProperty siteTable = new MastSiteProperty();
                MastMenuProperty menuTable = new MastMenuProperty();
                MastManuscriptProperty manuscriptTable = new MastManuscriptProperty();

                AssociationSelect<MastSiteEntity> select = new AssociationSelect<MastSiteEntity>(connection);
                Association assoc = createAssociation();
                select.associate(assoc);
                select.from(siteTable);
                select.select(siteTable.siteCode);
                select.select(siteTable.name);
                select.select(menuTable.siteCode);
                select.select(menuTable.menuCode);
                select.select(menuTable.name);
                select.select(manuscriptTable.siteCode);
                select.select(manuscriptTable.menuCode);
                select.select(manuscriptTable.seq);
                select.select(manuscriptTable.fromDate);
                select.select(manuscriptTable.endDate);

                Criteria c = new Criteria();
                c.where(ef.columnValue(siteTable.validFlag, 1));
                //c.where(ef.columnValue(menuTable.validFlag, 1));
                //c.where(ef.columnValue(manuscriptTable.validFlag, 1));
                //c.where(ef.columnValue(siteTable.siteCode, "S0383"));//SɂĂ݂ĊmFB
                c.orderBy(siteTable.siteCode);
                c.orderBy(menuTable.menuCode);
                c.orderBy(manuscriptTable.seq);
                c.limit = 1000;
                select.setCriteria(c);

                List<MastSiteEntity> sites = select.queryAsEntity();
                return sites;

            }
            finally
            {
                disconnect();
            }
        }
        
        public List<MastSiteEntity> findAll2()
        {
            try
            {
                connect();
                ExpressionFactory ef = connection.getExpressionFactory();
                MastSiteProperty siteTable = new MastSiteProperty();
                MastMenuProperty menuTable = new MastMenuProperty();
                MastManuscriptProperty manuscriptTable = new MastManuscriptProperty();

                AssociationSelect<MastSiteEntity> select = new AssociationSelect<MastSiteEntity>(connection);
                Association assoc = createAssociation2();
                select.associate(assoc);
                select.from(siteTable);
                select.select(siteTable.siteCode);
                select.select(siteTable.name);
                select.select(menuTable.siteCode);
                select.select(menuTable.menuCode);
                select.select(menuTable.name);
                select.select(manuscriptTable.siteCode);
                select.select(manuscriptTable.menuCode);
                select.select(manuscriptTable.seq);
                select.select(manuscriptTable.fromDate);
                select.select(manuscriptTable.endDate);

                Criteria c = new Criteria();
                c.where(ef.columnValue(siteTable.validFlag, 1));
                //c.where(ef.columnValue(menuTable.validFlag, 1));
                //c.where(ef.columnValue(manuscriptTable.validFlag, 1));
                //c.where(ef.columnValue(siteTable.siteCode, "S0383"));//SɂĂ݂ĊmF
                c.orderBy(siteTable.siteCode);
                c.orderBy(menuTable.menuCode);
                c.orderBy(manuscriptTable.seq);
                c.limit = 1000;

                select.setCriteria(c);

                List<MastSiteEntity> sites = select.queryAsEntity();
                return sites;
                //Ƃ肠Alp̊{
                //return map(result);

            }
            finally
            {
                disconnect();
            }
        }
        public List<MastSiteEntity> findAll3()
        {
            try
            {
                connect();
                ExpressionFactory ef = connection.getExpressionFactory();
                MastSiteProperty siteTable = new MastSiteProperty();
                MastMenuProperty menuTable = new MastMenuProperty();
                MastManuscriptProperty manuscriptTable = new MastManuscriptProperty();

                AssociationSelect<MastSiteEntity> select = new AssociationSelect<MastSiteEntity>(connection);
                Association assoc = createAssociation2();
                select.associate(assoc);
                select.from(siteTable);
                select.select(siteTable.siteCode);
                select.select(siteTable.name);
                select.select(menuTable.siteCode);
                select.select(menuTable.menuCode);
                select.select(menuTable.name);
                select.select(manuscriptTable.siteCode);
                select.select(manuscriptTable.menuCode);
                select.select(manuscriptTable.seq);
                select.select(manuscriptTable.fromDate);
                select.select(manuscriptTable.endDate);

                Criteria c = new Criteria();
                c.where(ef.columnValue(siteTable.validFlag, 1));
                //c.where(ef.columnValue(menuTable.validFlag, 1));
                //c.where(ef.columnValue(manuscriptTable.validFlag, 1));
                //c.where(ef.columnValue(siteTable.siteCode, "S0383"));//SɂĂ݂ĊmF
                c.orderBy(siteTable.siteCode);
                c.orderBy(menuTable.menuCode);
                c.orderBy(manuscriptTable.seq);
                c.limit = 1000;

                select.setCriteria(c);

                DataSet result = select.query();


                List<MastSiteEntity> sites = map(result);
                return sites;

            }
            finally
            {
                disconnect();
            }
        }
        public List<MastSiteEntity> findAll4()
        {
            try
            {
                connect();
                string query = @"SELECT MAST_SITE.SITE_CODE AS MAST_SITE__SITE_CODE,MAST_SITE.NAME AS MAST_SITE__NAME,MAST_MENU.SITE_CODE AS MAST_MENU__SITE_CODE,MAST_MENU.MENU_CODE AS MAST_MENU__MENU_CODE,MAST_MENU.NAME AS MAST_MENU__NAME,MAST_MANUSCRIPT.SITE_CODE AS MAST_MANUSCRIPT__SITE_CODE,MAST_MANUSCRIPT.MENU_CODE AS MAST_MANUSCRIPT__MENU_CODE,MAST_MANUSCRIPT.SEQ AS MAST_MANUSCRIPT__SEQ,MAST_MANUSCRIPT.FROM_DATE AS MAST_MANUSCRIPT__FROM_DATE,MAST_MANUSCRIPT.END_DATE AS MAST_MANUSCRIPT__END_DATE FROM MAST_SITE LEFT JOIN MAST_MENU MAST_MENU ON MAST_SITE.SITE_CODE = MAST_MENU.SITE_CODE LEFT JOIN MAST_MANUSCRIPT MAST_MANUSCRIPT ON MAST_MENU.SITE_CODE = MAST_MANUSCRIPT.SITE_CODE AND MAST_MENU.MENU_CODE = MAST_MANUSCRIPT.MENU_CODE WHERE MAST_SITE.VALID_FLAG = @MAST_SITE__VALID_FLAG AND MAST_MENU.VALID_FLAG = @MAST_MENU__VALID_FLAG AND MAST_MANUSCRIPT.VALID_FLAG = @MAST_MANUSCRIPT__VALID_FLAG ORDER BY MAST_SITE.SITE_CODE ASC,MAST_MENU.MENU_CODE ASC,MAST_MANUSCRIPT.SEQ ASC";
                Command command = new Command(query);
                command.AddParameter(new Parameter("@MAST_SITE__VALID_FLAG",DbType.Int32,1));
                command.AddParameter(new Parameter("@MAST_MENU__VALID_FLAG",DbType.Int32,1));
                command.AddParameter(new Parameter("@MAST_MANUSCRIPT__VALID_FLAG",DbType.Int32,1));
                //command.AddParameter(new Parameter("@MAST_SITE__SITE_CODE",DbType.String,"S0383"));

                DataSet result = command.ExecuteQuery(connection);

                List<MastSiteEntity> sites = map(result);
                return sites;

            }
            finally
            {
                disconnect();
            }
        }
        Entity createMenu(DataRow row, string alias)
        {
            MastMenuEntity menu = new MastMenuEntity();
            menu.Map(row,alias);
            return menu;
        }
        Entity createManuscript(DataRow row,string alias)
        {
            MastManuscriptEntity manuscript = new MastManuscriptEntity();
            manuscript.Map(row,alias);
            return manuscript;
        }
        Association createAssociation()
        {
            MastSiteProperty siteTable = new MastSiteProperty();
            MastMenuProperty menuTable = new MastMenuProperty();
            MastManuscriptProperty manuscriptTable = new MastManuscriptProperty();

            ExpressionFactory ef = connection.getExpressionFactory();
            //site - menu - manuscript
            Association assoc = new Association(
                "menus",
                Association.Multiplicity.TO_MANY,
                new MastMenuProperty(),
                createMenu,
                ef.relation(siteTable.siteCode,menuTable.siteCode),
                ef.strings("MAST_MENU.VALID_FLAG = 1")
                );
            assoc.add(new Association(
                "manuscripts",
                Association.Multiplicity.TO_MANY,
                new MastManuscriptProperty(),
                createManuscript,
                ef.relation(menuTable.siteCode, manuscriptTable.siteCode),
                ef.relation(menuTable.menuCode,manuscriptTable.menuCode),
                ef.strings("MAST_MANUSCRIPT.VALID_FLAG = 1")
                ));
            return assoc;
        }
        Association createAssociation2()
        {
            MastSiteProperty siteTable = new MastSiteProperty();
            MastMenuProperty menuTable = new MastMenuProperty();
            MastManuscriptProperty manuscriptTable = new MastManuscriptProperty();

            ExpressionFactory ef = connection.getExpressionFactory();
            //site - menu - manuscript
            Association assoc = new Association(
                "menus",
                Association.Multiplicity.TO_MANY,
                new MastMenuProperty(),
                ef.relation(siteTable.siteCode, menuTable.siteCode),
                ef.strings("MAST_MENU.VALID_FLAG = 1")
                );
            assoc.add(new Association(
                "manuscripts",
                Association.Multiplicity.TO_MANY,
                new MastManuscriptProperty(),
                ef.relation(menuTable.siteCode, manuscriptTable.siteCode),
                ef.relation(menuTable.menuCode, manuscriptTable.menuCode),
                ef.strings("MAST_MANUSCRIPT.VALID_FLAG = 1")
                ));
            return assoc;
        }
        List<MastSiteEntity> map(DataSet result)
        {
            List<MastSiteEntity> sites = new List<MastSiteEntity>();
            IEnumerator rowEnumerator = result.Tables[0].Rows.GetEnumerator();
            bool eof = !rowEnumerator.MoveNext();
            while (!eof)
            {
                DataRow row = rowEnumerator.Current as DataRow;
                MastSiteEntity site = new MastSiteEntity();
                site.Map(row, "MAST_SITE");
                site.menus = new List<MastMenuEntity>();
                DataRow p1 = row;
                while (!eof)
                {
                    row = rowEnumerator.Current as DataRow;
                    if (!row["MAST_SITE__SITE_CODE"].Equals(p1["MAST_SITE__SITE_CODE"])) break;
                    MastMenuEntity menu = new MastMenuEntity();
                    menu.Map(row, "MAST_MENU");
                    menu.manuscripts = new List<MastManuscriptEntity>();
                    p1 = row;
                    while (!eof)
                    {
                        row = rowEnumerator.Current as DataRow;
                        if (!row["MAST_MENU__SITE_CODE"].Equals(p1["MAST_MENU__SITE_CODE"]) ||
                            !row["MAST_MENU__MENU_CODE"].Equals(p1["MAST_MENU__MENU_CODE"])) break;

                        if (row["MAST_MANUSCRIPT__SITE_CODE"].Equals(DBNull.Value) ){
                            eof = !rowEnumerator.MoveNext();
                            p1 = row;
                        }
                        MastManuscriptEntity manu = new MastManuscriptEntity();
                        manu.Map(row,"MAST_MANUSCRIPT");
                        menu.manuscripts.Add(manu);
                        eof = !rowEnumerator.MoveNext();
                        p1 = row;
                    }
                    site.menus.Add(menu);
                }
                sites.Add(site);
            }
            return sites;
        }
	}

}