using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace Sample.Data.Models.Base
{
    /// <summary>
    /// table MAST_SITE Field`
    /// </summary>
    [Serializable()]
    public class MastSiteTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[SITE_CODE]</summary>
        protected string _siteCode;
        ///<summary>[SITE_CODE]</summary>
        public string siteCode{
            get{return _siteCode;}
            set{_siteCode = value;}
        }
        ///<summary>[OPEN_DATE]</summary>
        protected string _openDate;
        ///<summary>[OPEN_DATE]</summary>
        public string openDate{
            get{return _openDate;}
            set{_openDate = value;}
        }
        ///<summary>[CLOSE_DATE]</summary>
        protected string _closeDate;
        ///<summary>[CLOSE_DATE]</summary>
        public string closeDate{
            get{return _closeDate;}
            set{_closeDate = value;}
        }
        ///<summary>[SORT_SEQ]</summary>
        protected System.Nullable<Int16> _sortSeq;
        ///<summary>[SORT_SEQ]</summary>
        public System.Nullable<Int16> sortSeq{
            get{return _sortSeq;}
            set{_sortSeq = value;}
        }
        ///<summary>[NAME]</summary>
        protected string _name;
        ///<summary>[NAME]</summary>
        public string name{
            get{return _name;}
            set{_name = value;}
        }
        ///<summary>[ANK_NAME]</summary>
        protected string _ankName;
        ///<summary>[ANK_NAME]</summary>
        public string ankName{
            get{return _ankName;}
            set{_ankName = value;}
        }
        ///<summary>[COMPANY_CODE]</summary>
        protected string _companyCode;
        ///<summary>[COMPANY_CODE]</summary>
        public string companyCode{
            get{return _companyCode;}
            set{_companyCode = value;}
        }
        ///<summary>[SITE_URL]</summary>
        protected string _siteUrl;
        ///<summary>[SITE_URL]</summary>
        public string siteUrl{
            get{return _siteUrl;}
            set{_siteUrl = value;}
        }
        ///<summary>[SITE_URL_OTHER]</summary>
        protected string _siteUrlOther;
        ///<summary>[SITE_URL_OTHER]</summary>
        public string siteUrlOther{
            get{return _siteUrlOther;}
            set{_siteUrlOther = value;}
        }
        ///<summary>[SITE_CATEGORY1]</summary>
        protected System.Nullable<Int16> _siteCategory1;
        ///<summary>[SITE_CATEGORY1]</summary>
        public System.Nullable<Int16> siteCategory1{
            get{return _siteCategory1;}
            set{_siteCategory1 = value;}
        }
        ///<summary>[SITE_CATEGORY2]</summary>
        protected System.Nullable<Int16> _siteCategory2;
        ///<summary>[SITE_CATEGORY2]</summary>
        public System.Nullable<Int16> siteCategory2{
            get{return _siteCategory2;}
            set{_siteCategory2 = value;}
        }
        ///<summary>[DEVICE_CODE]</summary>
        protected Int16 _deviceCode;
        ///<summary>[DEVICE_CODE]</summary>
        public Int16 deviceCode{
            get{return _deviceCode;}
            set{_deviceCode = value;}
        }
        ///<summary>[MENU_DEVICE_CODE]</summary>
        protected System.Nullable<Int16> _menuDeviceCode;
        ///<summary>[MENU_DEVICE_CODE]</summary>
        public System.Nullable<Int16> menuDeviceCode{
            get{return _menuDeviceCode;}
            set{_menuDeviceCode = value;}
        }
        ///<summary>[MENU_ADTYPE_CODE]</summary>
        protected System.Nullable<Int16> _menuAdtypeCode;
        ///<summary>[MENU_ADTYPE_CODE]</summary>
        public System.Nullable<Int16> menuAdtypeCode{
            get{return _menuAdtypeCode;}
            set{_menuAdtypeCode = value;}
        }
        ///<summary>[GOODS_CATEGORY_CODE]</summary>
        protected System.Nullable<Int16> _goodsCategoryCode;
        ///<summary>[GOODS_CATEGORY_CODE]</summary>
        public System.Nullable<Int16> goodsCategoryCode{
            get{return _goodsCategoryCode;}
            set{_goodsCategoryCode = value;}
        }
        ///<summary>[CARRIER_CODE1]</summary>
        protected System.Nullable<Int16> _carrierCode1;
        ///<summary>[CARRIER_CODE1]</summary>
        public System.Nullable<Int16> carrierCode1{
            get{return _carrierCode1;}
            set{_carrierCode1 = value;}
        }
        ///<summary>[CARRIER_CODE2]</summary>
        protected System.Nullable<Int16> _carrierCode2;
        ///<summary>[CARRIER_CODE2]</summary>
        public System.Nullable<Int16> carrierCode2{
            get{return _carrierCode2;}
            set{_carrierCode2 = value;}
        }
        ///<summary>[CARRIER_CODE3]</summary>
        protected System.Nullable<Int16> _carrierCode3;
        ///<summary>[CARRIER_CODE3]</summary>
        public System.Nullable<Int16> carrierCode3{
            get{return _carrierCode3;}
            set{_carrierCode3 = value;}
        }
        ///<summary>[CARRIER_CODE4]</summary>
        protected System.Nullable<Int16> _carrierCode4;
        ///<summary>[CARRIER_CODE4]</summary>
        public System.Nullable<Int16> carrierCode4{
            get{return _carrierCode4;}
            set{_carrierCode4 = value;}
        }
        ///<summary>[MEDIA_COST_RATE]</summary>
        protected System.Nullable<Decimal> _mediaCostRate;
        ///<summary>[MEDIA_COST_RATE]</summary>
        public System.Nullable<Decimal> mediaCostRate{
            get{return _mediaCostRate;}
            set{_mediaCostRate = value;}
        }
        ///<summary>[AGENCY_MARGIN_RATE]</summary>
        protected System.Nullable<Decimal> _agencyMarginRate;
        ///<summary>[AGENCY_MARGIN_RATE]</summary>
        public System.Nullable<Decimal> agencyMarginRate{
            get{return _agencyMarginRate;}
            set{_agencyMarginRate = value;}
        }
        ///<summary>[SP_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _spOpenFlag;
        ///<summary>[SP_OPEN_FLAG]</summary>
        public System.Nullable<Int16> spOpenFlag{
            get{return _spOpenFlag;}
            set{_spOpenFlag = value;}
        }
        ///<summary>[PM_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _pmOpenFlag;
        ///<summary>[PM_OPEN_FLAG]</summary>
        public System.Nullable<Int16> pmOpenFlag{
            get{return _pmOpenFlag;}
            set{_pmOpenFlag = value;}
        }
        ///<summary>[IO_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _ioOpenFlag;
        ///<summary>[IO_OPEN_FLAG]</summary>
        public System.Nullable<Int16> ioOpenFlag{
            get{return _ioOpenFlag;}
            set{_ioOpenFlag = value;}
        }
        ///<summary>[AD_GUIDE_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _adGuideOpenFlag;
        ///<summary>[AD_GUIDE_OPEN_FLAG]</summary>
        public System.Nullable<Int16> adGuideOpenFlag{
            get{return _adGuideOpenFlag;}
            set{_adGuideOpenFlag = value;}
        }
        ///<summary>[IMPRESSION]</summary>
        protected System.Nullable<Decimal> _impression;
        ///<summary>[IMPRESSION]</summary>
        public System.Nullable<Decimal> impression{
            get{return _impression;}
            set{_impression = value;}
        }
        ///<summary>[IMPRESSION_TERM]</summary>
        protected System.Nullable<Int16> _impressionTerm;
        ///<summary>[IMPRESSION_TERM]</summary>
        public System.Nullable<Int16> impressionTerm{
            get{return _impressionTerm;}
            set{_impressionTerm = value;}
        }
        ///<summary>[IMPRESSION_TOPPAGE]</summary>
        protected System.Nullable<Decimal> _impressionToppage;
        ///<summary>[IMPRESSION_TOPPAGE]</summary>
        public System.Nullable<Decimal> impressionToppage{
            get{return _impressionToppage;}
            set{_impressionToppage = value;}
        }
        ///<summary>[IMPRESSION_TOPPAGE_TERM]</summary>
        protected System.Nullable<Int16> _impressionToppageTerm;
        ///<summary>[IMPRESSION_TOPPAGE_TERM]</summary>
        public System.Nullable<Int16> impressionToppageTerm{
            get{return _impressionToppageTerm;}
            set{_impressionToppageTerm = value;}
        }
        ///<summary>[UNIQUE_USER]</summary>
        protected System.Nullable<Decimal> _uniqueUser;
        ///<summary>[UNIQUE_USER]</summary>
        public System.Nullable<Decimal> uniqueUser{
            get{return _uniqueUser;}
            set{_uniqueUser = value;}
        }
        ///<summary>[UNIQUE_USER_TERM]</summary>
        protected System.Nullable<Int16> _uniqueUserTerm;
        ///<summary>[UNIQUE_USER_TERM]</summary>
        public System.Nullable<Int16> uniqueUserTerm{
            get{return _uniqueUserTerm;}
            set{_uniqueUserTerm = value;}
        }
        ///<summary>[UNIQUE_USER_TOPPAGE]</summary>
        protected System.Nullable<Decimal> _uniqueUserToppage;
        ///<summary>[UNIQUE_USER_TOPPAGE]</summary>
        public System.Nullable<Decimal> uniqueUserToppage{
            get{return _uniqueUserToppage;}
            set{_uniqueUserToppage = value;}
        }
        ///<summary>[UNIQUE_USER_TOPPAGE_TERM]</summary>
        protected System.Nullable<Int16> _uniqueUserToppageTerm;
        ///<summary>[UNIQUE_USER_TOPPAGE_TERM]</summary>
        public System.Nullable<Int16> uniqueUserToppageTerm{
            get{return _uniqueUserToppageTerm;}
            set{_uniqueUserToppageTerm = value;}
        }
        ///<summary>[MALE_RATE]</summary>
        protected System.Nullable<Decimal> _maleRate;
        ///<summary>[MALE_RATE]</summary>
        public System.Nullable<Decimal> maleRate{
            get{return _maleRate;}
            set{_maleRate = value;}
        }
        ///<summary>[FEMALE_RATE]</summary>
        protected System.Nullable<Decimal> _femaleRate;
        ///<summary>[FEMALE_RATE]</summary>
        public System.Nullable<Decimal> femaleRate{
            get{return _femaleRate;}
            set{_femaleRate = value;}
        }
        ///<summary>[PUBLISHED_YEAR]</summary>
        protected System.Nullable<Int16> _publishedYear;
        ///<summary>[PUBLISHED_YEAR]</summary>
        public System.Nullable<Int16> publishedYear{
            get{return _publishedYear;}
            set{_publishedYear = value;}
        }
        ///<summary>[PUBLISHED_MONTH]</summary>
        protected System.Nullable<Int16> _publishedMonth;
        ///<summary>[PUBLISHED_MONTH]</summary>
        public System.Nullable<Int16> publishedMonth{
            get{return _publishedMonth;}
            set{_publishedMonth = value;}
        }
        ///<summary>[PUBLISHED_DAY]</summary>
        protected System.Nullable<Int16> _publishedDay;
        ///<summary>[PUBLISHED_DAY]</summary>
        public System.Nullable<Int16> publishedDay{
            get{return _publishedDay;}
            set{_publishedDay = value;}
        }
        ///<summary>[PUBLISHED_DATA_KIND]</summary>
        protected System.Nullable<Int16> _publishedDataKind;
        ///<summary>[PUBLISHED_DATA_KIND]</summary>
        public System.Nullable<Int16> publishedDataKind{
            get{return _publishedDataKind;}
            set{_publishedDataKind = value;}
        }
        ///<summary>[UPPER_SITE_CODE]</summary>
        protected string _upperSiteCode;
        ///<summary>[UPPER_SITE_CODE]</summary>
        public string upperSiteCode{
            get{return _upperSiteCode;}
            set{_upperSiteCode = value;}
        }
        ///<summary>[PAYMENT_COMPANY]</summary>
        protected string _paymentCompany;
        ///<summary>[PAYMENT_COMPANY]</summary>
        public string paymentCompany{
            get{return _paymentCompany;}
            set{_paymentCompany = value;}
        }
        ///<summary>[BUSINESS_DIRECT_FLAG]</summary>
        protected System.Nullable<Int16> _businessDirectFlag;
        ///<summary>[BUSINESS_DIRECT_FLAG]</summary>
        public System.Nullable<Int16> businessDirectFlag{
            get{return _businessDirectFlag;}
            set{_businessDirectFlag = value;}
        }
        ///<summary>[ADSERVER_FLAG]</summary>
        protected System.Nullable<Int16> _adserverFlag;
        ///<summary>[ADSERVER_FLAG]</summary>
        public System.Nullable<Int16> adserverFlag{
            get{return _adserverFlag;}
            set{_adserverFlag = value;}
        }
        ///<summary>[SPECIALMENU_FLAG]</summary>
        protected System.Nullable<Int16> _specialmenuFlag;
        ///<summary>[SPECIALMENU_FLAG]</summary>
        public System.Nullable<Int16> specialmenuFlag{
            get{return _specialmenuFlag;}
            set{_specialmenuFlag = value;}
        }
        ///<summary>[TOP_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _topOpenFlag;
        ///<summary>[TOP_OPEN_FLAG]</summary>
        public System.Nullable<Int16> topOpenFlag{
            get{return _topOpenFlag;}
            set{_topOpenFlag = value;}
        }
        ///<summary>[OPEN_MENU_COUNT]</summary>
        protected System.Nullable<Int16> _openMenuCount;
        ///<summary>[OPEN_MENU_COUNT]</summary>
        public System.Nullable<Int16> openMenuCount{
            get{return _openMenuCount;}
            set{_openMenuCount = value;}
        }
        ///<summary>[MAKE_DATE]</summary>
        protected string _makeDate;
        ///<summary>[MAKE_DATE]</summary>
        public string makeDate{
            get{return _makeDate;}
            set{_makeDate = value;}
        }
        ///<summary>[DOCUMENT_ADDRESS]</summary>
        protected string _documentAddress;
        ///<summary>[DOCUMENT_ADDRESS]</summary>
        public string documentAddress{
            get{return _documentAddress;}
            set{_documentAddress = value;}
        }
        ///<summary>[AG_COMPANY_CODE]</summary>
        protected string _agCompanyCode;
        ///<summary>[AG_COMPANY_CODE]</summary>
        public string agCompanyCode{
            get{return _agCompanyCode;}
            set{_agCompanyCode = value;}
        }
        ///<summary>[INSIDE_OPEN_LEVEL]</summary>
        protected System.Nullable<Int16> _insideOpenLevel;
        ///<summary>[INSIDE_OPEN_LEVEL]</summary>
        public System.Nullable<Int16> insideOpenLevel{
            get{return _insideOpenLevel;}
            set{_insideOpenLevel = value;}
        }
        ///<summary>[OUTSIDE_OPEN_LEVEL]</summary>
        protected System.Nullable<Int16> _outsideOpenLevel;
        ///<summary>[OUTSIDE_OPEN_LEVEL]</summary>
        public System.Nullable<Int16> outsideOpenLevel{
            get{return _outsideOpenLevel;}
            set{_outsideOpenLevel = value;}
        }
        ///<summary>[HOME_RATE]</summary>
        protected System.Nullable<Decimal> _homeRate;
        ///<summary>[HOME_RATE]</summary>
        public System.Nullable<Decimal> homeRate{
            get{return _homeRate;}
            set{_homeRate = value;}
        }
        ///<summary>[WORK_RATE]</summary>
        protected System.Nullable<Decimal> _workRate;
        ///<summary>[WORK_RATE]</summary>
        public System.Nullable<Decimal> workRate{
            get{return _workRate;}
            set{_workRate = value;}
        }
        ///<summary>[OVERLAP_RATE]</summary>
        protected System.Nullable<Decimal> _overlapRate;
        ///<summary>[OVERLAP_RATE]</summary>
        public System.Nullable<Decimal> overlapRate{
            get{return _overlapRate;}
            set{_overlapRate = value;}
        }
        ///<summary>[BUSINESS_REP_DIRECT_FLAG]</summary>
        protected System.Nullable<Int16> _businessRepDirectFlag;
        ///<summary>[BUSINESS_REP_DIRECT_FLAG]</summary>
        public System.Nullable<Int16> businessRepDirectFlag{
            get{return _businessRepDirectFlag;}
            set{_businessRepDirectFlag = value;}
        }
        ///<summary>[CLIENT_SITE_FLAG]</summary>
        protected System.Nullable<Int16> _clientSiteFlag;
        ///<summary>[CLIENT_SITE_FLAG]</summary>
        public System.Nullable<Int16> clientSiteFlag{
            get{return _clientSiteFlag;}
            set{_clientSiteFlag = value;}
        }
        ///<summary>[PRINT_UPPER_SITE_CODE]</summary>
        protected string _printUpperSiteCode;
        ///<summary>[PRINT_UPPER_SITE_CODE]</summary>
        public string printUpperSiteCode{
            get{return _printUpperSiteCode;}
            set{_printUpperSiteCode = value;}
        }
        ///<summary>[TEAM_CODE]</summary>
        protected System.Nullable<Int16> _teamCode;
        ///<summary>[TEAM_CODE]</summary>
        public System.Nullable<Int16> teamCode{
            get{return _teamCode;}
            set{_teamCode = value;}
        }
        ///<summary>[CHECK_NAME]</summary>
        protected string _checkName;
        ///<summary>[CHECK_NAME]</summary>
        public string checkName{
            get{return _checkName;}
            set{_checkName = value;}
        }
        ///<summary>[PRICE_COST_FROM_DATE]</summary>
        protected string _priceCostFromDate;
        ///<summary>[PRICE_COST_FROM_DATE]</summary>
        public string priceCostFromDate{
            get{return _priceCostFromDate;}
            set{_priceCostFromDate = value;}
        }
        ///<summary>[VALID_FLAG]</summary>
        protected System.Nullable<Int16> _validFlag;
        ///<summary>[VALID_FLAG]</summary>
        public System.Nullable<Int16> validFlag{
            get{return _validFlag;}
            set{_validFlag = value;}
        }
        ///<summary>[INSERT_DATE_TIME]</summary>
        protected DateTime? _insertDateTime;
        ///<summary>[INSERT_DATE_TIME]</summary>
        public DateTime? insertDateTime{
            get{return _insertDateTime;}
            set{_insertDateTime = value;}
        }
        ///<summary>[INSERT_OPERATOR_CODE]</summary>
        protected string _insertOperatorCode;
        ///<summary>[INSERT_OPERATOR_CODE]</summary>
        public string insertOperatorCode{
            get{return _insertOperatorCode;}
            set{_insertOperatorCode = value;}
        }
        ///<summary>[UPDATE_DATE_TIME]</summary>
        protected DateTime? _updateDateTime;
        ///<summary>[UPDATE_DATE_TIME]</summary>
        public DateTime? updateDateTime{
            get{return _updateDateTime;}
            set{_updateDateTime = value;}
        }
        ///<summary>[OPERATOR_CODE]</summary>
        protected string _operatorCode;
        ///<summary>[OPERATOR_CODE]</summary>
        public string operatorCode{
            get{return _operatorCode;}
            set{_operatorCode = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public MastSiteTableRow() : base()
        {
            this._siteCode = "";
            this._openDate = "";
            this._closeDate = "";
            this._sortSeq = null;
            this._name = "";
            this._ankName = "";
            this._companyCode = "";
            this._siteUrl = "";
            this._siteUrlOther = "";
            this._siteCategory1 = null;
            this._siteCategory2 = null;
            this._deviceCode = 0;
            this._menuDeviceCode = null;
            this._menuAdtypeCode = null;
            this._goodsCategoryCode = null;
            this._carrierCode1 = null;
            this._carrierCode2 = null;
            this._carrierCode3 = null;
            this._carrierCode4 = null;
            this._mediaCostRate = null;
            this._agencyMarginRate = null;
            this._spOpenFlag = null;
            this._pmOpenFlag = null;
            this._ioOpenFlag = null;
            this._adGuideOpenFlag = null;
            this._impression = null;
            this._impressionTerm = null;
            this._impressionToppage = null;
            this._impressionToppageTerm = null;
            this._uniqueUser = null;
            this._uniqueUserTerm = null;
            this._uniqueUserToppage = null;
            this._uniqueUserToppageTerm = null;
            this._maleRate = null;
            this._femaleRate = null;
            this._publishedYear = null;
            this._publishedMonth = null;
            this._publishedDay = null;
            this._publishedDataKind = null;
            this._upperSiteCode = "";
            this._paymentCompany = "";
            this._businessDirectFlag = null;
            this._adserverFlag = null;
            this._specialmenuFlag = null;
            this._topOpenFlag = null;
            this._openMenuCount = null;
            this._makeDate = "";
            this._documentAddress = "";
            this._agCompanyCode = "";
            this._insideOpenLevel = null;
            this._outsideOpenLevel = null;
            this._homeRate = null;
            this._workRate = null;
            this._overlapRate = null;
            this._businessRepDirectFlag = null;
            this._clientSiteFlag = null;
            this._printUpperSiteCode = "";
            this._teamCode = null;
            this._checkName = "";
            this._priceCostFromDate = "";
            this._validFlag = null;
            this._insertDateTime = null;
            this._insertOperatorCode = "";
            this._updateDateTime = null;
            this._operatorCode = "";
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "SITE_CODE"){ this._siteCode = StringUtil.StringValue( value );return; }
            if(name ==  "OPEN_DATE"){ this._openDate = StringUtil.StringValue( value );return; }
            if(name ==  "CLOSE_DATE"){ this._closeDate = StringUtil.StringValue( value );return; }
            if(name ==  "SORT_SEQ"){ this._sortSeq = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "NAME"){ this._name = StringUtil.StringValue( value );return; }
            if(name ==  "ANK_NAME"){ this._ankName = StringUtil.StringValue( value );return; }
            if(name ==  "COMPANY_CODE"){ this._companyCode = StringUtil.StringValue( value );return; }
            if(name ==  "SITE_URL"){ this._siteUrl = StringUtil.StringValue( value );return; }
            if(name ==  "SITE_URL_OTHER"){ this._siteUrlOther = StringUtil.StringValue( value );return; }
            if(name ==  "SITE_CATEGORY1"){ this._siteCategory1 = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "SITE_CATEGORY2"){ this._siteCategory2 = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "DEVICE_CODE"){ this._deviceCode = NumberUtil.Value<Int16>( value );return; }
            if(name ==  "MENU_DEVICE_CODE"){ this._menuDeviceCode = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "MENU_ADTYPE_CODE"){ this._menuAdtypeCode = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "GOODS_CATEGORY_CODE"){ this._goodsCategoryCode = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "CARRIER_CODE1"){ this._carrierCode1 = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "CARRIER_CODE2"){ this._carrierCode2 = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "CARRIER_CODE3"){ this._carrierCode3 = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "CARRIER_CODE4"){ this._carrierCode4 = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "MEDIA_COST_RATE"){ this._mediaCostRate = NumberUtil.Value<Decimal?>( value );return; }
            if(name ==  "AGENCY_MARGIN_RATE"){ this._agencyMarginRate = NumberUtil.Value<Decimal?>( value );return; }
            if(name ==  "SP_OPEN_FLAG"){ this._spOpenFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "PM_OPEN_FLAG"){ this._pmOpenFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "IO_OPEN_FLAG"){ this._ioOpenFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "AD_GUIDE_OPEN_FLAG"){ this._adGuideOpenFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "IMPRESSION"){ this._impression = NumberUtil.Value<Decimal?>( value );return; }
            if(name ==  "IMPRESSION_TERM"){ this._impressionTerm = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "IMPRESSION_TOPPAGE"){ this._impressionToppage = NumberUtil.Value<Decimal?>( value );return; }
            if(name ==  "IMPRESSION_TOPPAGE_TERM"){ this._impressionToppageTerm = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "UNIQUE_USER"){ this._uniqueUser = NumberUtil.Value<Decimal?>( value );return; }
            if(name ==  "UNIQUE_USER_TERM"){ this._uniqueUserTerm = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "UNIQUE_USER_TOPPAGE"){ this._uniqueUserToppage = NumberUtil.Value<Decimal?>( value );return; }
            if(name ==  "UNIQUE_USER_TOPPAGE_TERM"){ this._uniqueUserToppageTerm = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "MALE_RATE"){ this._maleRate = NumberUtil.Value<Decimal?>( value );return; }
            if(name ==  "FEMALE_RATE"){ this._femaleRate = NumberUtil.Value<Decimal?>( value );return; }
            if(name ==  "PUBLISHED_YEAR"){ this._publishedYear = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "PUBLISHED_MONTH"){ this._publishedMonth = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "PUBLISHED_DAY"){ this._publishedDay = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "PUBLISHED_DATA_KIND"){ this._publishedDataKind = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "UPPER_SITE_CODE"){ this._upperSiteCode = StringUtil.StringValue( value );return; }
            if(name ==  "PAYMENT_COMPANY"){ this._paymentCompany = StringUtil.StringValue( value );return; }
            if(name ==  "BUSINESS_DIRECT_FLAG"){ this._businessDirectFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "ADSERVER_FLAG"){ this._adserverFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "SPECIALMENU_FLAG"){ this._specialmenuFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "TOP_OPEN_FLAG"){ this._topOpenFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "OPEN_MENU_COUNT"){ this._openMenuCount = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "MAKE_DATE"){ this._makeDate = StringUtil.StringValue( value );return; }
            if(name ==  "DOCUMENT_ADDRESS"){ this._documentAddress = StringUtil.StringValue( value );return; }
            if(name ==  "AG_COMPANY_CODE"){ this._agCompanyCode = StringUtil.StringValue( value );return; }
            if(name ==  "INSIDE_OPEN_LEVEL"){ this._insideOpenLevel = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "OUTSIDE_OPEN_LEVEL"){ this._outsideOpenLevel = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "HOME_RATE"){ this._homeRate = NumberUtil.Value<Decimal?>( value );return; }
            if(name ==  "WORK_RATE"){ this._workRate = NumberUtil.Value<Decimal?>( value );return; }
            if(name ==  "OVERLAP_RATE"){ this._overlapRate = NumberUtil.Value<Decimal?>( value );return; }
            if(name ==  "BUSINESS_REP_DIRECT_FLAG"){ this._businessRepDirectFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "CLIENT_SITE_FLAG"){ this._clientSiteFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "PRINT_UPPER_SITE_CODE"){ this._printUpperSiteCode = StringUtil.StringValue( value );return; }
            if(name ==  "TEAM_CODE"){ this._teamCode = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "CHECK_NAME"){ this._checkName = StringUtil.StringValue( value );return; }
            if(name ==  "PRICE_COST_FROM_DATE"){ this._priceCostFromDate = StringUtil.StringValue( value );return; }
            if(name ==  "VALID_FLAG"){ this._validFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "INSERT_DATE_TIME"){ this._insertDateTime = DateUtil.DateValue( value );return; }
            if(name ==  "INSERT_OPERATOR_CODE"){ this._insertOperatorCode = StringUtil.StringValue( value );return; }
            if(name ==  "UPDATE_DATE_TIME"){ this._updateDateTime = DateUtil.DateValue( value );return; }
            if(name ==  "OPERATOR_CODE"){ this._operatorCode = StringUtil.StringValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "SITE_CODE") return this._siteCode;
            if(name ==  "OPEN_DATE") return this._openDate;
            if(name ==  "CLOSE_DATE") return this._closeDate;
            if(name ==  "SORT_SEQ") return this._sortSeq;
            if(name ==  "NAME") return this._name;
            if(name ==  "ANK_NAME") return this._ankName;
            if(name ==  "COMPANY_CODE") return this._companyCode;
            if(name ==  "SITE_URL") return this._siteUrl;
            if(name ==  "SITE_URL_OTHER") return this._siteUrlOther;
            if(name ==  "SITE_CATEGORY1") return this._siteCategory1;
            if(name ==  "SITE_CATEGORY2") return this._siteCategory2;
            if(name ==  "DEVICE_CODE") return this._deviceCode;
            if(name ==  "MENU_DEVICE_CODE") return this._menuDeviceCode;
            if(name ==  "MENU_ADTYPE_CODE") return this._menuAdtypeCode;
            if(name ==  "GOODS_CATEGORY_CODE") return this._goodsCategoryCode;
            if(name ==  "CARRIER_CODE1") return this._carrierCode1;
            if(name ==  "CARRIER_CODE2") return this._carrierCode2;
            if(name ==  "CARRIER_CODE3") return this._carrierCode3;
            if(name ==  "CARRIER_CODE4") return this._carrierCode4;
            if(name ==  "MEDIA_COST_RATE") return this._mediaCostRate;
            if(name ==  "AGENCY_MARGIN_RATE") return this._agencyMarginRate;
            if(name ==  "SP_OPEN_FLAG") return this._spOpenFlag;
            if(name ==  "PM_OPEN_FLAG") return this._pmOpenFlag;
            if(name ==  "IO_OPEN_FLAG") return this._ioOpenFlag;
            if(name ==  "AD_GUIDE_OPEN_FLAG") return this._adGuideOpenFlag;
            if(name ==  "IMPRESSION") return this._impression;
            if(name ==  "IMPRESSION_TERM") return this._impressionTerm;
            if(name ==  "IMPRESSION_TOPPAGE") return this._impressionToppage;
            if(name ==  "IMPRESSION_TOPPAGE_TERM") return this._impressionToppageTerm;
            if(name ==  "UNIQUE_USER") return this._uniqueUser;
            if(name ==  "UNIQUE_USER_TERM") return this._uniqueUserTerm;
            if(name ==  "UNIQUE_USER_TOPPAGE") return this._uniqueUserToppage;
            if(name ==  "UNIQUE_USER_TOPPAGE_TERM") return this._uniqueUserToppageTerm;
            if(name ==  "MALE_RATE") return this._maleRate;
            if(name ==  "FEMALE_RATE") return this._femaleRate;
            if(name ==  "PUBLISHED_YEAR") return this._publishedYear;
            if(name ==  "PUBLISHED_MONTH") return this._publishedMonth;
            if(name ==  "PUBLISHED_DAY") return this._publishedDay;
            if(name ==  "PUBLISHED_DATA_KIND") return this._publishedDataKind;
            if(name ==  "UPPER_SITE_CODE") return this._upperSiteCode;
            if(name ==  "PAYMENT_COMPANY") return this._paymentCompany;
            if(name ==  "BUSINESS_DIRECT_FLAG") return this._businessDirectFlag;
            if(name ==  "ADSERVER_FLAG") return this._adserverFlag;
            if(name ==  "SPECIALMENU_FLAG") return this._specialmenuFlag;
            if(name ==  "TOP_OPEN_FLAG") return this._topOpenFlag;
            if(name ==  "OPEN_MENU_COUNT") return this._openMenuCount;
            if(name ==  "MAKE_DATE") return this._makeDate;
            if(name ==  "DOCUMENT_ADDRESS") return this._documentAddress;
            if(name ==  "AG_COMPANY_CODE") return this._agCompanyCode;
            if(name ==  "INSIDE_OPEN_LEVEL") return this._insideOpenLevel;
            if(name ==  "OUTSIDE_OPEN_LEVEL") return this._outsideOpenLevel;
            if(name ==  "HOME_RATE") return this._homeRate;
            if(name ==  "WORK_RATE") return this._workRate;
            if(name ==  "OVERLAP_RATE") return this._overlapRate;
            if(name ==  "BUSINESS_REP_DIRECT_FLAG") return this._businessRepDirectFlag;
            if(name ==  "CLIENT_SITE_FLAG") return this._clientSiteFlag;
            if(name ==  "PRINT_UPPER_SITE_CODE") return this._printUpperSiteCode;
            if(name ==  "TEAM_CODE") return this._teamCode;
            if(name ==  "CHECK_NAME") return this._checkName;
            if(name ==  "PRICE_COST_FROM_DATE") return this._priceCostFromDate;
            if(name ==  "VALID_FLAG") return this._validFlag;
            if(name ==  "INSERT_DATE_TIME") return this._insertDateTime;
            if(name ==  "INSERT_OPERATOR_CODE") return this._insertOperatorCode;
            if(name ==  "UPDATE_DATE_TIME") return this._updateDateTime;
            if(name ==  "OPERATOR_CODE") return this._operatorCode;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            MastSiteTableRow clone = new MastSiteTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(MastSiteTableRow source)
        {
            this.siteCode = source.siteCode;
            this.openDate = source.openDate;
            this.closeDate = source.closeDate;
            this.sortSeq = source.sortSeq;
            this.name = source.name;
            this.ankName = source.ankName;
            this.companyCode = source.companyCode;
            this.siteUrl = source.siteUrl;
            this.siteUrlOther = source.siteUrlOther;
            this.siteCategory1 = source.siteCategory1;
            this.siteCategory2 = source.siteCategory2;
            this.deviceCode = source.deviceCode;
            this.menuDeviceCode = source.menuDeviceCode;
            this.menuAdtypeCode = source.menuAdtypeCode;
            this.goodsCategoryCode = source.goodsCategoryCode;
            this.carrierCode1 = source.carrierCode1;
            this.carrierCode2 = source.carrierCode2;
            this.carrierCode3 = source.carrierCode3;
            this.carrierCode4 = source.carrierCode4;
            this.mediaCostRate = source.mediaCostRate;
            this.agencyMarginRate = source.agencyMarginRate;
            this.spOpenFlag = source.spOpenFlag;
            this.pmOpenFlag = source.pmOpenFlag;
            this.ioOpenFlag = source.ioOpenFlag;
            this.adGuideOpenFlag = source.adGuideOpenFlag;
            this.impression = source.impression;
            this.impressionTerm = source.impressionTerm;
            this.impressionToppage = source.impressionToppage;
            this.impressionToppageTerm = source.impressionToppageTerm;
            this.uniqueUser = source.uniqueUser;
            this.uniqueUserTerm = source.uniqueUserTerm;
            this.uniqueUserToppage = source.uniqueUserToppage;
            this.uniqueUserToppageTerm = source.uniqueUserToppageTerm;
            this.maleRate = source.maleRate;
            this.femaleRate = source.femaleRate;
            this.publishedYear = source.publishedYear;
            this.publishedMonth = source.publishedMonth;
            this.publishedDay = source.publishedDay;
            this.publishedDataKind = source.publishedDataKind;
            this.upperSiteCode = source.upperSiteCode;
            this.paymentCompany = source.paymentCompany;
            this.businessDirectFlag = source.businessDirectFlag;
            this.adserverFlag = source.adserverFlag;
            this.specialmenuFlag = source.specialmenuFlag;
            this.topOpenFlag = source.topOpenFlag;
            this.openMenuCount = source.openMenuCount;
            this.makeDate = source.makeDate;
            this.documentAddress = source.documentAddress;
            this.agCompanyCode = source.agCompanyCode;
            this.insideOpenLevel = source.insideOpenLevel;
            this.outsideOpenLevel = source.outsideOpenLevel;
            this.homeRate = source.homeRate;
            this.workRate = source.workRate;
            this.overlapRate = source.overlapRate;
            this.businessRepDirectFlag = source.businessRepDirectFlag;
            this.clientSiteFlag = source.clientSiteFlag;
            this.printUpperSiteCode = source.printUpperSiteCode;
            this.teamCode = source.teamCode;
            this.checkName = source.checkName;
            this.priceCostFromDate = source.priceCostFromDate;
            this.validFlag = source.validFlag;
            this.insertDateTime = source.insertDateTime;
            this.insertOperatorCode = source.insertOperatorCode;
            this.updateDateTime = source.updateDateTime;
            this.operatorCode = source.operatorCode;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("SITE_CODE")){ this._siteCode = StringUtil.StringValue(row["SITE_CODE"]); }
            if (cols.Contains("OPEN_DATE")){ this._openDate = StringUtil.StringValue(row["OPEN_DATE"]); }
            if (cols.Contains("CLOSE_DATE")){ this._closeDate = StringUtil.StringValue(row["CLOSE_DATE"]); }
            if (cols.Contains("SORT_SEQ")){ this._sortSeq = NumberUtil.Value<Int16?>(row["SORT_SEQ"]); }
            if (cols.Contains("NAME")){ this._name = StringUtil.StringValue(row["NAME"]); }
            if (cols.Contains("ANK_NAME")){ this._ankName = StringUtil.StringValue(row["ANK_NAME"]); }
            if (cols.Contains("COMPANY_CODE")){ this._companyCode = StringUtil.StringValue(row["COMPANY_CODE"]); }
            if (cols.Contains("SITE_URL")){ this._siteUrl = StringUtil.StringValue(row["SITE_URL"]); }
            if (cols.Contains("SITE_URL_OTHER")){ this._siteUrlOther = StringUtil.StringValue(row["SITE_URL_OTHER"]); }
            if (cols.Contains("SITE_CATEGORY1")){ this._siteCategory1 = NumberUtil.Value<Int16?>(row["SITE_CATEGORY1"]); }
            if (cols.Contains("SITE_CATEGORY2")){ this._siteCategory2 = NumberUtil.Value<Int16?>(row["SITE_CATEGORY2"]); }
            if (cols.Contains("DEVICE_CODE")){ this._deviceCode = NumberUtil.Value<Int16>(row["DEVICE_CODE"]); }
            if (cols.Contains("MENU_DEVICE_CODE")){ this._menuDeviceCode = NumberUtil.Value<Int16?>(row["MENU_DEVICE_CODE"]); }
            if (cols.Contains("MENU_ADTYPE_CODE")){ this._menuAdtypeCode = NumberUtil.Value<Int16?>(row["MENU_ADTYPE_CODE"]); }
            if (cols.Contains("GOODS_CATEGORY_CODE")){ this._goodsCategoryCode = NumberUtil.Value<Int16?>(row["GOODS_CATEGORY_CODE"]); }
            if (cols.Contains("CARRIER_CODE1")){ this._carrierCode1 = NumberUtil.Value<Int16?>(row["CARRIER_CODE1"]); }
            if (cols.Contains("CARRIER_CODE2")){ this._carrierCode2 = NumberUtil.Value<Int16?>(row["CARRIER_CODE2"]); }
            if (cols.Contains("CARRIER_CODE3")){ this._carrierCode3 = NumberUtil.Value<Int16?>(row["CARRIER_CODE3"]); }
            if (cols.Contains("CARRIER_CODE4")){ this._carrierCode4 = NumberUtil.Value<Int16?>(row["CARRIER_CODE4"]); }
            if (cols.Contains("MEDIA_COST_RATE")){ this._mediaCostRate = NumberUtil.Value<Decimal?>(row["MEDIA_COST_RATE"]); }
            if (cols.Contains("AGENCY_MARGIN_RATE")){ this._agencyMarginRate = NumberUtil.Value<Decimal?>(row["AGENCY_MARGIN_RATE"]); }
            if (cols.Contains("SP_OPEN_FLAG")){ this._spOpenFlag = NumberUtil.Value<Int16?>(row["SP_OPEN_FLAG"]); }
            if (cols.Contains("PM_OPEN_FLAG")){ this._pmOpenFlag = NumberUtil.Value<Int16?>(row["PM_OPEN_FLAG"]); }
            if (cols.Contains("IO_OPEN_FLAG")){ this._ioOpenFlag = NumberUtil.Value<Int16?>(row["IO_OPEN_FLAG"]); }
            if (cols.Contains("AD_GUIDE_OPEN_FLAG")){ this._adGuideOpenFlag = NumberUtil.Value<Int16?>(row["AD_GUIDE_OPEN_FLAG"]); }
            if (cols.Contains("IMPRESSION")){ this._impression = NumberUtil.Value<Decimal?>(row["IMPRESSION"]); }
            if (cols.Contains("IMPRESSION_TERM")){ this._impressionTerm = NumberUtil.Value<Int16?>(row["IMPRESSION_TERM"]); }
            if (cols.Contains("IMPRESSION_TOPPAGE")){ this._impressionToppage = NumberUtil.Value<Decimal?>(row["IMPRESSION_TOPPAGE"]); }
            if (cols.Contains("IMPRESSION_TOPPAGE_TERM")){ this._impressionToppageTerm = NumberUtil.Value<Int16?>(row["IMPRESSION_TOPPAGE_TERM"]); }
            if (cols.Contains("UNIQUE_USER")){ this._uniqueUser = NumberUtil.Value<Decimal?>(row["UNIQUE_USER"]); }
            if (cols.Contains("UNIQUE_USER_TERM")){ this._uniqueUserTerm = NumberUtil.Value<Int16?>(row["UNIQUE_USER_TERM"]); }
            if (cols.Contains("UNIQUE_USER_TOPPAGE")){ this._uniqueUserToppage = NumberUtil.Value<Decimal?>(row["UNIQUE_USER_TOPPAGE"]); }
            if (cols.Contains("UNIQUE_USER_TOPPAGE_TERM")){ this._uniqueUserToppageTerm = NumberUtil.Value<Int16?>(row["UNIQUE_USER_TOPPAGE_TERM"]); }
            if (cols.Contains("MALE_RATE")){ this._maleRate = NumberUtil.Value<Decimal?>(row["MALE_RATE"]); }
            if (cols.Contains("FEMALE_RATE")){ this._femaleRate = NumberUtil.Value<Decimal?>(row["FEMALE_RATE"]); }
            if (cols.Contains("PUBLISHED_YEAR")){ this._publishedYear = NumberUtil.Value<Int16?>(row["PUBLISHED_YEAR"]); }
            if (cols.Contains("PUBLISHED_MONTH")){ this._publishedMonth = NumberUtil.Value<Int16?>(row["PUBLISHED_MONTH"]); }
            if (cols.Contains("PUBLISHED_DAY")){ this._publishedDay = NumberUtil.Value<Int16?>(row["PUBLISHED_DAY"]); }
            if (cols.Contains("PUBLISHED_DATA_KIND")){ this._publishedDataKind = NumberUtil.Value<Int16?>(row["PUBLISHED_DATA_KIND"]); }
            if (cols.Contains("UPPER_SITE_CODE")){ this._upperSiteCode = StringUtil.StringValue(row["UPPER_SITE_CODE"]); }
            if (cols.Contains("PAYMENT_COMPANY")){ this._paymentCompany = StringUtil.StringValue(row["PAYMENT_COMPANY"]); }
            if (cols.Contains("BUSINESS_DIRECT_FLAG")){ this._businessDirectFlag = NumberUtil.Value<Int16?>(row["BUSINESS_DIRECT_FLAG"]); }
            if (cols.Contains("ADSERVER_FLAG")){ this._adserverFlag = NumberUtil.Value<Int16?>(row["ADSERVER_FLAG"]); }
            if (cols.Contains("SPECIALMENU_FLAG")){ this._specialmenuFlag = NumberUtil.Value<Int16?>(row["SPECIALMENU_FLAG"]); }
            if (cols.Contains("TOP_OPEN_FLAG")){ this._topOpenFlag = NumberUtil.Value<Int16?>(row["TOP_OPEN_FLAG"]); }
            if (cols.Contains("OPEN_MENU_COUNT")){ this._openMenuCount = NumberUtil.Value<Int16?>(row["OPEN_MENU_COUNT"]); }
            if (cols.Contains("MAKE_DATE")){ this._makeDate = StringUtil.StringValue(row["MAKE_DATE"]); }
            if (cols.Contains("DOCUMENT_ADDRESS")){ this._documentAddress = StringUtil.StringValue(row["DOCUMENT_ADDRESS"]); }
            if (cols.Contains("AG_COMPANY_CODE")){ this._agCompanyCode = StringUtil.StringValue(row["AG_COMPANY_CODE"]); }
            if (cols.Contains("INSIDE_OPEN_LEVEL")){ this._insideOpenLevel = NumberUtil.Value<Int16?>(row["INSIDE_OPEN_LEVEL"]); }
            if (cols.Contains("OUTSIDE_OPEN_LEVEL")){ this._outsideOpenLevel = NumberUtil.Value<Int16?>(row["OUTSIDE_OPEN_LEVEL"]); }
            if (cols.Contains("HOME_RATE")){ this._homeRate = NumberUtil.Value<Decimal?>(row["HOME_RATE"]); }
            if (cols.Contains("WORK_RATE")){ this._workRate = NumberUtil.Value<Decimal?>(row["WORK_RATE"]); }
            if (cols.Contains("OVERLAP_RATE")){ this._overlapRate = NumberUtil.Value<Decimal?>(row["OVERLAP_RATE"]); }
            if (cols.Contains("BUSINESS_REP_DIRECT_FLAG")){ this._businessRepDirectFlag = NumberUtil.Value<Int16?>(row["BUSINESS_REP_DIRECT_FLAG"]); }
            if (cols.Contains("CLIENT_SITE_FLAG")){ this._clientSiteFlag = NumberUtil.Value<Int16?>(row["CLIENT_SITE_FLAG"]); }
            if (cols.Contains("PRINT_UPPER_SITE_CODE")){ this._printUpperSiteCode = StringUtil.StringValue(row["PRINT_UPPER_SITE_CODE"]); }
            if (cols.Contains("TEAM_CODE")){ this._teamCode = NumberUtil.Value<Int16?>(row["TEAM_CODE"]); }
            if (cols.Contains("CHECK_NAME")){ this._checkName = StringUtil.StringValue(row["CHECK_NAME"]); }
            if (cols.Contains("PRICE_COST_FROM_DATE")){ this._priceCostFromDate = StringUtil.StringValue(row["PRICE_COST_FROM_DATE"]); }
            if (cols.Contains("VALID_FLAG")){ this._validFlag = NumberUtil.Value<Int16?>(row["VALID_FLAG"]); }
            if (cols.Contains("INSERT_DATE_TIME")){ this._insertDateTime = DateUtil.DateValue(row["INSERT_DATE_TIME"]); }
            if (cols.Contains("INSERT_OPERATOR_CODE")){ this._insertOperatorCode = StringUtil.StringValue(row["INSERT_OPERATOR_CODE"]); }
            if (cols.Contains("UPDATE_DATE_TIME")){ this._updateDateTime = DateUtil.DateValue(row["UPDATE_DATE_TIME"]); }
            if (cols.Contains("OPERATOR_CODE")){ this._operatorCode = StringUtil.StringValue(row["OPERATOR_CODE"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "SITE_CODE");if (cols.Contains(columnName)){ this._siteCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "OPEN_DATE");if (cols.Contains(columnName)){ this._openDate = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CLOSE_DATE");if (cols.Contains(columnName)){ this._closeDate = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "SORT_SEQ");if (cols.Contains(columnName)){ this._sortSeq = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "NAME");if (cols.Contains(columnName)){ this._name = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "ANK_NAME");if (cols.Contains(columnName)){ this._ankName = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "COMPANY_CODE");if (cols.Contains(columnName)){ this._companyCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "SITE_URL");if (cols.Contains(columnName)){ this._siteUrl = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "SITE_URL_OTHER");if (cols.Contains(columnName)){ this._siteUrlOther = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "SITE_CATEGORY1");if (cols.Contains(columnName)){ this._siteCategory1 = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "SITE_CATEGORY2");if (cols.Contains(columnName)){ this._siteCategory2 = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "DEVICE_CODE");if (cols.Contains(columnName)){ this._deviceCode = NumberUtil.Value<Int16>(row[columnName]); }
            columnName = BuildColumnName(alias, "MENU_DEVICE_CODE");if (cols.Contains(columnName)){ this._menuDeviceCode = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "MENU_ADTYPE_CODE");if (cols.Contains(columnName)){ this._menuAdtypeCode = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "GOODS_CATEGORY_CODE");if (cols.Contains(columnName)){ this._goodsCategoryCode = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "CARRIER_CODE1");if (cols.Contains(columnName)){ this._carrierCode1 = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "CARRIER_CODE2");if (cols.Contains(columnName)){ this._carrierCode2 = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "CARRIER_CODE3");if (cols.Contains(columnName)){ this._carrierCode3 = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "CARRIER_CODE4");if (cols.Contains(columnName)){ this._carrierCode4 = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "MEDIA_COST_RATE");if (cols.Contains(columnName)){ this._mediaCostRate = NumberUtil.Value<Decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "AGENCY_MARGIN_RATE");if (cols.Contains(columnName)){ this._agencyMarginRate = NumberUtil.Value<Decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "SP_OPEN_FLAG");if (cols.Contains(columnName)){ this._spOpenFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "PM_OPEN_FLAG");if (cols.Contains(columnName)){ this._pmOpenFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "IO_OPEN_FLAG");if (cols.Contains(columnName)){ this._ioOpenFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "AD_GUIDE_OPEN_FLAG");if (cols.Contains(columnName)){ this._adGuideOpenFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "IMPRESSION");if (cols.Contains(columnName)){ this._impression = NumberUtil.Value<Decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "IMPRESSION_TERM");if (cols.Contains(columnName)){ this._impressionTerm = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "IMPRESSION_TOPPAGE");if (cols.Contains(columnName)){ this._impressionToppage = NumberUtil.Value<Decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "IMPRESSION_TOPPAGE_TERM");if (cols.Contains(columnName)){ this._impressionToppageTerm = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "UNIQUE_USER");if (cols.Contains(columnName)){ this._uniqueUser = NumberUtil.Value<Decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "UNIQUE_USER_TERM");if (cols.Contains(columnName)){ this._uniqueUserTerm = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "UNIQUE_USER_TOPPAGE");if (cols.Contains(columnName)){ this._uniqueUserToppage = NumberUtil.Value<Decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "UNIQUE_USER_TOPPAGE_TERM");if (cols.Contains(columnName)){ this._uniqueUserToppageTerm = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "MALE_RATE");if (cols.Contains(columnName)){ this._maleRate = NumberUtil.Value<Decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "FEMALE_RATE");if (cols.Contains(columnName)){ this._femaleRate = NumberUtil.Value<Decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "PUBLISHED_YEAR");if (cols.Contains(columnName)){ this._publishedYear = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "PUBLISHED_MONTH");if (cols.Contains(columnName)){ this._publishedMonth = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "PUBLISHED_DAY");if (cols.Contains(columnName)){ this._publishedDay = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "PUBLISHED_DATA_KIND");if (cols.Contains(columnName)){ this._publishedDataKind = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "UPPER_SITE_CODE");if (cols.Contains(columnName)){ this._upperSiteCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "PAYMENT_COMPANY");if (cols.Contains(columnName)){ this._paymentCompany = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "BUSINESS_DIRECT_FLAG");if (cols.Contains(columnName)){ this._businessDirectFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "ADSERVER_FLAG");if (cols.Contains(columnName)){ this._adserverFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "SPECIALMENU_FLAG");if (cols.Contains(columnName)){ this._specialmenuFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "TOP_OPEN_FLAG");if (cols.Contains(columnName)){ this._topOpenFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "OPEN_MENU_COUNT");if (cols.Contains(columnName)){ this._openMenuCount = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "MAKE_DATE");if (cols.Contains(columnName)){ this._makeDate = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DOCUMENT_ADDRESS");if (cols.Contains(columnName)){ this._documentAddress = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "AG_COMPANY_CODE");if (cols.Contains(columnName)){ this._agCompanyCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "INSIDE_OPEN_LEVEL");if (cols.Contains(columnName)){ this._insideOpenLevel = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "OUTSIDE_OPEN_LEVEL");if (cols.Contains(columnName)){ this._outsideOpenLevel = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "HOME_RATE");if (cols.Contains(columnName)){ this._homeRate = NumberUtil.Value<Decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "WORK_RATE");if (cols.Contains(columnName)){ this._workRate = NumberUtil.Value<Decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "OVERLAP_RATE");if (cols.Contains(columnName)){ this._overlapRate = NumberUtil.Value<Decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "BUSINESS_REP_DIRECT_FLAG");if (cols.Contains(columnName)){ this._businessRepDirectFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "CLIENT_SITE_FLAG");if (cols.Contains(columnName)){ this._clientSiteFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "PRINT_UPPER_SITE_CODE");if (cols.Contains(columnName)){ this._printUpperSiteCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "TEAM_CODE");if (cols.Contains(columnName)){ this._teamCode = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "CHECK_NAME");if (cols.Contains(columnName)){ this._checkName = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "PRICE_COST_FROM_DATE");if (cols.Contains(columnName)){ this._priceCostFromDate = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "VALID_FLAG");if (cols.Contains(columnName)){ this._validFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "INSERT_DATE_TIME");if (cols.Contains(columnName)){ this._insertDateTime = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "INSERT_OPERATOR_CODE");if (cols.Contains(columnName)){ this._insertOperatorCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "UPDATE_DATE_TIME");if (cols.Contains(columnName)){ this._updateDateTime = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "OPERATOR_CODE");if (cols.Contains(columnName)){ this._operatorCode = StringUtil.StringValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._siteCode = StringUtil.StringValue(reader[0]);
            this._openDate = StringUtil.StringValue(reader[1]);
            this._closeDate = StringUtil.StringValue(reader[2]);
            this._sortSeq = NumberUtil.Value<Int16?>(reader[3]);
            this._name = StringUtil.StringValue(reader[4]);
            this._ankName = StringUtil.StringValue(reader[5]);
            this._companyCode = StringUtil.StringValue(reader[6]);
            this._siteUrl = StringUtil.StringValue(reader[7]);
            this._siteUrlOther = StringUtil.StringValue(reader[8]);
            this._siteCategory1 = NumberUtil.Value<Int16?>(reader[9]);
            this._siteCategory2 = NumberUtil.Value<Int16?>(reader[10]);
            this._deviceCode = NumberUtil.Value<Int16>(reader[11]);
            this._menuDeviceCode = NumberUtil.Value<Int16?>(reader[12]);
            this._menuAdtypeCode = NumberUtil.Value<Int16?>(reader[13]);
            this._goodsCategoryCode = NumberUtil.Value<Int16?>(reader[14]);
            this._carrierCode1 = NumberUtil.Value<Int16?>(reader[15]);
            this._carrierCode2 = NumberUtil.Value<Int16?>(reader[16]);
            this._carrierCode3 = NumberUtil.Value<Int16?>(reader[17]);
            this._carrierCode4 = NumberUtil.Value<Int16?>(reader[18]);
            this._mediaCostRate = NumberUtil.Value<Decimal?>(reader[19]);
            this._agencyMarginRate = NumberUtil.Value<Decimal?>(reader[20]);
            this._spOpenFlag = NumberUtil.Value<Int16?>(reader[21]);
            this._pmOpenFlag = NumberUtil.Value<Int16?>(reader[22]);
            this._ioOpenFlag = NumberUtil.Value<Int16?>(reader[23]);
            this._adGuideOpenFlag = NumberUtil.Value<Int16?>(reader[24]);
            this._impression = NumberUtil.Value<Decimal?>(reader[25]);
            this._impressionTerm = NumberUtil.Value<Int16?>(reader[26]);
            this._impressionToppage = NumberUtil.Value<Decimal?>(reader[27]);
            this._impressionToppageTerm = NumberUtil.Value<Int16?>(reader[28]);
            this._uniqueUser = NumberUtil.Value<Decimal?>(reader[29]);
            this._uniqueUserTerm = NumberUtil.Value<Int16?>(reader[30]);
            this._uniqueUserToppage = NumberUtil.Value<Decimal?>(reader[31]);
            this._uniqueUserToppageTerm = NumberUtil.Value<Int16?>(reader[32]);
            this._maleRate = NumberUtil.Value<Decimal?>(reader[33]);
            this._femaleRate = NumberUtil.Value<Decimal?>(reader[34]);
            this._publishedYear = NumberUtil.Value<Int16?>(reader[35]);
            this._publishedMonth = NumberUtil.Value<Int16?>(reader[36]);
            this._publishedDay = NumberUtil.Value<Int16?>(reader[37]);
            this._publishedDataKind = NumberUtil.Value<Int16?>(reader[38]);
            this._upperSiteCode = StringUtil.StringValue(reader[39]);
            this._paymentCompany = StringUtil.StringValue(reader[40]);
            this._businessDirectFlag = NumberUtil.Value<Int16?>(reader[41]);
            this._adserverFlag = NumberUtil.Value<Int16?>(reader[42]);
            this._specialmenuFlag = NumberUtil.Value<Int16?>(reader[43]);
            this._topOpenFlag = NumberUtil.Value<Int16?>(reader[44]);
            this._openMenuCount = NumberUtil.Value<Int16?>(reader[45]);
            this._makeDate = StringUtil.StringValue(reader[46]);
            this._documentAddress = StringUtil.StringValue(reader[47]);
            this._agCompanyCode = StringUtil.StringValue(reader[48]);
            this._insideOpenLevel = NumberUtil.Value<Int16?>(reader[49]);
            this._outsideOpenLevel = NumberUtil.Value<Int16?>(reader[50]);
            this._homeRate = NumberUtil.Value<Decimal?>(reader[51]);
            this._workRate = NumberUtil.Value<Decimal?>(reader[52]);
            this._overlapRate = NumberUtil.Value<Decimal?>(reader[53]);
            this._businessRepDirectFlag = NumberUtil.Value<Int16?>(reader[54]);
            this._clientSiteFlag = NumberUtil.Value<Int16?>(reader[55]);
            this._printUpperSiteCode = StringUtil.StringValue(reader[56]);
            this._teamCode = NumberUtil.Value<Int16?>(reader[57]);
            this._checkName = StringUtil.StringValue(reader[58]);
            this._priceCostFromDate = StringUtil.StringValue(reader[59]);
            this._validFlag = NumberUtil.Value<Int16?>(reader[60]);
            this._insertDateTime = DateUtil.DateValue(reader[61]);
            this._insertOperatorCode = StringUtil.StringValue(reader[62]);
            this._updateDateTime = DateUtil.DateValue(reader[63]);
            this._operatorCode = StringUtil.StringValue(reader[64]);
            
            this.IsNew = false;
        }
    }

}