using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace Sample.Data.Models.Base
{
    /// <summary>
    /// table MAST_MENU Field`
    /// </summary>
    [Serializable()]
    public class MastMenuTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[SITE_CODE]</summary>
        protected string _siteCode;
        ///<summary>[SITE_CODE]</summary>
        public string siteCode{
            get{return _siteCode;}
            set{_siteCode = value;}
        }
        ///<summary>[MENU_CODE]</summary>
        protected string _menuCode;
        ///<summary>[MENU_CODE]</summary>
        public string menuCode{
            get{return _menuCode;}
            set{_menuCode = value;}
        }
        ///<summary>[SORT_SEQ]</summary>
        protected System.Nullable<Int16> _sortSeq;
        ///<summary>[SORT_SEQ]</summary>
        public System.Nullable<Int16> sortSeq{
            get{return _sortSeq;}
            set{_sortSeq = value;}
        }
        ///<summary>[OPEN_DATE]</summary>
        protected string _openDate;
        ///<summary>[OPEN_DATE]</summary>
        public string openDate{
            get{return _openDate;}
            set{_openDate = value;}
        }
        ///<summary>[CLOSE_DATE]</summary>
        protected string _closeDate;
        ///<summary>[CLOSE_DATE]</summary>
        public string closeDate{
            get{return _closeDate;}
            set{_closeDate = value;}
        }
        ///<summary>[MENU_GROUP_CODE]</summary>
        protected System.Nullable<Int16> _menuGroupCode;
        ///<summary>[MENU_GROUP_CODE]</summary>
        public System.Nullable<Int16> menuGroupCode{
            get{return _menuGroupCode;}
            set{_menuGroupCode = value;}
        }
        ///<summary>[NAME]</summary>
        protected string _name;
        ///<summary>[NAME]</summary>
        public string name{
            get{return _name;}
            set{_name = value;}
        }
        ///<summary>[ANK_NAME]</summary>
        protected string _ankName;
        ///<summary>[ANK_NAME]</summary>
        public string ankName{
            get{return _ankName;}
            set{_ankName = value;}
        }
        ///<summary>[DEVICE_CODE]</summary>
        protected Int16 _deviceCode;
        ///<summary>[DEVICE_CODE]</summary>
        public Int16 deviceCode{
            get{return _deviceCode;}
            set{_deviceCode = value;}
        }
        ///<summary>[MENU_DEVICE_CODE]</summary>
        protected System.Nullable<Int16> _menuDeviceCode;
        ///<summary>[MENU_DEVICE_CODE]</summary>
        public System.Nullable<Int16> menuDeviceCode{
            get{return _menuDeviceCode;}
            set{_menuDeviceCode = value;}
        }
        ///<summary>[MENU_ADTYPE_CODE]</summary>
        protected System.Nullable<Int16> _menuAdtypeCode;
        ///<summary>[MENU_ADTYPE_CODE]</summary>
        public System.Nullable<Int16> menuAdtypeCode{
            get{return _menuAdtypeCode;}
            set{_menuAdtypeCode = value;}
        }
        ///<summary>[OPTIN_TYPE]</summary>
        protected System.Nullable<Int16> _optinType;
        ///<summary>[OPTIN_TYPE]</summary>
        public System.Nullable<Int16> optinType{
            get{return _optinType;}
            set{_optinType = value;}
        }
        ///<summary>[MANAGEMENT_CODE]</summary>
        protected Int16 _managementCode;
        ///<summary>[MANAGEMENT_CODE]</summary>
        public Int16 managementCode{
            get{return _managementCode;}
            set{_managementCode = value;}
        }
        ///<summary>[GUARANTEE_CODE]</summary>
        protected Int16 _guaranteeCode;
        ///<summary>[GUARANTEE_CODE]</summary>
        public Int16 guaranteeCode{
            get{return _guaranteeCode;}
            set{_guaranteeCode = value;}
        }
        ///<summary>[MENU_CATEGORY1]</summary>
        protected System.Nullable<Int16> _menuCategory1;
        ///<summary>[MENU_CATEGORY1]</summary>
        public System.Nullable<Int16> menuCategory1{
            get{return _menuCategory1;}
            set{_menuCategory1 = value;}
        }
        ///<summary>[MENU_CATEGORY2]</summary>
        protected System.Nullable<Int16> _menuCategory2;
        ///<summary>[MENU_CATEGORY2]</summary>
        public System.Nullable<Int16> menuCategory2{
            get{return _menuCategory2;}
            set{_menuCategory2 = value;}
        }
        ///<summary>[LIST_CODE]</summary>
        protected System.Nullable<Int16> _listCode;
        ///<summary>[LIST_CODE]</summary>
        public System.Nullable<Int16> listCode{
            get{return _listCode;}
            set{_listCode = value;}
        }
        ///<summary>[FLAME_COUNT]</summary>
        protected System.Nullable<Int16> _flameCount;
        ///<summary>[FLAME_COUNT]</summary>
        public System.Nullable<Int16> flameCount{
            get{return _flameCount;}
            set{_flameCount = value;}
        }
        ///<summary>[FLAME_COUNT_KIND]</summary>
        protected Int16 _flameCountKind;
        ///<summary>[FLAME_COUNT_KIND]</summary>
        public Int16 flameCountKind{
            get{return _flameCountKind;}
            set{_flameCountKind = value;}
        }
        ///<summary>[ROTATION_FLAME_COUNT]</summary>
        protected System.Nullable<Int16> _rotationFlameCount;
        ///<summary>[ROTATION_FLAME_COUNT]</summary>
        public System.Nullable<Int16> rotationFlameCount{
            get{return _rotationFlameCount;}
            set{_rotationFlameCount = value;}
        }
        ///<summary>[FLAME_SELECT_FLAG]</summary>
        protected System.Nullable<Int16> _flameSelectFlag;
        ///<summary>[FLAME_SELECT_FLAG]</summary>
        public System.Nullable<Int16> flameSelectFlag{
            get{return _flameSelectFlag;}
            set{_flameSelectFlag = value;}
        }
        ///<summary>[GOODS_CATEGORY_CODE]</summary>
        protected System.Nullable<Int16> _goodsCategoryCode;
        ///<summary>[GOODS_CATEGORY_CODE]</summary>
        public System.Nullable<Int16> goodsCategoryCode{
            get{return _goodsCategoryCode;}
            set{_goodsCategoryCode = value;}
        }
        ///<summary>[PAYMENT_COMPANY]</summary>
        protected string _paymentCompany;
        ///<summary>[PAYMENT_COMPANY]</summary>
        public string paymentCompany{
            get{return _paymentCompany;}
            set{_paymentCompany = value;}
        }
        ///<summary>[SP_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _spOpenFlag;
        ///<summary>[SP_OPEN_FLAG]</summary>
        public System.Nullable<Int16> spOpenFlag{
            get{return _spOpenFlag;}
            set{_spOpenFlag = value;}
        }
        ///<summary>[PM_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _pmOpenFlag;
        ///<summary>[PM_OPEN_FLAG]</summary>
        public System.Nullable<Int16> pmOpenFlag{
            get{return _pmOpenFlag;}
            set{_pmOpenFlag = value;}
        }
        ///<summary>[AD_GUIDE_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _adGuideOpenFlag;
        ///<summary>[AD_GUIDE_OPEN_FLAG]</summary>
        public System.Nullable<Int16> adGuideOpenFlag{
            get{return _adGuideOpenFlag;}
            set{_adGuideOpenFlag = value;}
        }
        ///<summary>[REGULATION_GUIDE_FLAG]</summary>
        protected System.Nullable<Int16> _regulationGuideFlag;
        ///<summary>[REGULATION_GUIDE_FLAG]</summary>
        public System.Nullable<Int16> regulationGuideFlag{
            get{return _regulationGuideFlag;}
            set{_regulationGuideFlag = value;}
        }
        ///<summary>[IO_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _ioOpenFlag;
        ///<summary>[IO_OPEN_FLAG]</summary>
        public System.Nullable<Int16> ioOpenFlag{
            get{return _ioOpenFlag;}
            set{_ioOpenFlag = value;}
        }
        ///<summary>[ES_AUDIENCE_FLAG]</summary>
        protected System.Nullable<Int16> _esAudienceFlag;
        ///<summary>[ES_AUDIENCE_FLAG]</summary>
        public System.Nullable<Int16> esAudienceFlag{
            get{return _esAudienceFlag;}
            set{_esAudienceFlag = value;}
        }
        ///<summary>[ES_PERFORMANCE_FLAG]</summary>
        protected System.Nullable<Int16> _esPerformanceFlag;
        ///<summary>[ES_PERFORMANCE_FLAG]</summary>
        public System.Nullable<Int16> esPerformanceFlag{
            get{return _esPerformanceFlag;}
            set{_esPerformanceFlag = value;}
        }
        ///<summary>[ES_REACH_FLAG]</summary>
        protected System.Nullable<Int16> _esReachFlag;
        ///<summary>[ES_REACH_FLAG]</summary>
        public System.Nullable<Int16> esReachFlag{
            get{return _esReachFlag;}
            set{_esReachFlag = value;}
        }
        ///<summary>[SEARCH_URL_FLAG]</summary>
        protected System.Nullable<Int16> _searchUrlFlag;
        ///<summary>[SEARCH_URL_FLAG]</summary>
        public System.Nullable<Int16> searchUrlFlag{
            get{return _searchUrlFlag;}
            set{_searchUrlFlag = value;}
        }
        ///<summary>[PACKAGE_FLAG]</summary>
        protected System.Nullable<Int16> _packageFlag;
        ///<summary>[PACKAGE_FLAG]</summary>
        public System.Nullable<Int16> packageFlag{
            get{return _packageFlag;}
            set{_packageFlag = value;}
        }
        ///<summary>[MENU_SELECTION_COUNT]</summary>
        protected System.Nullable<Int16> _menuSelectionCount;
        ///<summary>[MENU_SELECTION_COUNT]</summary>
        public System.Nullable<Int16> menuSelectionCount{
            get{return _menuSelectionCount;}
            set{_menuSelectionCount = value;}
        }
        ///<summary>[CARRIER_CODE1]</summary>
        protected System.Nullable<Int16> _carrierCode1;
        ///<summary>[CARRIER_CODE1]</summary>
        public System.Nullable<Int16> carrierCode1{
            get{return _carrierCode1;}
            set{_carrierCode1 = value;}
        }
        ///<summary>[CARRIER_CODE2]</summary>
        protected System.Nullable<Int16> _carrierCode2;
        ///<summary>[CARRIER_CODE2]</summary>
        public System.Nullable<Int16> carrierCode2{
            get{return _carrierCode2;}
            set{_carrierCode2 = value;}
        }
        ///<summary>[CARRIER_CODE3]</summary>
        protected System.Nullable<Int16> _carrierCode3;
        ///<summary>[CARRIER_CODE3]</summary>
        public System.Nullable<Int16> carrierCode3{
            get{return _carrierCode3;}
            set{_carrierCode3 = value;}
        }
        ///<summary>[CARRIER_CODE4]</summary>
        protected System.Nullable<Int16> _carrierCode4;
        ///<summary>[CARRIER_CODE4]</summary>
        public System.Nullable<Int16> carrierCode4{
            get{return _carrierCode4;}
            set{_carrierCode4 = value;}
        }
        ///<summary>[PAGE_REMARKS]</summary>
        protected string _pageRemarks;
        ///<summary>[PAGE_REMARKS]</summary>
        public string pageRemarks{
            get{return _pageRemarks;}
            set{_pageRemarks = value;}
        }
        ///<summary>[REMARKS]</summary>
        protected string _remarks;
        ///<summary>[REMARKS]</summary>
        public string remarks{
            get{return _remarks;}
            set{_remarks = value;}
        }
        ///<summary>[DAC_REMARKS]</summary>
        protected string _dacRemarks;
        ///<summary>[DAC_REMARKS]</summary>
        public string dacRemarks{
            get{return _dacRemarks;}
            set{_dacRemarks = value;}
        }
        ///<summary>[B_STATUS]</summary>
        protected string _bStatus;
        ///<summary>[B_STATUS]</summary>
        public string bStatus{
            get{return _bStatus;}
            set{_bStatus = value;}
        }
        ///<summary>[D_STATUS]</summary>
        protected string _dStatus;
        ///<summary>[D_STATUS]</summary>
        public string dStatus{
            get{return _dStatus;}
            set{_dStatus = value;}
        }
        ///<summary>[P_STATUS]</summary>
        protected string _pStatus;
        ///<summary>[P_STATUS]</summary>
        public string pStatus{
            get{return _pStatus;}
            set{_pStatus = value;}
        }
        ///<summary>[P_CAMPAIGN_STATUS_FROM]</summary>
        protected string _pCampaignStatusFrom;
        ///<summary>[P_CAMPAIGN_STATUS_FROM]</summary>
        public string pCampaignStatusFrom{
            get{return _pCampaignStatusFrom;}
            set{_pCampaignStatusFrom = value;}
        }
        ///<summary>[P_CAMPAIGN_STATUS_TO]</summary>
        protected string _pCampaignStatusTo;
        ///<summary>[P_CAMPAIGN_STATUS_TO]</summary>
        public string pCampaignStatusTo{
            get{return _pCampaignStatusTo;}
            set{_pCampaignStatusTo = value;}
        }
        ///<summary>[M_STATUS]</summary>
        protected string _mStatus;
        ///<summary>[M_STATUS]</summary>
        public string mStatus{
            get{return _mStatus;}
            set{_mStatus = value;}
        }
        ///<summary>[T_STATUS]</summary>
        protected string _tStatus;
        ///<summary>[T_STATUS]</summary>
        public string tStatus{
            get{return _tStatus;}
            set{_tStatus = value;}
        }
        ///<summary>[TOTAL_STATUS]</summary>
        protected string _totalStatus;
        ///<summary>[TOTAL_STATUS]</summary>
        public string totalStatus{
            get{return _totalStatus;}
            set{_totalStatus = value;}
        }
        ///<summary>[TOTAL_STATUS_TO]</summary>
        protected string _totalStatusTo;
        ///<summary>[TOTAL_STATUS_TO]</summary>
        public string totalStatusTo{
            get{return _totalStatusTo;}
            set{_totalStatusTo = value;}
        }
        ///<summary>[COUNT_URL_KIND]</summary>
        protected System.Nullable<Int16> _countUrlKind;
        ///<summary>[COUNT_URL_KIND]</summary>
        public System.Nullable<Int16> countUrlKind{
            get{return _countUrlKind;}
            set{_countUrlKind = value;}
        }
        ///<summary>[COUNT_URL]</summary>
        protected string _countUrl;
        ///<summary>[COUNT_URL]</summary>
        public string countUrl{
            get{return _countUrl;}
            set{_countUrl = value;}
        }
        ///<summary>[REPORT_KIND]</summary>
        protected Int16 _reportKind;
        ///<summary>[REPORT_KIND]</summary>
        public Int16 reportKind{
            get{return _reportKind;}
            set{_reportKind = value;}
        }
        ///<summary>[REPORT_DETAIL]</summary>
        protected string _reportDetail;
        ///<summary>[REPORT_DETAIL]</summary>
        public string reportDetail{
            get{return _reportDetail;}
            set{_reportDetail = value;}
        }
        ///<summary>[REPORT_RECEIVE]</summary>
        protected string _reportReceive;
        ///<summary>[REPORT_RECEIVE]</summary>
        public string reportReceive{
            get{return _reportReceive;}
            set{_reportReceive = value;}
        }
        ///<summary>[SEGMENT_EQUAL_FLAG]</summary>
        protected System.Nullable<Int16> _segmentEqualFlag;
        ///<summary>[SEGMENT_EQUAL_FLAG]</summary>
        public System.Nullable<Int16> segmentEqualFlag{
            get{return _segmentEqualFlag;}
            set{_segmentEqualFlag = value;}
        }
        ///<summary>[STOCK_FLAG]</summary>
        protected System.Nullable<Int16> _stockFlag;
        ///<summary>[STOCK_FLAG]</summary>
        public System.Nullable<Int16> stockFlag{
            get{return _stockFlag;}
            set{_stockFlag = value;}
        }
        ///<summary>[STOCK_COUNT]</summary>
        protected System.Nullable<Int16> _stockCount;
        ///<summary>[STOCK_COUNT]</summary>
        public System.Nullable<Int16> stockCount{
            get{return _stockCount;}
            set{_stockCount = value;}
        }
        ///<summary>[CAPTURE_SEQ]</summary>
        protected string _captureSeq;
        ///<summary>[CAPTURE_SEQ]</summary>
        public string captureSeq{
            get{return _captureSeq;}
            set{_captureSeq = value;}
        }
        ///<summary>[AG_COMPANY_CODE]</summary>
        protected string _agCompanyCode;
        ///<summary>[AG_COMPANY_CODE]</summary>
        public string agCompanyCode{
            get{return _agCompanyCode;}
            set{_agCompanyCode = value;}
        }
        ///<summary>[INSIDE_OPEN_LEVEL]</summary>
        protected System.Nullable<Int16> _insideOpenLevel;
        ///<summary>[INSIDE_OPEN_LEVEL]</summary>
        public System.Nullable<Int16> insideOpenLevel{
            get{return _insideOpenLevel;}
            set{_insideOpenLevel = value;}
        }
        ///<summary>[OUTSIDE_OPEN_LEVEL]</summary>
        protected System.Nullable<Int16> _outsideOpenLevel;
        ///<summary>[OUTSIDE_OPEN_LEVEL]</summary>
        public System.Nullable<Int16> outsideOpenLevel{
            get{return _outsideOpenLevel;}
            set{_outsideOpenLevel = value;}
        }
        ///<summary>[LIMIT_OPEN_REMARKS]</summary>
        protected string _limitOpenRemarks;
        ///<summary>[LIMIT_OPEN_REMARKS]</summary>
        public string limitOpenRemarks{
            get{return _limitOpenRemarks;}
            set{_limitOpenRemarks = value;}
        }
        ///<summary>[PUBLISH_PAGE_FLAG]</summary>
        protected System.Nullable<Int16> _publishPageFlag;
        ///<summary>[PUBLISH_PAGE_FLAG]</summary>
        public System.Nullable<Int16> publishPageFlag{
            get{return _publishPageFlag;}
            set{_publishPageFlag = value;}
        }
        ///<summary>[ES_REMARKS]</summary>
        protected string _esRemarks;
        ///<summary>[ES_REMARKS]</summary>
        public string esRemarks{
            get{return _esRemarks;}
            set{_esRemarks = value;}
        }
        ///<summary>[MENU_FRAME_CODE]</summary>
        protected string _menuFrameCode;
        ///<summary>[MENU_FRAME_CODE]</summary>
        public string menuFrameCode{
            get{return _menuFrameCode;}
            set{_menuFrameCode = value;}
        }
        ///<summary>[FRAME_NAME_REFRECT_FLAG]</summary>
        protected System.Nullable<Int16> _frameNameRefrectFlag;
        ///<summary>[FRAME_NAME_REFRECT_FLAG]</summary>
        public System.Nullable<Int16> frameNameRefrectFlag{
            get{return _frameNameRefrectFlag;}
            set{_frameNameRefrectFlag = value;}
        }
        ///<summary>[DELIVERY_OPTION_NAME]</summary>
        protected string _deliveryOptionName;
        ///<summary>[DELIVERY_OPTION_NAME]</summary>
        public string deliveryOptionName{
            get{return _deliveryOptionName;}
            set{_deliveryOptionName = value;}
        }
        ///<summary>[GET_REPORT_DESTINATION]</summary>
        protected string _getReportDestination;
        ///<summary>[GET_REPORT_DESTINATION]</summary>
        public string getReportDestination{
            get{return _getReportDestination;}
            set{_getReportDestination = value;}
        }
        ///<summary>[REPORT_TREAT_KIND_SEQ]</summary>
        protected System.Nullable<Int16> _reportTreatKindSeq;
        ///<summary>[REPORT_TREAT_KIND_SEQ]</summary>
        public System.Nullable<Int16> reportTreatKindSeq{
            get{return _reportTreatKindSeq;}
            set{_reportTreatKindSeq = value;}
        }
        ///<summary>[USE_SITE_LIMIT_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _useSiteLimitOpenFlag;
        ///<summary>[USE_SITE_LIMIT_OPEN_FLAG]</summary>
        public System.Nullable<Int16> useSiteLimitOpenFlag{
            get{return _useSiteLimitOpenFlag;}
            set{_useSiteLimitOpenFlag = value;}
        }
        ///<summary>[USE_SITE_CARRIER_FLAG]</summary>
        protected System.Nullable<Int16> _useSiteCarrierFlag;
        ///<summary>[USE_SITE_CARRIER_FLAG]</summary>
        public System.Nullable<Int16> useSiteCarrierFlag{
            get{return _useSiteCarrierFlag;}
            set{_useSiteCarrierFlag = value;}
        }
        ///<summary>[COST_MENU_FLAG]</summary>
        protected System.Nullable<Int16> _costMenuFlag;
        ///<summary>[COST_MENU_FLAG]</summary>
        public System.Nullable<Int16> costMenuFlag{
            get{return _costMenuFlag;}
            set{_costMenuFlag = value;}
        }
        ///<summary>[CHECK_NAME]</summary>
        protected string _checkName;
        ///<summary>[CHECK_NAME]</summary>
        public string checkName{
            get{return _checkName;}
            set{_checkName = value;}
        }
        ///<summary>[PRICE_GROUP_FROM_DATE]</summary>
        protected string _priceGroupFromDate;
        ///<summary>[PRICE_GROUP_FROM_DATE]</summary>
        public string priceGroupFromDate{
            get{return _priceGroupFromDate;}
            set{_priceGroupFromDate = value;}
        }
        ///<summary>[MANUSCRIPT_FROM_DATE]</summary>
        protected string _manuscriptFromDate;
        ///<summary>[MANUSCRIPT_FROM_DATE]</summary>
        public string manuscriptFromDate{
            get{return _manuscriptFromDate;}
            set{_manuscriptFromDate = value;}
        }
        ///<summary>[PRICE_COST_FROM_DATE]</summary>
        protected string _priceCostFromDate;
        ///<summary>[PRICE_COST_FROM_DATE]</summary>
        public string priceCostFromDate{
            get{return _priceCostFromDate;}
            set{_priceCostFromDate = value;}
        }
        ///<summary>[TRANSMIT_FROM_DATE]</summary>
        protected string _transmitFromDate;
        ///<summary>[TRANSMIT_FROM_DATE]</summary>
        public string transmitFromDate{
            get{return _transmitFromDate;}
            set{_transmitFromDate = value;}
        }
        ///<summary>[REFER_SITE_PRICE_COST_FLAG]</summary>
        protected System.Nullable<Int16> _referSitePriceCostFlag;
        ///<summary>[REFER_SITE_PRICE_COST_FLAG]</summary>
        public System.Nullable<Int16> referSitePriceCostFlag{
            get{return _referSitePriceCostFlag;}
            set{_referSitePriceCostFlag = value;}
        }
        ///<summary>[TEAM_CODE]</summary>
        protected System.Nullable<Int16> _teamCode;
        ///<summary>[TEAM_CODE]</summary>
        public System.Nullable<Int16> teamCode{
            get{return _teamCode;}
            set{_teamCode = value;}
        }
        ///<summary>[VALID_FLAG]</summary>
        protected System.Nullable<Int16> _validFlag;
        ///<summary>[VALID_FLAG]</summary>
        public System.Nullable<Int16> validFlag{
            get{return _validFlag;}
            set{_validFlag = value;}
        }
        ///<summary>[BASE_UPDATE_DATE_TIME]</summary>
        protected DateTime? _baseUpdateDateTime;
        ///<summary>[BASE_UPDATE_DATE_TIME]</summary>
        public DateTime? baseUpdateDateTime{
            get{return _baseUpdateDateTime;}
            set{_baseUpdateDateTime = value;}
        }
        ///<summary>[INSERT_DATE_TIME]</summary>
        protected DateTime? _insertDateTime;
        ///<summary>[INSERT_DATE_TIME]</summary>
        public DateTime? insertDateTime{
            get{return _insertDateTime;}
            set{_insertDateTime = value;}
        }
        ///<summary>[INSERT_OPERATOR_CODE]</summary>
        protected string _insertOperatorCode;
        ///<summary>[INSERT_OPERATOR_CODE]</summary>
        public string insertOperatorCode{
            get{return _insertOperatorCode;}
            set{_insertOperatorCode = value;}
        }
        ///<summary>[UPDATE_DATE_TIME]</summary>
        protected DateTime? _updateDateTime;
        ///<summary>[UPDATE_DATE_TIME]</summary>
        public DateTime? updateDateTime{
            get{return _updateDateTime;}
            set{_updateDateTime = value;}
        }
        ///<summary>[OPERATOR_CODE]</summary>
        protected string _operatorCode;
        ///<summary>[OPERATOR_CODE]</summary>
        public string operatorCode{
            get{return _operatorCode;}
            set{_operatorCode = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public MastMenuTableRow() : base()
        {
            this._siteCode = "";
            this._menuCode = "";
            this._sortSeq = null;
            this._openDate = "";
            this._closeDate = "";
            this._menuGroupCode = null;
            this._name = "";
            this._ankName = "";
            this._deviceCode = 0;
            this._menuDeviceCode = null;
            this._menuAdtypeCode = null;
            this._optinType = null;
            this._managementCode = 0;
            this._guaranteeCode = 0;
            this._menuCategory1 = null;
            this._menuCategory2 = null;
            this._listCode = null;
            this._flameCount = null;
            this._flameCountKind = 0;
            this._rotationFlameCount = null;
            this._flameSelectFlag = null;
            this._goodsCategoryCode = null;
            this._paymentCompany = "";
            this._spOpenFlag = null;
            this._pmOpenFlag = null;
            this._adGuideOpenFlag = null;
            this._regulationGuideFlag = null;
            this._ioOpenFlag = null;
            this._esAudienceFlag = null;
            this._esPerformanceFlag = null;
            this._esReachFlag = null;
            this._searchUrlFlag = null;
            this._packageFlag = null;
            this._menuSelectionCount = null;
            this._carrierCode1 = null;
            this._carrierCode2 = null;
            this._carrierCode3 = null;
            this._carrierCode4 = null;
            this._pageRemarks = "";
            this._remarks = "";
            this._dacRemarks = "";
            this._bStatus = "";
            this._dStatus = "";
            this._pStatus = "";
            this._pCampaignStatusFrom = "";
            this._pCampaignStatusTo = "";
            this._mStatus = "";
            this._tStatus = "";
            this._totalStatus = "";
            this._totalStatusTo = "";
            this._countUrlKind = null;
            this._countUrl = "";
            this._reportKind = 0;
            this._reportDetail = "";
            this._reportReceive = "";
            this._segmentEqualFlag = null;
            this._stockFlag = null;
            this._stockCount = null;
            this._captureSeq = "";
            this._agCompanyCode = "";
            this._insideOpenLevel = null;
            this._outsideOpenLevel = null;
            this._limitOpenRemarks = "";
            this._publishPageFlag = null;
            this._esRemarks = "";
            this._menuFrameCode = "";
            this._frameNameRefrectFlag = null;
            this._deliveryOptionName = "";
            this._getReportDestination = "";
            this._reportTreatKindSeq = null;
            this._useSiteLimitOpenFlag = null;
            this._useSiteCarrierFlag = null;
            this._costMenuFlag = null;
            this._checkName = "";
            this._priceGroupFromDate = "";
            this._manuscriptFromDate = "";
            this._priceCostFromDate = "";
            this._transmitFromDate = "";
            this._referSitePriceCostFlag = null;
            this._teamCode = null;
            this._validFlag = null;
            this._baseUpdateDateTime = null;
            this._insertDateTime = null;
            this._insertOperatorCode = "";
            this._updateDateTime = null;
            this._operatorCode = "";
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "SITE_CODE"){ this._siteCode = StringUtil.StringValue( value );return; }
            if(name ==  "MENU_CODE"){ this._menuCode = StringUtil.StringValue( value );return; }
            if(name ==  "SORT_SEQ"){ this._sortSeq = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "OPEN_DATE"){ this._openDate = StringUtil.StringValue( value );return; }
            if(name ==  "CLOSE_DATE"){ this._closeDate = StringUtil.StringValue( value );return; }
            if(name ==  "MENU_GROUP_CODE"){ this._menuGroupCode = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "NAME"){ this._name = StringUtil.StringValue( value );return; }
            if(name ==  "ANK_NAME"){ this._ankName = StringUtil.StringValue( value );return; }
            if(name ==  "DEVICE_CODE"){ this._deviceCode = NumberUtil.Value<Int16>( value );return; }
            if(name ==  "MENU_DEVICE_CODE"){ this._menuDeviceCode = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "MENU_ADTYPE_CODE"){ this._menuAdtypeCode = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "OPTIN_TYPE"){ this._optinType = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "MANAGEMENT_CODE"){ this._managementCode = NumberUtil.Value<Int16>( value );return; }
            if(name ==  "GUARANTEE_CODE"){ this._guaranteeCode = NumberUtil.Value<Int16>( value );return; }
            if(name ==  "MENU_CATEGORY1"){ this._menuCategory1 = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "MENU_CATEGORY2"){ this._menuCategory2 = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "LIST_CODE"){ this._listCode = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "FLAME_COUNT"){ this._flameCount = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "FLAME_COUNT_KIND"){ this._flameCountKind = NumberUtil.Value<Int16>( value );return; }
            if(name ==  "ROTATION_FLAME_COUNT"){ this._rotationFlameCount = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "FLAME_SELECT_FLAG"){ this._flameSelectFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "GOODS_CATEGORY_CODE"){ this._goodsCategoryCode = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "PAYMENT_COMPANY"){ this._paymentCompany = StringUtil.StringValue( value );return; }
            if(name ==  "SP_OPEN_FLAG"){ this._spOpenFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "PM_OPEN_FLAG"){ this._pmOpenFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "AD_GUIDE_OPEN_FLAG"){ this._adGuideOpenFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "REGULATION_GUIDE_FLAG"){ this._regulationGuideFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "IO_OPEN_FLAG"){ this._ioOpenFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "ES_AUDIENCE_FLAG"){ this._esAudienceFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "ES_PERFORMANCE_FLAG"){ this._esPerformanceFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "ES_REACH_FLAG"){ this._esReachFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "SEARCH_URL_FLAG"){ this._searchUrlFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "PACKAGE_FLAG"){ this._packageFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "MENU_SELECTION_COUNT"){ this._menuSelectionCount = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "CARRIER_CODE1"){ this._carrierCode1 = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "CARRIER_CODE2"){ this._carrierCode2 = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "CARRIER_CODE3"){ this._carrierCode3 = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "CARRIER_CODE4"){ this._carrierCode4 = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "PAGE_REMARKS"){ this._pageRemarks = StringUtil.StringValue( value );return; }
            if(name ==  "REMARKS"){ this._remarks = StringUtil.StringValue( value );return; }
            if(name ==  "DAC_REMARKS"){ this._dacRemarks = StringUtil.StringValue( value );return; }
            if(name ==  "B_STATUS"){ this._bStatus = StringUtil.StringValue( value );return; }
            if(name ==  "D_STATUS"){ this._dStatus = StringUtil.StringValue( value );return; }
            if(name ==  "P_STATUS"){ this._pStatus = StringUtil.StringValue( value );return; }
            if(name ==  "P_CAMPAIGN_STATUS_FROM"){ this._pCampaignStatusFrom = StringUtil.StringValue( value );return; }
            if(name ==  "P_CAMPAIGN_STATUS_TO"){ this._pCampaignStatusTo = StringUtil.StringValue( value );return; }
            if(name ==  "M_STATUS"){ this._mStatus = StringUtil.StringValue( value );return; }
            if(name ==  "T_STATUS"){ this._tStatus = StringUtil.StringValue( value );return; }
            if(name ==  "TOTAL_STATUS"){ this._totalStatus = StringUtil.StringValue( value );return; }
            if(name ==  "TOTAL_STATUS_TO"){ this._totalStatusTo = StringUtil.StringValue( value );return; }
            if(name ==  "COUNT_URL_KIND"){ this._countUrlKind = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "COUNT_URL"){ this._countUrl = StringUtil.StringValue( value );return; }
            if(name ==  "REPORT_KIND"){ this._reportKind = NumberUtil.Value<Int16>( value );return; }
            if(name ==  "REPORT_DETAIL"){ this._reportDetail = StringUtil.StringValue( value );return; }
            if(name ==  "REPORT_RECEIVE"){ this._reportReceive = StringUtil.StringValue( value );return; }
            if(name ==  "SEGMENT_EQUAL_FLAG"){ this._segmentEqualFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "STOCK_FLAG"){ this._stockFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "STOCK_COUNT"){ this._stockCount = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "CAPTURE_SEQ"){ this._captureSeq = StringUtil.StringValue( value );return; }
            if(name ==  "AG_COMPANY_CODE"){ this._agCompanyCode = StringUtil.StringValue( value );return; }
            if(name ==  "INSIDE_OPEN_LEVEL"){ this._insideOpenLevel = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "OUTSIDE_OPEN_LEVEL"){ this._outsideOpenLevel = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "LIMIT_OPEN_REMARKS"){ this._limitOpenRemarks = StringUtil.StringValue( value );return; }
            if(name ==  "PUBLISH_PAGE_FLAG"){ this._publishPageFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "ES_REMARKS"){ this._esRemarks = StringUtil.StringValue( value );return; }
            if(name ==  "MENU_FRAME_CODE"){ this._menuFrameCode = StringUtil.StringValue( value );return; }
            if(name ==  "FRAME_NAME_REFRECT_FLAG"){ this._frameNameRefrectFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "DELIVERY_OPTION_NAME"){ this._deliveryOptionName = StringUtil.StringValue( value );return; }
            if(name ==  "GET_REPORT_DESTINATION"){ this._getReportDestination = StringUtil.StringValue( value );return; }
            if(name ==  "REPORT_TREAT_KIND_SEQ"){ this._reportTreatKindSeq = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "USE_SITE_LIMIT_OPEN_FLAG"){ this._useSiteLimitOpenFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "USE_SITE_CARRIER_FLAG"){ this._useSiteCarrierFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "COST_MENU_FLAG"){ this._costMenuFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "CHECK_NAME"){ this._checkName = StringUtil.StringValue( value );return; }
            if(name ==  "PRICE_GROUP_FROM_DATE"){ this._priceGroupFromDate = StringUtil.StringValue( value );return; }
            if(name ==  "MANUSCRIPT_FROM_DATE"){ this._manuscriptFromDate = StringUtil.StringValue( value );return; }
            if(name ==  "PRICE_COST_FROM_DATE"){ this._priceCostFromDate = StringUtil.StringValue( value );return; }
            if(name ==  "TRANSMIT_FROM_DATE"){ this._transmitFromDate = StringUtil.StringValue( value );return; }
            if(name ==  "REFER_SITE_PRICE_COST_FLAG"){ this._referSitePriceCostFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "TEAM_CODE"){ this._teamCode = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "VALID_FLAG"){ this._validFlag = NumberUtil.Value<Int16?>( value );return; }
            if(name ==  "BASE_UPDATE_DATE_TIME"){ this._baseUpdateDateTime = DateUtil.DateValue( value );return; }
            if(name ==  "INSERT_DATE_TIME"){ this._insertDateTime = DateUtil.DateValue( value );return; }
            if(name ==  "INSERT_OPERATOR_CODE"){ this._insertOperatorCode = StringUtil.StringValue( value );return; }
            if(name ==  "UPDATE_DATE_TIME"){ this._updateDateTime = DateUtil.DateValue( value );return; }
            if(name ==  "OPERATOR_CODE"){ this._operatorCode = StringUtil.StringValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "SITE_CODE") return this._siteCode;
            if(name ==  "MENU_CODE") return this._menuCode;
            if(name ==  "SORT_SEQ") return this._sortSeq;
            if(name ==  "OPEN_DATE") return this._openDate;
            if(name ==  "CLOSE_DATE") return this._closeDate;
            if(name ==  "MENU_GROUP_CODE") return this._menuGroupCode;
            if(name ==  "NAME") return this._name;
            if(name ==  "ANK_NAME") return this._ankName;
            if(name ==  "DEVICE_CODE") return this._deviceCode;
            if(name ==  "MENU_DEVICE_CODE") return this._menuDeviceCode;
            if(name ==  "MENU_ADTYPE_CODE") return this._menuAdtypeCode;
            if(name ==  "OPTIN_TYPE") return this._optinType;
            if(name ==  "MANAGEMENT_CODE") return this._managementCode;
            if(name ==  "GUARANTEE_CODE") return this._guaranteeCode;
            if(name ==  "MENU_CATEGORY1") return this._menuCategory1;
            if(name ==  "MENU_CATEGORY2") return this._menuCategory2;
            if(name ==  "LIST_CODE") return this._listCode;
            if(name ==  "FLAME_COUNT") return this._flameCount;
            if(name ==  "FLAME_COUNT_KIND") return this._flameCountKind;
            if(name ==  "ROTATION_FLAME_COUNT") return this._rotationFlameCount;
            if(name ==  "FLAME_SELECT_FLAG") return this._flameSelectFlag;
            if(name ==  "GOODS_CATEGORY_CODE") return this._goodsCategoryCode;
            if(name ==  "PAYMENT_COMPANY") return this._paymentCompany;
            if(name ==  "SP_OPEN_FLAG") return this._spOpenFlag;
            if(name ==  "PM_OPEN_FLAG") return this._pmOpenFlag;
            if(name ==  "AD_GUIDE_OPEN_FLAG") return this._adGuideOpenFlag;
            if(name ==  "REGULATION_GUIDE_FLAG") return this._regulationGuideFlag;
            if(name ==  "IO_OPEN_FLAG") return this._ioOpenFlag;
            if(name ==  "ES_AUDIENCE_FLAG") return this._esAudienceFlag;
            if(name ==  "ES_PERFORMANCE_FLAG") return this._esPerformanceFlag;
            if(name ==  "ES_REACH_FLAG") return this._esReachFlag;
            if(name ==  "SEARCH_URL_FLAG") return this._searchUrlFlag;
            if(name ==  "PACKAGE_FLAG") return this._packageFlag;
            if(name ==  "MENU_SELECTION_COUNT") return this._menuSelectionCount;
            if(name ==  "CARRIER_CODE1") return this._carrierCode1;
            if(name ==  "CARRIER_CODE2") return this._carrierCode2;
            if(name ==  "CARRIER_CODE3") return this._carrierCode3;
            if(name ==  "CARRIER_CODE4") return this._carrierCode4;
            if(name ==  "PAGE_REMARKS") return this._pageRemarks;
            if(name ==  "REMARKS") return this._remarks;
            if(name ==  "DAC_REMARKS") return this._dacRemarks;
            if(name ==  "B_STATUS") return this._bStatus;
            if(name ==  "D_STATUS") return this._dStatus;
            if(name ==  "P_STATUS") return this._pStatus;
            if(name ==  "P_CAMPAIGN_STATUS_FROM") return this._pCampaignStatusFrom;
            if(name ==  "P_CAMPAIGN_STATUS_TO") return this._pCampaignStatusTo;
            if(name ==  "M_STATUS") return this._mStatus;
            if(name ==  "T_STATUS") return this._tStatus;
            if(name ==  "TOTAL_STATUS") return this._totalStatus;
            if(name ==  "TOTAL_STATUS_TO") return this._totalStatusTo;
            if(name ==  "COUNT_URL_KIND") return this._countUrlKind;
            if(name ==  "COUNT_URL") return this._countUrl;
            if(name ==  "REPORT_KIND") return this._reportKind;
            if(name ==  "REPORT_DETAIL") return this._reportDetail;
            if(name ==  "REPORT_RECEIVE") return this._reportReceive;
            if(name ==  "SEGMENT_EQUAL_FLAG") return this._segmentEqualFlag;
            if(name ==  "STOCK_FLAG") return this._stockFlag;
            if(name ==  "STOCK_COUNT") return this._stockCount;
            if(name ==  "CAPTURE_SEQ") return this._captureSeq;
            if(name ==  "AG_COMPANY_CODE") return this._agCompanyCode;
            if(name ==  "INSIDE_OPEN_LEVEL") return this._insideOpenLevel;
            if(name ==  "OUTSIDE_OPEN_LEVEL") return this._outsideOpenLevel;
            if(name ==  "LIMIT_OPEN_REMARKS") return this._limitOpenRemarks;
            if(name ==  "PUBLISH_PAGE_FLAG") return this._publishPageFlag;
            if(name ==  "ES_REMARKS") return this._esRemarks;
            if(name ==  "MENU_FRAME_CODE") return this._menuFrameCode;
            if(name ==  "FRAME_NAME_REFRECT_FLAG") return this._frameNameRefrectFlag;
            if(name ==  "DELIVERY_OPTION_NAME") return this._deliveryOptionName;
            if(name ==  "GET_REPORT_DESTINATION") return this._getReportDestination;
            if(name ==  "REPORT_TREAT_KIND_SEQ") return this._reportTreatKindSeq;
            if(name ==  "USE_SITE_LIMIT_OPEN_FLAG") return this._useSiteLimitOpenFlag;
            if(name ==  "USE_SITE_CARRIER_FLAG") return this._useSiteCarrierFlag;
            if(name ==  "COST_MENU_FLAG") return this._costMenuFlag;
            if(name ==  "CHECK_NAME") return this._checkName;
            if(name ==  "PRICE_GROUP_FROM_DATE") return this._priceGroupFromDate;
            if(name ==  "MANUSCRIPT_FROM_DATE") return this._manuscriptFromDate;
            if(name ==  "PRICE_COST_FROM_DATE") return this._priceCostFromDate;
            if(name ==  "TRANSMIT_FROM_DATE") return this._transmitFromDate;
            if(name ==  "REFER_SITE_PRICE_COST_FLAG") return this._referSitePriceCostFlag;
            if(name ==  "TEAM_CODE") return this._teamCode;
            if(name ==  "VALID_FLAG") return this._validFlag;
            if(name ==  "BASE_UPDATE_DATE_TIME") return this._baseUpdateDateTime;
            if(name ==  "INSERT_DATE_TIME") return this._insertDateTime;
            if(name ==  "INSERT_OPERATOR_CODE") return this._insertOperatorCode;
            if(name ==  "UPDATE_DATE_TIME") return this._updateDateTime;
            if(name ==  "OPERATOR_CODE") return this._operatorCode;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            MastMenuTableRow clone = new MastMenuTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(MastMenuTableRow source)
        {
            this.siteCode = source.siteCode;
            this.menuCode = source.menuCode;
            this.sortSeq = source.sortSeq;
            this.openDate = source.openDate;
            this.closeDate = source.closeDate;
            this.menuGroupCode = source.menuGroupCode;
            this.name = source.name;
            this.ankName = source.ankName;
            this.deviceCode = source.deviceCode;
            this.menuDeviceCode = source.menuDeviceCode;
            this.menuAdtypeCode = source.menuAdtypeCode;
            this.optinType = source.optinType;
            this.managementCode = source.managementCode;
            this.guaranteeCode = source.guaranteeCode;
            this.menuCategory1 = source.menuCategory1;
            this.menuCategory2 = source.menuCategory2;
            this.listCode = source.listCode;
            this.flameCount = source.flameCount;
            this.flameCountKind = source.flameCountKind;
            this.rotationFlameCount = source.rotationFlameCount;
            this.flameSelectFlag = source.flameSelectFlag;
            this.goodsCategoryCode = source.goodsCategoryCode;
            this.paymentCompany = source.paymentCompany;
            this.spOpenFlag = source.spOpenFlag;
            this.pmOpenFlag = source.pmOpenFlag;
            this.adGuideOpenFlag = source.adGuideOpenFlag;
            this.regulationGuideFlag = source.regulationGuideFlag;
            this.ioOpenFlag = source.ioOpenFlag;
            this.esAudienceFlag = source.esAudienceFlag;
            this.esPerformanceFlag = source.esPerformanceFlag;
            this.esReachFlag = source.esReachFlag;
            this.searchUrlFlag = source.searchUrlFlag;
            this.packageFlag = source.packageFlag;
            this.menuSelectionCount = source.menuSelectionCount;
            this.carrierCode1 = source.carrierCode1;
            this.carrierCode2 = source.carrierCode2;
            this.carrierCode3 = source.carrierCode3;
            this.carrierCode4 = source.carrierCode4;
            this.pageRemarks = source.pageRemarks;
            this.remarks = source.remarks;
            this.dacRemarks = source.dacRemarks;
            this.bStatus = source.bStatus;
            this.dStatus = source.dStatus;
            this.pStatus = source.pStatus;
            this.pCampaignStatusFrom = source.pCampaignStatusFrom;
            this.pCampaignStatusTo = source.pCampaignStatusTo;
            this.mStatus = source.mStatus;
            this.tStatus = source.tStatus;
            this.totalStatus = source.totalStatus;
            this.totalStatusTo = source.totalStatusTo;
            this.countUrlKind = source.countUrlKind;
            this.countUrl = source.countUrl;
            this.reportKind = source.reportKind;
            this.reportDetail = source.reportDetail;
            this.reportReceive = source.reportReceive;
            this.segmentEqualFlag = source.segmentEqualFlag;
            this.stockFlag = source.stockFlag;
            this.stockCount = source.stockCount;
            this.captureSeq = source.captureSeq;
            this.agCompanyCode = source.agCompanyCode;
            this.insideOpenLevel = source.insideOpenLevel;
            this.outsideOpenLevel = source.outsideOpenLevel;
            this.limitOpenRemarks = source.limitOpenRemarks;
            this.publishPageFlag = source.publishPageFlag;
            this.esRemarks = source.esRemarks;
            this.menuFrameCode = source.menuFrameCode;
            this.frameNameRefrectFlag = source.frameNameRefrectFlag;
            this.deliveryOptionName = source.deliveryOptionName;
            this.getReportDestination = source.getReportDestination;
            this.reportTreatKindSeq = source.reportTreatKindSeq;
            this.useSiteLimitOpenFlag = source.useSiteLimitOpenFlag;
            this.useSiteCarrierFlag = source.useSiteCarrierFlag;
            this.costMenuFlag = source.costMenuFlag;
            this.checkName = source.checkName;
            this.priceGroupFromDate = source.priceGroupFromDate;
            this.manuscriptFromDate = source.manuscriptFromDate;
            this.priceCostFromDate = source.priceCostFromDate;
            this.transmitFromDate = source.transmitFromDate;
            this.referSitePriceCostFlag = source.referSitePriceCostFlag;
            this.teamCode = source.teamCode;
            this.validFlag = source.validFlag;
            this.baseUpdateDateTime = source.baseUpdateDateTime;
            this.insertDateTime = source.insertDateTime;
            this.insertOperatorCode = source.insertOperatorCode;
            this.updateDateTime = source.updateDateTime;
            this.operatorCode = source.operatorCode;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("SITE_CODE")){ this._siteCode = StringUtil.StringValue(row["SITE_CODE"]); }
            if (cols.Contains("MENU_CODE")){ this._menuCode = StringUtil.StringValue(row["MENU_CODE"]); }
            if (cols.Contains("SORT_SEQ")){ this._sortSeq = NumberUtil.Value<Int16?>(row["SORT_SEQ"]); }
            if (cols.Contains("OPEN_DATE")){ this._openDate = StringUtil.StringValue(row["OPEN_DATE"]); }
            if (cols.Contains("CLOSE_DATE")){ this._closeDate = StringUtil.StringValue(row["CLOSE_DATE"]); }
            if (cols.Contains("MENU_GROUP_CODE")){ this._menuGroupCode = NumberUtil.Value<Int16?>(row["MENU_GROUP_CODE"]); }
            if (cols.Contains("NAME")){ this._name = StringUtil.StringValue(row["NAME"]); }
            if (cols.Contains("ANK_NAME")){ this._ankName = StringUtil.StringValue(row["ANK_NAME"]); }
            if (cols.Contains("DEVICE_CODE")){ this._deviceCode = NumberUtil.Value<Int16>(row["DEVICE_CODE"]); }
            if (cols.Contains("MENU_DEVICE_CODE")){ this._menuDeviceCode = NumberUtil.Value<Int16?>(row["MENU_DEVICE_CODE"]); }
            if (cols.Contains("MENU_ADTYPE_CODE")){ this._menuAdtypeCode = NumberUtil.Value<Int16?>(row["MENU_ADTYPE_CODE"]); }
            if (cols.Contains("OPTIN_TYPE")){ this._optinType = NumberUtil.Value<Int16?>(row["OPTIN_TYPE"]); }
            if (cols.Contains("MANAGEMENT_CODE")){ this._managementCode = NumberUtil.Value<Int16>(row["MANAGEMENT_CODE"]); }
            if (cols.Contains("GUARANTEE_CODE")){ this._guaranteeCode = NumberUtil.Value<Int16>(row["GUARANTEE_CODE"]); }
            if (cols.Contains("MENU_CATEGORY1")){ this._menuCategory1 = NumberUtil.Value<Int16?>(row["MENU_CATEGORY1"]); }
            if (cols.Contains("MENU_CATEGORY2")){ this._menuCategory2 = NumberUtil.Value<Int16?>(row["MENU_CATEGORY2"]); }
            if (cols.Contains("LIST_CODE")){ this._listCode = NumberUtil.Value<Int16?>(row["LIST_CODE"]); }
            if (cols.Contains("FLAME_COUNT")){ this._flameCount = NumberUtil.Value<Int16?>(row["FLAME_COUNT"]); }
            if (cols.Contains("FLAME_COUNT_KIND")){ this._flameCountKind = NumberUtil.Value<Int16>(row["FLAME_COUNT_KIND"]); }
            if (cols.Contains("ROTATION_FLAME_COUNT")){ this._rotationFlameCount = NumberUtil.Value<Int16?>(row["ROTATION_FLAME_COUNT"]); }
            if (cols.Contains("FLAME_SELECT_FLAG")){ this._flameSelectFlag = NumberUtil.Value<Int16?>(row["FLAME_SELECT_FLAG"]); }
            if (cols.Contains("GOODS_CATEGORY_CODE")){ this._goodsCategoryCode = NumberUtil.Value<Int16?>(row["GOODS_CATEGORY_CODE"]); }
            if (cols.Contains("PAYMENT_COMPANY")){ this._paymentCompany = StringUtil.StringValue(row["PAYMENT_COMPANY"]); }
            if (cols.Contains("SP_OPEN_FLAG")){ this._spOpenFlag = NumberUtil.Value<Int16?>(row["SP_OPEN_FLAG"]); }
            if (cols.Contains("PM_OPEN_FLAG")){ this._pmOpenFlag = NumberUtil.Value<Int16?>(row["PM_OPEN_FLAG"]); }
            if (cols.Contains("AD_GUIDE_OPEN_FLAG")){ this._adGuideOpenFlag = NumberUtil.Value<Int16?>(row["AD_GUIDE_OPEN_FLAG"]); }
            if (cols.Contains("REGULATION_GUIDE_FLAG")){ this._regulationGuideFlag = NumberUtil.Value<Int16?>(row["REGULATION_GUIDE_FLAG"]); }
            if (cols.Contains("IO_OPEN_FLAG")){ this._ioOpenFlag = NumberUtil.Value<Int16?>(row["IO_OPEN_FLAG"]); }
            if (cols.Contains("ES_AUDIENCE_FLAG")){ this._esAudienceFlag = NumberUtil.Value<Int16?>(row["ES_AUDIENCE_FLAG"]); }
            if (cols.Contains("ES_PERFORMANCE_FLAG")){ this._esPerformanceFlag = NumberUtil.Value<Int16?>(row["ES_PERFORMANCE_FLAG"]); }
            if (cols.Contains("ES_REACH_FLAG")){ this._esReachFlag = NumberUtil.Value<Int16?>(row["ES_REACH_FLAG"]); }
            if (cols.Contains("SEARCH_URL_FLAG")){ this._searchUrlFlag = NumberUtil.Value<Int16?>(row["SEARCH_URL_FLAG"]); }
            if (cols.Contains("PACKAGE_FLAG")){ this._packageFlag = NumberUtil.Value<Int16?>(row["PACKAGE_FLAG"]); }
            if (cols.Contains("MENU_SELECTION_COUNT")){ this._menuSelectionCount = NumberUtil.Value<Int16?>(row["MENU_SELECTION_COUNT"]); }
            if (cols.Contains("CARRIER_CODE1")){ this._carrierCode1 = NumberUtil.Value<Int16?>(row["CARRIER_CODE1"]); }
            if (cols.Contains("CARRIER_CODE2")){ this._carrierCode2 = NumberUtil.Value<Int16?>(row["CARRIER_CODE2"]); }
            if (cols.Contains("CARRIER_CODE3")){ this._carrierCode3 = NumberUtil.Value<Int16?>(row["CARRIER_CODE3"]); }
            if (cols.Contains("CARRIER_CODE4")){ this._carrierCode4 = NumberUtil.Value<Int16?>(row["CARRIER_CODE4"]); }
            if (cols.Contains("PAGE_REMARKS")){ this._pageRemarks = StringUtil.StringValue(row["PAGE_REMARKS"]); }
            if (cols.Contains("REMARKS")){ this._remarks = StringUtil.StringValue(row["REMARKS"]); }
            if (cols.Contains("DAC_REMARKS")){ this._dacRemarks = StringUtil.StringValue(row["DAC_REMARKS"]); }
            if (cols.Contains("B_STATUS")){ this._bStatus = StringUtil.StringValue(row["B_STATUS"]); }
            if (cols.Contains("D_STATUS")){ this._dStatus = StringUtil.StringValue(row["D_STATUS"]); }
            if (cols.Contains("P_STATUS")){ this._pStatus = StringUtil.StringValue(row["P_STATUS"]); }
            if (cols.Contains("P_CAMPAIGN_STATUS_FROM")){ this._pCampaignStatusFrom = StringUtil.StringValue(row["P_CAMPAIGN_STATUS_FROM"]); }
            if (cols.Contains("P_CAMPAIGN_STATUS_TO")){ this._pCampaignStatusTo = StringUtil.StringValue(row["P_CAMPAIGN_STATUS_TO"]); }
            if (cols.Contains("M_STATUS")){ this._mStatus = StringUtil.StringValue(row["M_STATUS"]); }
            if (cols.Contains("T_STATUS")){ this._tStatus = StringUtil.StringValue(row["T_STATUS"]); }
            if (cols.Contains("TOTAL_STATUS")){ this._totalStatus = StringUtil.StringValue(row["TOTAL_STATUS"]); }
            if (cols.Contains("TOTAL_STATUS_TO")){ this._totalStatusTo = StringUtil.StringValue(row["TOTAL_STATUS_TO"]); }
            if (cols.Contains("COUNT_URL_KIND")){ this._countUrlKind = NumberUtil.Value<Int16?>(row["COUNT_URL_KIND"]); }
            if (cols.Contains("COUNT_URL")){ this._countUrl = StringUtil.StringValue(row["COUNT_URL"]); }
            if (cols.Contains("REPORT_KIND")){ this._reportKind = NumberUtil.Value<Int16>(row["REPORT_KIND"]); }
            if (cols.Contains("REPORT_DETAIL")){ this._reportDetail = StringUtil.StringValue(row["REPORT_DETAIL"]); }
            if (cols.Contains("REPORT_RECEIVE")){ this._reportReceive = StringUtil.StringValue(row["REPORT_RECEIVE"]); }
            if (cols.Contains("SEGMENT_EQUAL_FLAG")){ this._segmentEqualFlag = NumberUtil.Value<Int16?>(row["SEGMENT_EQUAL_FLAG"]); }
            if (cols.Contains("STOCK_FLAG")){ this._stockFlag = NumberUtil.Value<Int16?>(row["STOCK_FLAG"]); }
            if (cols.Contains("STOCK_COUNT")){ this._stockCount = NumberUtil.Value<Int16?>(row["STOCK_COUNT"]); }
            if (cols.Contains("CAPTURE_SEQ")){ this._captureSeq = StringUtil.StringValue(row["CAPTURE_SEQ"]); }
            if (cols.Contains("AG_COMPANY_CODE")){ this._agCompanyCode = StringUtil.StringValue(row["AG_COMPANY_CODE"]); }
            if (cols.Contains("INSIDE_OPEN_LEVEL")){ this._insideOpenLevel = NumberUtil.Value<Int16?>(row["INSIDE_OPEN_LEVEL"]); }
            if (cols.Contains("OUTSIDE_OPEN_LEVEL")){ this._outsideOpenLevel = NumberUtil.Value<Int16?>(row["OUTSIDE_OPEN_LEVEL"]); }
            if (cols.Contains("LIMIT_OPEN_REMARKS")){ this._limitOpenRemarks = StringUtil.StringValue(row["LIMIT_OPEN_REMARKS"]); }
            if (cols.Contains("PUBLISH_PAGE_FLAG")){ this._publishPageFlag = NumberUtil.Value<Int16?>(row["PUBLISH_PAGE_FLAG"]); }
            if (cols.Contains("ES_REMARKS")){ this._esRemarks = StringUtil.StringValue(row["ES_REMARKS"]); }
            if (cols.Contains("MENU_FRAME_CODE")){ this._menuFrameCode = StringUtil.StringValue(row["MENU_FRAME_CODE"]); }
            if (cols.Contains("FRAME_NAME_REFRECT_FLAG")){ this._frameNameRefrectFlag = NumberUtil.Value<Int16?>(row["FRAME_NAME_REFRECT_FLAG"]); }
            if (cols.Contains("DELIVERY_OPTION_NAME")){ this._deliveryOptionName = StringUtil.StringValue(row["DELIVERY_OPTION_NAME"]); }
            if (cols.Contains("GET_REPORT_DESTINATION")){ this._getReportDestination = StringUtil.StringValue(row["GET_REPORT_DESTINATION"]); }
            if (cols.Contains("REPORT_TREAT_KIND_SEQ")){ this._reportTreatKindSeq = NumberUtil.Value<Int16?>(row["REPORT_TREAT_KIND_SEQ"]); }
            if (cols.Contains("USE_SITE_LIMIT_OPEN_FLAG")){ this._useSiteLimitOpenFlag = NumberUtil.Value<Int16?>(row["USE_SITE_LIMIT_OPEN_FLAG"]); }
            if (cols.Contains("USE_SITE_CARRIER_FLAG")){ this._useSiteCarrierFlag = NumberUtil.Value<Int16?>(row["USE_SITE_CARRIER_FLAG"]); }
            if (cols.Contains("COST_MENU_FLAG")){ this._costMenuFlag = NumberUtil.Value<Int16?>(row["COST_MENU_FLAG"]); }
            if (cols.Contains("CHECK_NAME")){ this._checkName = StringUtil.StringValue(row["CHECK_NAME"]); }
            if (cols.Contains("PRICE_GROUP_FROM_DATE")){ this._priceGroupFromDate = StringUtil.StringValue(row["PRICE_GROUP_FROM_DATE"]); }
            if (cols.Contains("MANUSCRIPT_FROM_DATE")){ this._manuscriptFromDate = StringUtil.StringValue(row["MANUSCRIPT_FROM_DATE"]); }
            if (cols.Contains("PRICE_COST_FROM_DATE")){ this._priceCostFromDate = StringUtil.StringValue(row["PRICE_COST_FROM_DATE"]); }
            if (cols.Contains("TRANSMIT_FROM_DATE")){ this._transmitFromDate = StringUtil.StringValue(row["TRANSMIT_FROM_DATE"]); }
            if (cols.Contains("REFER_SITE_PRICE_COST_FLAG")){ this._referSitePriceCostFlag = NumberUtil.Value<Int16?>(row["REFER_SITE_PRICE_COST_FLAG"]); }
            if (cols.Contains("TEAM_CODE")){ this._teamCode = NumberUtil.Value<Int16?>(row["TEAM_CODE"]); }
            if (cols.Contains("VALID_FLAG")){ this._validFlag = NumberUtil.Value<Int16?>(row["VALID_FLAG"]); }
            if (cols.Contains("BASE_UPDATE_DATE_TIME")){ this._baseUpdateDateTime = DateUtil.DateValue(row["BASE_UPDATE_DATE_TIME"]); }
            if (cols.Contains("INSERT_DATE_TIME")){ this._insertDateTime = DateUtil.DateValue(row["INSERT_DATE_TIME"]); }
            if (cols.Contains("INSERT_OPERATOR_CODE")){ this._insertOperatorCode = StringUtil.StringValue(row["INSERT_OPERATOR_CODE"]); }
            if (cols.Contains("UPDATE_DATE_TIME")){ this._updateDateTime = DateUtil.DateValue(row["UPDATE_DATE_TIME"]); }
            if (cols.Contains("OPERATOR_CODE")){ this._operatorCode = StringUtil.StringValue(row["OPERATOR_CODE"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "SITE_CODE");if (cols.Contains(columnName)){ this._siteCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MENU_CODE");if (cols.Contains(columnName)){ this._menuCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "SORT_SEQ");if (cols.Contains(columnName)){ this._sortSeq = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "OPEN_DATE");if (cols.Contains(columnName)){ this._openDate = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CLOSE_DATE");if (cols.Contains(columnName)){ this._closeDate = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MENU_GROUP_CODE");if (cols.Contains(columnName)){ this._menuGroupCode = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "NAME");if (cols.Contains(columnName)){ this._name = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "ANK_NAME");if (cols.Contains(columnName)){ this._ankName = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DEVICE_CODE");if (cols.Contains(columnName)){ this._deviceCode = NumberUtil.Value<Int16>(row[columnName]); }
            columnName = BuildColumnName(alias, "MENU_DEVICE_CODE");if (cols.Contains(columnName)){ this._menuDeviceCode = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "MENU_ADTYPE_CODE");if (cols.Contains(columnName)){ this._menuAdtypeCode = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "OPTIN_TYPE");if (cols.Contains(columnName)){ this._optinType = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "MANAGEMENT_CODE");if (cols.Contains(columnName)){ this._managementCode = NumberUtil.Value<Int16>(row[columnName]); }
            columnName = BuildColumnName(alias, "GUARANTEE_CODE");if (cols.Contains(columnName)){ this._guaranteeCode = NumberUtil.Value<Int16>(row[columnName]); }
            columnName = BuildColumnName(alias, "MENU_CATEGORY1");if (cols.Contains(columnName)){ this._menuCategory1 = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "MENU_CATEGORY2");if (cols.Contains(columnName)){ this._menuCategory2 = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "LIST_CODE");if (cols.Contains(columnName)){ this._listCode = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "FLAME_COUNT");if (cols.Contains(columnName)){ this._flameCount = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "FLAME_COUNT_KIND");if (cols.Contains(columnName)){ this._flameCountKind = NumberUtil.Value<Int16>(row[columnName]); }
            columnName = BuildColumnName(alias, "ROTATION_FLAME_COUNT");if (cols.Contains(columnName)){ this._rotationFlameCount = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "FLAME_SELECT_FLAG");if (cols.Contains(columnName)){ this._flameSelectFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "GOODS_CATEGORY_CODE");if (cols.Contains(columnName)){ this._goodsCategoryCode = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "PAYMENT_COMPANY");if (cols.Contains(columnName)){ this._paymentCompany = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "SP_OPEN_FLAG");if (cols.Contains(columnName)){ this._spOpenFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "PM_OPEN_FLAG");if (cols.Contains(columnName)){ this._pmOpenFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "AD_GUIDE_OPEN_FLAG");if (cols.Contains(columnName)){ this._adGuideOpenFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "REGULATION_GUIDE_FLAG");if (cols.Contains(columnName)){ this._regulationGuideFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "IO_OPEN_FLAG");if (cols.Contains(columnName)){ this._ioOpenFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "ES_AUDIENCE_FLAG");if (cols.Contains(columnName)){ this._esAudienceFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "ES_PERFORMANCE_FLAG");if (cols.Contains(columnName)){ this._esPerformanceFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "ES_REACH_FLAG");if (cols.Contains(columnName)){ this._esReachFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "SEARCH_URL_FLAG");if (cols.Contains(columnName)){ this._searchUrlFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "PACKAGE_FLAG");if (cols.Contains(columnName)){ this._packageFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "MENU_SELECTION_COUNT");if (cols.Contains(columnName)){ this._menuSelectionCount = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "CARRIER_CODE1");if (cols.Contains(columnName)){ this._carrierCode1 = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "CARRIER_CODE2");if (cols.Contains(columnName)){ this._carrierCode2 = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "CARRIER_CODE3");if (cols.Contains(columnName)){ this._carrierCode3 = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "CARRIER_CODE4");if (cols.Contains(columnName)){ this._carrierCode4 = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "PAGE_REMARKS");if (cols.Contains(columnName)){ this._pageRemarks = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "REMARKS");if (cols.Contains(columnName)){ this._remarks = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DAC_REMARKS");if (cols.Contains(columnName)){ this._dacRemarks = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "B_STATUS");if (cols.Contains(columnName)){ this._bStatus = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "D_STATUS");if (cols.Contains(columnName)){ this._dStatus = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "P_STATUS");if (cols.Contains(columnName)){ this._pStatus = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "P_CAMPAIGN_STATUS_FROM");if (cols.Contains(columnName)){ this._pCampaignStatusFrom = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "P_CAMPAIGN_STATUS_TO");if (cols.Contains(columnName)){ this._pCampaignStatusTo = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "M_STATUS");if (cols.Contains(columnName)){ this._mStatus = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "T_STATUS");if (cols.Contains(columnName)){ this._tStatus = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "TOTAL_STATUS");if (cols.Contains(columnName)){ this._totalStatus = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "TOTAL_STATUS_TO");if (cols.Contains(columnName)){ this._totalStatusTo = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "COUNT_URL_KIND");if (cols.Contains(columnName)){ this._countUrlKind = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "COUNT_URL");if (cols.Contains(columnName)){ this._countUrl = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "REPORT_KIND");if (cols.Contains(columnName)){ this._reportKind = NumberUtil.Value<Int16>(row[columnName]); }
            columnName = BuildColumnName(alias, "REPORT_DETAIL");if (cols.Contains(columnName)){ this._reportDetail = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "REPORT_RECEIVE");if (cols.Contains(columnName)){ this._reportReceive = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "SEGMENT_EQUAL_FLAG");if (cols.Contains(columnName)){ this._segmentEqualFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "STOCK_FLAG");if (cols.Contains(columnName)){ this._stockFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "STOCK_COUNT");if (cols.Contains(columnName)){ this._stockCount = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "CAPTURE_SEQ");if (cols.Contains(columnName)){ this._captureSeq = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "AG_COMPANY_CODE");if (cols.Contains(columnName)){ this._agCompanyCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "INSIDE_OPEN_LEVEL");if (cols.Contains(columnName)){ this._insideOpenLevel = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "OUTSIDE_OPEN_LEVEL");if (cols.Contains(columnName)){ this._outsideOpenLevel = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "LIMIT_OPEN_REMARKS");if (cols.Contains(columnName)){ this._limitOpenRemarks = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "PUBLISH_PAGE_FLAG");if (cols.Contains(columnName)){ this._publishPageFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "ES_REMARKS");if (cols.Contains(columnName)){ this._esRemarks = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MENU_FRAME_CODE");if (cols.Contains(columnName)){ this._menuFrameCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "FRAME_NAME_REFRECT_FLAG");if (cols.Contains(columnName)){ this._frameNameRefrectFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "DELIVERY_OPTION_NAME");if (cols.Contains(columnName)){ this._deliveryOptionName = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "GET_REPORT_DESTINATION");if (cols.Contains(columnName)){ this._getReportDestination = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "REPORT_TREAT_KIND_SEQ");if (cols.Contains(columnName)){ this._reportTreatKindSeq = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "USE_SITE_LIMIT_OPEN_FLAG");if (cols.Contains(columnName)){ this._useSiteLimitOpenFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "USE_SITE_CARRIER_FLAG");if (cols.Contains(columnName)){ this._useSiteCarrierFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "COST_MENU_FLAG");if (cols.Contains(columnName)){ this._costMenuFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "CHECK_NAME");if (cols.Contains(columnName)){ this._checkName = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "PRICE_GROUP_FROM_DATE");if (cols.Contains(columnName)){ this._priceGroupFromDate = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MANUSCRIPT_FROM_DATE");if (cols.Contains(columnName)){ this._manuscriptFromDate = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "PRICE_COST_FROM_DATE");if (cols.Contains(columnName)){ this._priceCostFromDate = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "TRANSMIT_FROM_DATE");if (cols.Contains(columnName)){ this._transmitFromDate = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "REFER_SITE_PRICE_COST_FLAG");if (cols.Contains(columnName)){ this._referSitePriceCostFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "TEAM_CODE");if (cols.Contains(columnName)){ this._teamCode = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "VALID_FLAG");if (cols.Contains(columnName)){ this._validFlag = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "BASE_UPDATE_DATE_TIME");if (cols.Contains(columnName)){ this._baseUpdateDateTime = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "INSERT_DATE_TIME");if (cols.Contains(columnName)){ this._insertDateTime = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "INSERT_OPERATOR_CODE");if (cols.Contains(columnName)){ this._insertOperatorCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "UPDATE_DATE_TIME");if (cols.Contains(columnName)){ this._updateDateTime = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "OPERATOR_CODE");if (cols.Contains(columnName)){ this._operatorCode = StringUtil.StringValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._siteCode = StringUtil.StringValue(reader[0]);
            this._menuCode = StringUtil.StringValue(reader[1]);
            this._sortSeq = NumberUtil.Value<Int16?>(reader[2]);
            this._openDate = StringUtil.StringValue(reader[3]);
            this._closeDate = StringUtil.StringValue(reader[4]);
            this._menuGroupCode = NumberUtil.Value<Int16?>(reader[5]);
            this._name = StringUtil.StringValue(reader[6]);
            this._ankName = StringUtil.StringValue(reader[7]);
            this._deviceCode = NumberUtil.Value<Int16>(reader[8]);
            this._menuDeviceCode = NumberUtil.Value<Int16?>(reader[9]);
            this._menuAdtypeCode = NumberUtil.Value<Int16?>(reader[10]);
            this._optinType = NumberUtil.Value<Int16?>(reader[11]);
            this._managementCode = NumberUtil.Value<Int16>(reader[12]);
            this._guaranteeCode = NumberUtil.Value<Int16>(reader[13]);
            this._menuCategory1 = NumberUtil.Value<Int16?>(reader[14]);
            this._menuCategory2 = NumberUtil.Value<Int16?>(reader[15]);
            this._listCode = NumberUtil.Value<Int16?>(reader[16]);
            this._flameCount = NumberUtil.Value<Int16?>(reader[17]);
            this._flameCountKind = NumberUtil.Value<Int16>(reader[18]);
            this._rotationFlameCount = NumberUtil.Value<Int16?>(reader[19]);
            this._flameSelectFlag = NumberUtil.Value<Int16?>(reader[20]);
            this._goodsCategoryCode = NumberUtil.Value<Int16?>(reader[21]);
            this._paymentCompany = StringUtil.StringValue(reader[22]);
            this._spOpenFlag = NumberUtil.Value<Int16?>(reader[23]);
            this._pmOpenFlag = NumberUtil.Value<Int16?>(reader[24]);
            this._adGuideOpenFlag = NumberUtil.Value<Int16?>(reader[25]);
            this._regulationGuideFlag = NumberUtil.Value<Int16?>(reader[26]);
            this._ioOpenFlag = NumberUtil.Value<Int16?>(reader[27]);
            this._esAudienceFlag = NumberUtil.Value<Int16?>(reader[28]);
            this._esPerformanceFlag = NumberUtil.Value<Int16?>(reader[29]);
            this._esReachFlag = NumberUtil.Value<Int16?>(reader[30]);
            this._searchUrlFlag = NumberUtil.Value<Int16?>(reader[31]);
            this._packageFlag = NumberUtil.Value<Int16?>(reader[32]);
            this._menuSelectionCount = NumberUtil.Value<Int16?>(reader[33]);
            this._carrierCode1 = NumberUtil.Value<Int16?>(reader[34]);
            this._carrierCode2 = NumberUtil.Value<Int16?>(reader[35]);
            this._carrierCode3 = NumberUtil.Value<Int16?>(reader[36]);
            this._carrierCode4 = NumberUtil.Value<Int16?>(reader[37]);
            this._pageRemarks = StringUtil.StringValue(reader[38]);
            this._remarks = StringUtil.StringValue(reader[39]);
            this._dacRemarks = StringUtil.StringValue(reader[40]);
            this._bStatus = StringUtil.StringValue(reader[41]);
            this._dStatus = StringUtil.StringValue(reader[42]);
            this._pStatus = StringUtil.StringValue(reader[43]);
            this._pCampaignStatusFrom = StringUtil.StringValue(reader[44]);
            this._pCampaignStatusTo = StringUtil.StringValue(reader[45]);
            this._mStatus = StringUtil.StringValue(reader[46]);
            this._tStatus = StringUtil.StringValue(reader[47]);
            this._totalStatus = StringUtil.StringValue(reader[48]);
            this._totalStatusTo = StringUtil.StringValue(reader[49]);
            this._countUrlKind = NumberUtil.Value<Int16?>(reader[50]);
            this._countUrl = StringUtil.StringValue(reader[51]);
            this._reportKind = NumberUtil.Value<Int16>(reader[52]);
            this._reportDetail = StringUtil.StringValue(reader[53]);
            this._reportReceive = StringUtil.StringValue(reader[54]);
            this._segmentEqualFlag = NumberUtil.Value<Int16?>(reader[55]);
            this._stockFlag = NumberUtil.Value<Int16?>(reader[56]);
            this._stockCount = NumberUtil.Value<Int16?>(reader[57]);
            this._captureSeq = StringUtil.StringValue(reader[58]);
            this._agCompanyCode = StringUtil.StringValue(reader[59]);
            this._insideOpenLevel = NumberUtil.Value<Int16?>(reader[60]);
            this._outsideOpenLevel = NumberUtil.Value<Int16?>(reader[61]);
            this._limitOpenRemarks = StringUtil.StringValue(reader[62]);
            this._publishPageFlag = NumberUtil.Value<Int16?>(reader[63]);
            this._esRemarks = StringUtil.StringValue(reader[64]);
            this._menuFrameCode = StringUtil.StringValue(reader[65]);
            this._frameNameRefrectFlag = NumberUtil.Value<Int16?>(reader[66]);
            this._deliveryOptionName = StringUtil.StringValue(reader[67]);
            this._getReportDestination = StringUtil.StringValue(reader[68]);
            this._reportTreatKindSeq = NumberUtil.Value<Int16?>(reader[69]);
            this._useSiteLimitOpenFlag = NumberUtil.Value<Int16?>(reader[70]);
            this._useSiteCarrierFlag = NumberUtil.Value<Int16?>(reader[71]);
            this._costMenuFlag = NumberUtil.Value<Int16?>(reader[72]);
            this._checkName = StringUtil.StringValue(reader[73]);
            this._priceGroupFromDate = StringUtil.StringValue(reader[74]);
            this._manuscriptFromDate = StringUtil.StringValue(reader[75]);
            this._priceCostFromDate = StringUtil.StringValue(reader[76]);
            this._transmitFromDate = StringUtil.StringValue(reader[77]);
            this._referSitePriceCostFlag = NumberUtil.Value<Int16?>(reader[78]);
            this._teamCode = NumberUtil.Value<Int16?>(reader[79]);
            this._validFlag = NumberUtil.Value<Int16?>(reader[80]);
            this._baseUpdateDateTime = DateUtil.DateValue(reader[81]);
            this._insertDateTime = DateUtil.DateValue(reader[82]);
            this._insertOperatorCode = StringUtil.StringValue(reader[83]);
            this._updateDateTime = DateUtil.DateValue(reader[84]);
            this._operatorCode = StringUtil.StringValue(reader[85]);
            
            this.IsNew = false;
        }
    }

}