using System;
using System.Collections.Generic;
using System.Text;
using OFW.FieldProperties;
using OFW.Util;

namespace OFW.Validators
{
    /// <summary>
    /// LongtB[hpValidator
    /// </summary>
    public class LongFieldValidator : FieldValidator
    {
        /// <summary>
        /// ftHg\z
        /// </summary>
        public LongFieldValidator() : base()
        {

        }
        /// <summary>
        /// vpeBw
        /// </summary>
        public LongFieldValidator(FieldProperty p)
            : base(p)
        {

        }
        /// <summary>
        /// ^Cv`FbÑI[o[Ch
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public override bool ValidateType(object aValue)
        {
            this.ErrorMessage = "";
            try
            {
                if (aValue is long)
                {
                    return true;
                }
                else
                {
                    this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                    return false;
                }
            }
            catch
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }

        }
        /// <summary>
        /// ͈̓`FbNI[o[Ch
        /// </summary>
        /// <param name="value">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public override bool ValidateRange(object value)
        {
            this.ErrorMessage = "";
            try
            {
                LongFieldProperty prop = (LongFieldProperty)this.mProperty;

                long checkVale = Int64.Parse(value.ToString());
                if (prop.MinValue <= checkVale && checkVale <= prop.MaxValue)
                {
                    return true;
                }

                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_RANGE"), prop.DisplayName, prop.MinValue, prop.MaxValue);
                return false;
            }
            catch
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }
        }
    }
}
