using System;
using System.Collections.Generic;
using System.Text;
using OFW.FieldProperties;
using OFW.Util;

namespace OFW.Validators
{
    /// <summary>
    /// ttB[hpValidator
    /// </summary>
    public class DateFieldValidator : FieldValidator
    {
        /// <summary>
        /// ftHg
        /// </summary>
        public DateFieldValidator() : base()
        {
            this.mProperty = new DateFieldProperty();
        }
        /// <summary>
        /// vpeBw
        /// </summary>
        /// <param name="p"></param>
        public DateFieldValidator(FieldProperty p) : base(p)
        {
        }
        /// <summary>
        /// ^Cv`FbÑI[o[Ch
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public override bool ValidateType(object aValue)
        {

            this.ErrorMessage = "";
            try
            {
                if (aValue is DateTime)
                {
                    return true;
                }
                else
                {
                    this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                    return false;
                }
            }
            catch
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }

        }
        /// <summary>
        /// tH[}bg`FbÑI[o[Ch
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public override bool ValidateFormat(object aValue)
        {
            this.ErrorMessage = "";
            try
            {

                DateFieldProperty p = (DateFieldProperty)this.mProperty;
                // 2001/01/01 12:25 -> format(yyyy/MM/dd) = 2001/01/01
                // 2001/01/01 -> parse = 2001/01/01 0:00
                //  tH[}bgႤB
                DateTime input = (DateTime)aValue;
                string checkVale = input.ToString(p.Format);
                DateTime dt = DateTime.Parse(checkVale);
                if (dt.CompareTo(input) == 0)
                {
                    return true;
                }
                else
                {
                    this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                    return false;
                }
            }
            catch
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }
        }
        /// <summary>
        /// ͈̓`FbN
        /// </summary>
        /// <param name="aValue">Ώ</param>
        /// <returns>łȂƂfalse,Ȃtrue</returns>
        public override bool ValidateRange(object aValue)
        {
            this.ErrorMessage = "";
            if (aValue == null)
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }
            if (!(aValue is DateTime))
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }
            DateTime target = (DateTime)aValue;
            DateFieldProperty prop = (DateFieldProperty)this.mProperty;


            if (!DateUtil.IsInRange(target, prop.MinValue, prop.MaxValue))
            {
                //Ƃ肠At𒷂`ŕ\
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_RANGE"), prop.DisplayName, DateUtil.FormatLongDate(prop.MinValue), DateUtil.FormatLongDate(prop.MaxValue));
                return false;
            }

            return true;
        }
    }
}
