using System;
using System.Data;
using System.Text;
using Microsoft.VisualBasic;

namespace OFW.Util
{
    /// <summary>
    /// StringChecker ̊Tv̐łB
    /// </summary>
    public class StringChecker
    {
        private static Encoding sjisEnc = Encoding.GetEncoding("Shift_JIS");

        //֑
        private static int[] intNg = {
            // 13
            0x8740,0x8741,0x8742,0x8743,0x8744,0x8745,0x8746,0x8747,0x8748,0x8749,0x874A,0x874B,0x874C,0x874D,0x874E,0x874F,
            0x8750,0x8751,0x8752,0x8753,0x8754,0x8755,0x8756,0x8757,0x8758,0x8759,0x875A,0x875B,0x875C,0x875D,0x875E,0x875F,
            0x8760,0x8761,0x8762,0x8763,0x8764,0x8765,0x8766,0x8767,0x8768,0x8769,0x876A,0x876B,0x876C,0x876D,0x876E,0x876F,
            0x8770,0x8771,0x8772,0x8773,0x8774,0x8775,0x8776,0x8777,0x8778,0x8779,0x877A,0x877B,0x877C,0x877D,0x877E,
            0x8780,0x8781,0x8782,0x8783,0x8784,0x8785,0x8786,0x8787,0x8788,0x8789,0x878A,0x878B,0x878C,0x878D,0x878E,0x878F,
            0x8790,0x8791,0x8792,0x8793,0x8794,0x8795,0x8796,0x8797,0x8798,0x8799,0x879A,0x879B,0x879C,0x879D,0x879E,
            // 89
            0xED40,0xED41,0xED42,0xED43,0xED44,0xED45,0xED46,0xED47,0xED48,0xED49,0xED4A,0xED4B,0xED4C,0xED4D,0xED4E,0xED4F,
            0xED50,0xED51,0xED52,0xED53,0xED54,0xED55,0xED56,0xED57,0xED58,0xED59,0xED5A,0xED5B,0xED5C,0xED5D,0xED5E,0xED5F,
            0xED60,0xED61,0xED62,0xED63,0xED64,0xED65,0xED66,0xED67,0xED68,0xED69,0xED6A,0xED6B,0xED6C,0xED6D,0xED6E,0xED6F,
            0xED70,0xED71,0xED72,0xED73,0xED74,0xED75,0xED76,0xED77,0xED78,0xED79,0xED7A,0xED7B,0xED7C,0xED7D,0xED7E,
            0xED80,0xED81,0xED82,0xED83,0xED84,0xED85,0xED86,0xED87,0xED88,0xED89,0xED8A,0xED8B,0xED8C,0xED8D,0xED8E,0xED8F,
            0xED90,0xED91,0xED92,0xED93,0xED94,0xED95,0xED96,0xED97,0xED98,0xED99,0xED9A,0xED9B,0xED9C,0xED9D,0xED9E,
            // 90
            0xED9F,
            0xEDA0,0xEDA1,0xEDA2,0xEDA3,0xEDA4,0xEDA5,0xEDA6,0xEDA7,0xEDA8,0xEDA9,0xEDAA,0xEDAB,0xEDAC,0xEDAD,0xEDAE,0xEDAF,
            0xEDB0,0xEDB1,0xEDB2,0xEDB3,0xEDB4,0xEDB5,0xEDB6,0xEDB7,0xEDB8,0xEDB9,0xEDBA,0xEDBB,0xEDBC,0xEDBD,0xEDBE,0xEDBF,
            0xEDC0,0xEDC1,0xEDC2,0xEDC3,0xEDC4,0xEDC5,0xEDC6,0xEDC7,0xEDC8,0xEDC9,0xEDCA,0xEDCB,0xEDCC,0xEDCD,0xEDCE,0xEDCF,
            0xEDD0,0xEDD1,0xEDD2,0xEDD3,0xEDD4,0xEDD5,0xEDD6,0xEDD7,0xEDD8,0xEDD9,0xEDDA,0xEDDB,0xEDDC,0xEDDD,0xEDDE,0xEDDF,
            0xEDE0,0xEDE1,0xEDE2,0xEDE3,0xEDE4,0xEDE5,0xEDE6,0xEDE7,0xEDE8,0xEDE9,0xEDEA,0xEDEB,0xEDEC,0xEDED,0xEDEE,0xEDEF,
            0xEDF0,0xEDF1,0xEDF2,0xEDF3,0xEDF4,0xEDF5,0xEDF6,0xEDF7,0xEDF8,0xEDF9,0xEDFA,0xEDFB,0xEDFC,
            // 91
            0xEE40,0xEE41,0xEE42,0xEE43,0xEE44,0xEE45,0xEE46,0xEE47,0xEE48,0xEE49,0xEE4A,0xEE4B,0xEE4C,0xEE4D,0xEE4E,0xEE4F,
            0xEE50,0xEE51,0xEE52,0xEE53,0xEE54,0xEE55,0xEE56,0xEE57,0xEE58,0xEE59,0xEE5A,0xEE5B,0xEE5C,0xEE5D,0xEE5E,0xEE5F,
            0xEE60,0xEE61,0xEE62,0xEE63,0xEE64,0xEE65,0xEE66,0xEE67,0xEE68,0xEE69,0xEE6A,0xEE6B,0xEE6C,0xEE6D,0xEE6E,0xEE6F,
            0xEE70,0xEE71,0xEE72,0xEE73,0xEE74,0xEE75,0xEE76,0xEE77,0xEE78,0xEE79,0xEE7A,0xEE7B,0xEE7C,0xEE7D,0xEE7E,
            0xEE80,0xEE81,0xEE82,0xEE83,0xEE84,0xEE85,0xEE86,0xEE87,0xEE88,0xEE89,0xEE8A,0xEE8B,0xEE8C,0xEE8D,0xEE8E,0xEE8F,
            0xEE90,0xEE91,0xEE92,0xEE93,0xEE94,0xEE95,0xEE96,0xEE97,0xEE98,0xEE99,0xEE9A,0xEE9B,0xEE9C,0xEE9D,0xEE9E,
            // 92
            0xEE9F,
            0xEEA0,0xEEA1,0xEEA2,0xEEA3,0xEEA4,0xEEA5,0xEEA6,0xEEA7,0xEEA8,0xEEA9,0xEEAA,0xEEAB,0xEEAC,0xEEAD,0xEEAE,0xEEAF,
            0xEEB0,0xEEB1,0xEEB2,0xEEB3,0xEEB4,0xEEB5,0xEEB6,0xEEB7,0xEEB8,0xEEB9,0xEEBA,0xEEBB,0xEEBC,0xEEBD,0xEEBE,0xEEBF,
            0xEEC0,0xEEC1,0xEEC2,0xEEC3,0xEEC4,0xEEC5,0xEEC6,0xEEC7,0xEEC8,0xEEC9,0xEECA,0xEECB,0xEECC,0xEECD,0xEECE,0xEECF,
            0xEED0,0xEED1,0xEED2,0xEED3,0xEED4,0xEED5,0xEED6,0xEED7,0xEED8,0xEED9,0xEEDA,0xEEDB,0xEEDC,0xEEDD,0xEEDE,0xEEDF,
            0xEEE0,0xEEE1,0xEEE2,0xEEE3,0xEEE4,0xEEE5,0xEEE6,0xEEE7,0xEEE8,0xEEE9,0xEEEA,0xEEEB,0xEEEC,0xEEED,0xEEEE,0xEEEF,
            0xEEF0,0xEEF1,0xEEF2,0xEEF3,0xEEF4,0xEEF5,0xEEF6,0xEEF7,0xEEF8,0xEEF9,0xEEFA,0xEEFB,0xEEFC,
            // 115
            0xFA40,0xFA41,0xFA42,0xFA43,0xFA44,0xFA45,0xFA46,0xFA47,0xFA48,0xFA49,0xFA4A,0xFA4B,0xFA4C,0xFA4D,0xFA4E,0xFA4F,
            0xFA50,0xFA51,0xFA52,0xFA53,0xFA54,0xFA55,0xFA56,0xFA57,0xFA58,0xFA59,0xFA5A,0xFA5B,0xFA5C,0xFA5D,0xFA5E,0xFA5F,
            0xFA60,0xFA61,0xFA62,0xFA63,0xFA64,0xFA65,0xFA66,0xFA67,0xFA68,0xFA69,0xFA6A,0xFA6B,0xFA6C,0xFA6D,0xFA6E,0xFA6F,
            0xFA70,0xFA71,0xFA72,0xFA73,0xFA74,0xFA75,0xFA76,0xFA77,0xFA78,0xFA79,0xFA7A,0xFA7B,0xFA7C,0xFA7D,0xFA7E,
            0xFA80,0xFA81,0xFA82,0xFA83,0xFA84,0xFA85,0xFA86,0xFA87,0xFA88,0xFA89,0xFA8A,0xFA8B,0xFA8C,0xFA8D,0xFA8E,0xFA8F,
            0xFA90,0xFA91,0xFA92,0xFA93,0xFA94,0xFA95,0xFA96,0xFA97,0xFA98,0xFA99,0xFA9A,0xFA9B,0xFA9C,0xFA9D,0xFA9E,
            // 116
            0xFA9F,
            0xFAA0,0xFAA1,0xFAA2,0xFAA3,0xFAA4,0xFAA5,0xFAA6,0xFAA7,0xFAA8,0xFAA9,0xFAAA,0xFAAB,0xFAAC,0xFAAD,0xFAAE,0xFAAF,
            0xFAB0,0xFAB1,0xFAB2,0xFAB3,0xFAB4,0xFAB5,0xFAB6,0xFAB7,0xFAB8,0xFAB9,0xFABA,0xFABB,0xFABC,0xFABD,0xFABE,0xFABF,
            0xFAC0,0xFAC1,0xFAC2,0xFAC3,0xFAC4,0xFAC5,0xFAC6,0xFAC7,0xFAC8,0xFAC9,0xFACA,0xFACB,0xFACC,0xFACD,0xFACE,0xFACF,
            0xFAD0,0xFAD1,0xFAD2,0xFAD3,0xFAD4,0xFAD5,0xFAD6,0xFAD7,0xFAD8,0xFAD9,0xFADA,0xFADB,0xFADC,0xFADD,0xFADE,0xFADF,
            0xFAE0,0xFAE1,0xFAE2,0xFAE3,0xFAE4,0xFAE5,0xFAE6,0xFAE7,0xFAE8,0xFAE9,0xFAEA,0xFAEB,0xFAEC,0xFAED,0xFAEE,0xFAEF,
            0xFAF0,0xFAF1,0xFAF2,0xFAF3,0xFAF4,0xFAF5,0xFAF6,0xFAF7,0xFAF8,0xFAF9,0xFAFA,0xFAFB,0xFAFC,
            // 117
            0xFB40,0xFB41,0xFB42,0xFB43,0xFB44,0xFB45,0xFB46,0xFB47,0xFB48,0xFB49,0xFB4A,0xFB4B,0xFB4C,0xFB4D,0xFB4E,0xFB4F,
            0xFB50,0xFB51,0xFB52,0xFB53,0xFB54,0xFB55,0xFB56,0xFB57,0xFB58,0xFB59,0xFB5A,0xFB5B,0xFB5C,0xFB5D,0xFB5E,0xFB5F,
            0xFB60,0xFB61,0xFB62,0xFB63,0xFB64,0xFB65,0xFB66,0xFB67,0xFB68,0xFB69,0xFB6A,0xFB6B,0xFB6C,0xFB6D,0xFB6E,0xFB6F,
            0xFB70,0xFB71,0xFB72,0xFB73,0xFB74,0xFB75,0xFB76,0xFB77,0xFB78,0xFB79,0xFB7A,0xFB7B,0xFB7C,0xFB7D,0xFB7E,
            0xFB80,0xFB81,0xFB82,0xFB83,0xFB84,0xFB85,0xFB86,0xFB87,0xFB88,0xFB89,0xFB8A,0xFB8B,0xFB8C,0xFB8D,0xFB8E,0xFB8F,
            0xFB90,0xFB91,0xFB92,0xFB93,0xFB94,0xFB95,0xFB96,0xFB97,0xFB98,0xFB99,0xFB9A,0xFB9B,0xFB9C,0xFB9D,0xFB9E,
            // 118
            0xFB9F,
            0xFBA0,0xFBA1,0xFBA2,0xFBA3,0xFBA4,0xFBA5,0xFBA6,0xFBA7,0xFBA8,0xFBA9,0xFBAA,0xFBAB,0xFBAC,0xFBAD,0xFBAE,0xFBAF,
            0xFBB0,0xFBB1,0xFBB2,0xFBB3,0xFBB4,0xFBB5,0xFBB6,0xFBB7,0xFBB8,0xFBB9,0xFBBA,0xFBBB,0xFBBC,0xFBBD,0xFBBE,0xFBBF,
            0xFBC0,0xFBC1,0xFBC2,0xFBC3,0xFBC4,0xFBC5,0xFBC6,0xFBC7,0xFBC8,0xFBC9,0xFBCA,0xFBCB,0xFBCC,0xFBCD,0xFBCE,0xFBCF,
            0xFBD0,0xFBD1,0xFBD2,0xFBD3,0xFBD4,0xFBD5,0xFBD6,0xFBD7,0xFBD8,0xFBD9,0xFBDA,0xFBDB,0xFBDC,0xFBDD,0xFBDE,0xFBDF,
            0xFBE0,0xFBE1,0xFBE2,0xFBE3,0xFBE4,0xFBE5,0xFBE6,0xFBE7,0xFBE8,0xFBE9,0xFBEA,0xFBEB,0xFBEC,0xFBED,0xFBEE,0xFBEF,
            0xFBF0,0xFBF1,0xFBF2,0xFBF3,0xFBF4,0xFBF5,0xFBF6,0xFBF7,0xFBF8,0xFBF9,0xFBFA,0xFBFB,0xFBFC,
            // 119
            0xFC40,0xFC41,0xFC42,0xFC43,0xFC44,0xFC45,0xFC46,0xFC47,0xFC48,0xFC49,0xFC4A,0xFC4B,

            0xA2,0xA3,0xA4,0xA5
        };

        /// <summary>
        /// RXgN^
        /// </summary>
        private StringChecker()
        {
        }

        /// <summary>
        /// @ˑ܂܂ĂƂtrueԂ
        /// </summary>
        /// <param name="aString">`FbNΏە</param>
        /// <returns>@ˑ܂܂Ătrue</returns>
        public static bool IncludesPcChar(string aString)
        {
            bool booRet = false;

            try
            {
                //zёւ
                Array.Sort(intNg);

                for (int i = 0; i < aString.Length; i++)
                {
                    byte[] bytWork = sjisEnc.GetBytes(aString.Substring(i, 1));

                    int intWork = 0;
                    if (bytWork.Length == 1)
                    {
                        intWork = (int)bytWork[0];
                    }
                    else if (bytWork.Length == 2)
                    {
                        intWork = ((int)bytWork[0] * 0x100) + (int)bytWork[1];
                    }

                    if (Array.BinarySearch(intNg, intWork) >= 0)
                    {
                        booRet = true;
                        break;
                    }
                }
            }
            catch
            {
                booRet = false;
            }
            finally
            {
            }

            return (booRet);
        }

        /// <summary>
        /// p܂܂ĂtrueԂ
        /// </summary>
        /// <param name="aString">`FbNΏە</param>
        /// <returns>p܂܂Ătrue</returns>
        public static bool IncludesAnk(string aString)
        {
            bool booRet = false;
            int intNum = 0;

            try
            {
                intNum = sjisEnc.GetByteCount(aString);

                if(intNum == aString.Length * 2)
                {
                    booRet = false;
                }
                else
                {
                    booRet = true;
                }
            }
            catch
            {
                booRet = false;
            }
            finally
            {
            }

            return (booRet);
        }

        /// <summary>
        /// 񂪎woCgȉ̏ꍇtrueԂ
        /// </summary>
        /// <param name="aValue">`FbNΏە</param>
        /// <param name="aByteLength">woCg</param>
        /// <returns>woCgȉ̏ꍇtrue</returns>
        public static bool CheckByteLength(string aValue, int aByteLength)
        {
            bool booRet = false;
            int intByte = 0;
            
            try
            {
                intByte = sjisEnc.GetByteCount(aValue);

                if (intByte <= aByteLength)
                {
                    booRet = true;
                }
            }
            catch
            {
                booRet = false;
            }
            finally
            {
            }
            
            return (booRet);
        }
    }
}
