using System;
using System.Collections.Generic;
using System.Text;

namespace OFW.Util
{
    /// <summary>
    /// javascript̂߂֗̕\bh
    /// </summary>
    public class JavaScriptUtil
    {
        /// <summary>
        /// GXP[v
        /// </summary>
        /// <param name="s">͕</param>
        /// <returns>GXP[vς݂̕</returns>
        public static string Escape(string s)
        {
            if (s == null || s.Length == 0)
            {
                return "";
            }
            char c;
            int i;
            int len = s.Length;
            StringBuilder sb = new StringBuilder(len + 4);

            for (i = 0; i < len; i += 1)
            {
                c = s[i];
                if ((c == '\\') || (c == '"') || (c == '>'))
                {
                    sb.Append('\\');
                    sb.Append(c);
                }
                else if (c == '\b')
                    sb.Append("\\b");
                else if (c == '\t')
                    sb.Append("\\t");
                else if (c == '\n')
                    sb.Append("\\n");
                else if (c == '\f')
                    sb.Append("\\f");
                else if (c == '\r')
                    sb.Append("\\r");
                else
                {
                    if (c < ' ')
                    {
                        //t = "000" + Integer.toHexString(c);
                        //IWiNii.JSON玝ĂAǂ_炵
                        //string tmp = new string(c,1);
                        //t = "000" + int.Parse(tmp,System.Globalization.NumberStyles.HexNumber);
                        //sb.Append("\\u" + t.Substring(t.Length - 4));
                        string tmp = ((int)c).ToString("x4");
                        sb.Append("\\u" + tmp);

                    }
                    else
                    {
                        sb.Append(c);
                    }
                }
            }
            return sb.ToString();

        }
        /// <summary>
        /// ̈p
        /// </summary>
        /// <param name="s">͕</param>
        /// <returns>pLtBg̓GXP[vς</returns>
        public static string Quote(string s)
        {
            return "\"" + Escape(s) + "\"";
        }
        /// <summary>
        /// ϐ`
        /// </summary>
        /// <param name="variableName">ϐ</param>
        /// <param name="initialValue">l</param>
        /// <returns>ϐ`</returns>
        public static string DefineVariable(string variableName,int initialValue)
        {
            string statement = string.Format("var {0} = {1};", variableName, initialValue);
            return statement;
        }
        /// <summary>
        /// ϐ`
        /// </summary>
        /// <param name="variableName">ϐ</param>
        /// <param name="initialValue">l</param>
        /// <returns>ϐ`</returns>
        public static string DefineVariable(string variableName, string initialValue)
        {
            string statement = string.Format("var {0} = {1};", variableName, Quote( initialValue ));
            return statement;
        }
        /// <summary>
        /// ϐ`
        /// </summary>
        /// <param name="variableName">ϐ</param>
        /// <param name="initialValue">l</param>
        /// <returns>ϐ`</returns>
        public static string DefineVariable(string variableName, object initialValue)
        {
            OFW.Serializer.JSONSerializer serializer = new OFW.Serializer.JSONSerializer(initialValue.GetType());
            string serialized = serializer.Serialize(initialValue);

            string statement = string.Format("var {0} = {1};", variableName, serialized);
            return statement;

        }
        /// <summary>
        /// (onclickƂonchangeƂ)javascripteSɂ
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>Sȕ</returns>
        /// <remarks>AttibutesvpeBɃZbg&amp;&amp;ampɒuB
        /// ɂׂł͂ȂB</remarks>
        public static string SafeJSArgumentString(string s)
        {
            s = StringUtil.DeleteEscapeSequence(s);
            return "\"" + s.Replace("\\", "\\\\").Replace("\"", "\\\"") + "\"";
        }

    }
}
