using System;
using System.Collections.Generic;
using System.Text;

namespace OFW.Util
{
    /// <summary>
    /// oCgz֗̕\bhW
    /// </summary>
    public class ByteArrayUtil
    {
        /// <summary>
        /// oCgz̕؂o
        /// </summary>
        /// <param name="input"></param>
        /// <param name="start"></param>
        /// <param name="length"></param>
        /// <returns></returns>
        public static byte[] Slice(byte[] input, int start, int length)
        {
            int end = start + length;
            byte[] resultArray = new byte[length];
            for (int i = 0; i < length; i++)
            {
                resultArray[i] = input[start + i];
            }
            return resultArray;
        }
        /// <summary>
        /// byte[]̌
        /// </summary>
        /// <param name="array1"></param>
        /// <param name="array2">l</param>
        /// <returns></returns>
        public static byte[] Concat(byte[] array1, byte[] array2)
        {
            List<byte> newList = new List<byte>(array1);
            newList.AddRange(array2);
            return newList.ToArray();
        }
        /// <summary>
        /// l
        /// </summary>
        /// <param name="array1">r</param>
        /// <param name="array2">r</param>
        /// <returns>r</returns>
        public static bool Equals(byte[] array1, byte[] array2)
        {
            if (array1.Length != array2.Length) return false;
            int length= array1.Length;
            bool result = true;
            for (int i = 0; i < length; i++)
            {
                if (array1[i] != array2[i])
                {
                    result = false;
                    break;
                }
            }
            return result;
        }
        /// <summary>
        /// 16i
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        public static string ToHexString(byte[] input)
        {
            System.Text.StringBuilder result = new System.Text.StringBuilder();
            foreach (byte b in input)
            {
                result.Append(b.ToString("x2"));
            }
            return result.ToString();
        }
        /// <summary>
        /// 16i񂩂oCgz֕ϊ
        /// </summary>
        /// <param name="input">16i</param>
        /// <returns>ʔz</returns>
        public static byte[] FromHexString(string input)
        {
            byte[] bytes = new byte[input.Length / 2];
            for (int i = 0; i < bytes.Length; i++)
            {
                string element = input.Substring(i * 2);
                bytes[i] = System.Convert.ToByte(element, 16);
            }
            return bytes;

        }
        /// <summary>
        /// BASE64
        /// </summary>
        /// <param name="input">̃oCg</param>
        /// <returns>BASE64</returns>
        public static string ToBase64String(byte[] input)
        {
            return Convert.ToBase64String(input);
        }
        /// <summary>
        /// BASE64񂩂oCgz֕ϊ
        /// </summary>
        /// <param name="input">base64</param>
        /// <returns>ʔz</returns>
        public static byte[] FromBase64String(string input)
        {
            return Convert.FromBase64String(input);
        }

        /// <summary>
        /// 񂩂oCgɕϊ(UTF-8)
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>oCgz</returns>
        public static byte[] FromString(string s)
        {
            Encoding encoding = Encoding.UTF8;
            byte[] bytes = encoding.GetBytes(s);
            return bytes;
        }
        /// <summary>
        /// 񂩂oCgɕϊ
        /// </summary>
        /// <param name="s">̕</param>
        /// <param name="enc">̃GR[fBO</param>
        /// <returns>oCgz</returns>
        public static byte[] FromString(string s, Encoding enc)
        {
            byte[] bytes = enc.GetBytes(s);
            return bytes;
        }
        /// <summary>
        /// oCgz񂩂當֕ϊ(UTF-8)
        /// </summary>
        /// <param name="bytes">oCgz</param>
        /// <returns>ʕ</returns>
        public static string ToString(byte[] bytes)
        {
            Encoding encoding = Encoding.UTF8;
            string retstr = encoding.GetString(bytes, 0, bytes.Length);
            return retstr;
        }
        /// <summary>
        /// oCgz񂩂當֕ϊ
        /// </summary>
        /// <param name="bytes">oCgz</param>
        /// <param name="enc">GR[fBO</param>
        /// <returns>ʕ</returns>
        public static string ToString(byte[] bytes, Encoding enc)
        {
            string retstr = enc.GetString(bytes, 0, bytes.Length);
            return retstr;
        }


    }
}
