using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Reflection;
using System.Xml.Serialization;

namespace OFW.Serializer
{
    /// <summary>
    /// DSCNVACY
    /// </summary>
    public class DscnSerializer
    {
        Type mType;
        TextWriter mWriter;

        TextReader mReader;
        string sBuffer;
        string sType;
        string sFieldName;
        int nLength;
        string sValue;
        //߂ɎɂĂ݂
        //List<Type> TypeCache;
        Dictionary<string, Type> TypeCache;
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="t"></param>
        public DscnSerializer(Type t)
        {
            mType = t;
        }
        /// <summary>
        /// VACY
        /// </summary>
        /// <param name="writer"></param>
        /// <param name="obj"></param>
        public void Serialize(TextWriter writer, object obj)
        {
            mWriter = writer;

            SerializeElement(obj, mType,  mType.Name,0);
            return;
        }
        string lvString(int lv)
        {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < lv; i++)
            {
                builder.Append("\t");
            }
            return builder.ToString();
        }
        void SerializeElement(object o, Type t, string baseName,int lv)
        {
            if (o == null)
            {
                return;
            }
            else if (o == DBNull.Value)
            {
                return;
            }
            Type objectType = t;
            if (IsNullable(t))
            {
                objectType = t.GetGenericArguments()[0];
            }

            if (objectType.Name == "DateTime")
            {
                mWriter.WriteLine(lvString(lv) +  baseName  + "=" + escape( o.ToString() ));
                return;
            }
            else if (objectType.Name == "String")
            {
                mWriter.WriteLine(lvString(lv) + baseName + "=" + escape(o.ToString() ));
                return;
            }
            else if (objectType.Name == "Type")
            {
                mWriter.WriteLine(lvString(lv) + baseName + "=" + ((Type)o).FullName);
                return;
            }
            else if (objectType.IsEnum)
            {
                int i = (int)System.Convert.ChangeType(o, objectType);
                mWriter.WriteLine(lvString(lv) + baseName + "=" + escape(i.ToString()));
                return;
            }

            else if (objectType.IsPrimitive || objectType.IsValueType)
            {
                //TODO:objectɑ΂Č^ƒl킯ĕۑB
                if (objectType.Name == "Object")
                {
                    mWriter.WriteLine(lvString(lv) + baseName + ":" + o.GetType().FullName + "=" + escape(o.ToString()));

                    return;
                }

                mWriter.WriteLine(lvString(lv) + baseName + "=" + escape(o.ToString()));
                return;
            }
            else if (t.Name == "Object")
            {
                mWriter.WriteLine(lvString(lv) + baseName + ":" + o.GetType().FullName + "=" + escape(o.ToString()));

                return;
            }
            else
            {
                if(t.IsGenericType){
                    //Dictionary
                    Type[] ga = t.GetGenericArguments();
                    if (ga.Length > 1) return;
                }

                Type tt = o.GetType().GetInterface("System.Collections.ICollection");
                if (tt != null)
                {
                    SerializeArrayElement(o, t, baseName,lv);
                    return;
                }
                else
                {
                    SerializeObject(o, t, baseName,lv);
                    return;
                }
            }
        }
        void SerializeObject(object o, Type t, string baseName,int lv)
        {
            Type objectType = o.GetType();


            mWriter.WriteLine(lvString(lv) + baseName + ":" + o.GetType().FullName);

            FieldInfo[] fis = objectType.GetFields();
            foreach (FieldInfo fi in fis)
            {

                if (fi.GetCustomAttributes(typeof(System.Xml.Serialization.XmlIgnoreAttribute), true).Length > 0) continue;
                object childValue = fi.GetValue(o);

                Type childType = fi.FieldType;
                SerializeElement(childValue, childType,  fi.Name,lv + 1);
            }
            PropertyInfo[] pis = objectType.GetProperties();
            foreach (PropertyInfo pi in pis)
            {

                if (pi.GetCustomAttributes(typeof(XmlIgnoreAttribute), true).Length > 0) continue;
                object childValue = pi.GetValue(o, null);
                Type childType = pi.PropertyType;
                SerializeElement(childValue, childType,  pi.Name,lv + 1);
            }
        }

        void SerializeArrayElement(object o, Type t, string baseName,int lv)
        {

            if (o == null)
            {
                return;
            }
            System.Collections.ICollection ic = (System.Collections.ICollection)o;
            System.Collections.IEnumerator e = ic.GetEnumerator();

            mWriter.WriteLine(lvString(lv) + baseName + ":" + t.Name + ";" + ic.Count.ToString()); //̏ꍇA͎^CvȂ`^CvŕB

            int i = 0;
            while (e.MoveNext())
            {
                if (e.Current == null)
                {
                    SerializeElement(e.Current, null, i.ToString() , lv + 1);
                }
                else
                {
                    Type childType = e.Current.GetType();
                    if (childType.IsPrimitive || childType.IsValueType )
                    {
                        SerializeElement(e.Current, childType, i.ToString() + ":" + childType.FullName, lv + 1);
                    }
                    else
                    {
                        SerializeElement(e.Current, childType, i.ToString() , lv + 1);
                    }
                }
                i++;
            }

        }
        /// <summary>
        /// tVACY
        /// </summary>
        /// <param name="reader"></param>
        /// <returns></returns>
        public object Deserialize(TextReader reader)
        {
            TypeCache = new Dictionary<string, Type>();
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            mReader = reader;
            
            ReadNext();
            if (sBuffer == null) return null;
            if (sBuffer == "") return null;

            object rootElement = parseElement(sBuffer, mType);//ɂArraŷ́AList̂̂VACŶ͕s



            sw.Stop();
            System.Diagnostics.Trace.WriteLine("ellapsed " + sw.ElapsedMilliseconds.ToString());
            return rootElement;
        }
        object parseElement(string spec, Type t)
        {


            Type objectType = null;
            if (sType != "") objectType = GetType(sType);
            if (objectType == null) objectType = t;

            bool isNullable = IsNullable(objectType);
            if (isNullable) objectType = objectType.GetGenericArguments()[0];

            if (objectType == typeof(DateTime))
            {
                object o = (DateTime)Convert.ToDateTime(sValue);
                ReadNext();
                return o;
            }
            else if (objectType == typeof(string))
            {
                object o = sValue;
                ReadNext();
                return o;
            }
            else if (objectType == typeof(Type))
            {
                Type o = GetType(sValue);
                ReadNext();
                return o;
            }
            else if (objectType.IsEnum)
            {

                int i = (int)System.Convert.ChangeType(sValue, objectType);
                ReadNext();
                return i;
            }

            else if (objectType.IsPrimitive || objectType.IsValueType)
            {
                object o = Convert.ChangeType(sValue, objectType);
                ReadNext();
                return o;
            }
            else
            {
                Type ilistType = objectType.GetInterface("System.Collections.IList");
                if (ilistType != null)
                {
                    int length = getSerializedListLength(spec);
                    if (objectType.IsArray)
                    {
                        Array a = (Array)parseArrayElement(spec,objectType);

                        return a;
                    }
                    if (objectType.IsGenericType)
                    {
                        System.Collections.IList il = (System.Collections.IList)parseListElement(spec, objectType);
                        return il;
                    }
                    if (objectType.BaseType.IsArray)
                    {
                        Array a = (Array)parseArrayElement(spec, objectType);
                        return a;
                    }
                    if (objectType.BaseType.IsGenericType)
                    {
                        System.Collections.IList il = (System.Collections.IList)parseListElement(spec, objectType);
                        return il;
                    }

                    System.Collections.IList dil = (System.Collections.IList)parseDefaultListElement(spec, objectType);
                    return dil;
                }
                else
                {
                    object o = parseObjectElement(spec,objectType);
                    return o;
                }
            }
            ////ReadNext();

            ////return null; //̃^Cvclass//structȂ̂Œl͂܂s



        }
        object parseArrayElement(string spec, Type t)
        {
            Array a = (Array)Activator.CreateInstance(t, new object[] { nLength });
            if (nLength > 0)
            {
                int len = nLength;
                ReadNext();
                for (int i = 0; i < len ; i++)
                {
                    Type tt = GetType(getSerializedTypeName(sBuffer));
                    object childObject = parseElement(sBuffer, tt);
                    a.SetValue(childObject, i);
                }
            }
            else
            {
                ReadNext();
            }
            return a;

        }
        object parseListElement(string spec, Type t)
        {

            System.Collections.IList il = (System.Collections.IList)Activator.CreateInstance(t);
            Type[] genericArguments = t.GetGenericArguments();

            if (nLength > 0)
            {
                int len = nLength;
                ReadNext();
                for (int i = 0; i < len; i++)
                {
                    Type tt = null;
                    if (sBuffer == null) break;
                    if(sType != ""){
                        tt = GetType(sType);
                    }
                    if (tt == null)
                    {
                        if (genericArguments != null)
                        {
                            if (genericArguments.Length > 0)
                            {
                                tt = t.GetGenericArguments()[0];
                            }
                        }
                    }
                    if (tt == null)
                    {
                        ReadNext();
                        continue;
                    }
                    object childObject = parseElement(sBuffer, tt);

                    il.Add(childObject);
                }
            }
            else
            {
                ReadNext();
            }
            return il;

        }
        object parseDefaultListElement(string spec, Type t)
        {
            System.Collections.IList il = (System.Collections.IList)Activator.CreateInstance(t);

            if (nLength > 0)
            {
                int len = nLength;
                ReadNext();
                for (int i = 0; i < len; i++)
                {
                    Type tt = null;
                    if (sBuffer == null) break;
                    if (sType != "")
                    {
                        tt = GetType(sType);
                    }
                    if (tt == null)
                    {
                        Type[] genericArguments = t.GetGenericArguments();
                        if (genericArguments != null)
                        {
                            if (genericArguments.Length > 0)
                            {
                                tt = t.GetGenericArguments()[0];
                            }
                        }
                    }
                    if (tt == null)
                    {
                        il.Add(sValue);
                        ReadNext();
                        continue;
                    }
                    else
                    {
                        object childObject = parseElement(sBuffer, tt);

                        il.Add(childObject);
                    }
                }
            }
            else
            {
                ReadNext();
            }
            return il;

        }
        int getLevel(string s)
        {
            int lv = 0;
            for (int i = 0; i < s.Length; i++)
            {
                if (s.Substring(i, 1) != "\t") break;
                lv++;
            }
            return lv;
        }
        object parseObjectElement(string spec, Type t)
        {

            Type objectType = t;
            if (sType != "") objectType = GetType(sType);
            if (objectType == null) return null;
            bool isNullable = IsNullable(objectType);
            if (isNullable) objectType = objectType.GetGenericArguments()[0];


            object o = Activator.CreateInstance(objectType);
            Type tt = o.GetType();
            int level = getLevel(spec);
            ReadNext();
            int nextLevel = getLevel(sBuffer);
            while (nextLevel > level)
            {
                if (sBuffer == null) break;
                nextLevel = getLevel(sBuffer);
                
                if (nextLevel <= level) break;
                string childFieldName = sFieldName;

               
                FieldInfo fi = tt.GetField(childFieldName);
                if (fi != null)
                {
                    object childObject = parseElement(sBuffer, fi.FieldType);
                    fi.SetValue(o, childObject);
                    continue;
                }
                else
                {
                    PropertyInfo pi = tt.GetProperty(childFieldName);
                    if (pi != null)
                    {
                        if (pi.CanWrite)
                        {
                            object childObject = parseElement(sBuffer, pi.PropertyType);
                            pi.SetValue(o, childObject, null);
                            continue;
                        }
                    }
                }

                ReadNext();
            }


            return o;
        }
        void Skip(int currentLevel)
        {
            ReadNext();
            int nextLevel = getLevel(sBuffer);
            while (nextLevel > currentLevel)
            {
                ReadNext();
                nextLevel = getLevel(sBuffer);
            }

        }

        void ReadNext()
        {
            sBuffer = mReader.ReadLine();
            if (sBuffer == null)
            {
                sType = "";
                sValue = "";
                nLength = 0;
                sFieldName = "";
                return;

            }

            int posValue = sBuffer.IndexOf("=");
            int posType = sBuffer.IndexOf(":");
            int posLength = sBuffer.IndexOf(";");

            if (posValue < 0) posValue = sBuffer.Length;

            if (posLength < 0) posLength = posValue;
            if (posLength > posValue) posLength = posValue; //Value";"܂܂Ă
            
            if (posType < 0) posType = posLength;
            if (posType > posValue) posType = posLength; //Value":"܂܂Ă


            sFieldName = sBuffer.Substring(0, posType).Replace("\t", "");
            if (posLength > posType) sType = sBuffer.Substring(posType + 1, posLength - posType - 1);
            else sType = "";

            if (posValue > posLength) nLength =Int32.Parse( sBuffer.Substring(posLength + 1, posValue - posLength - 1) );
            else nLength = 0;

            if (posValue < sBuffer.Length) sValue = unescape( sBuffer.Substring(posValue + 1) );
            else sValue = "";
            

        }
        bool IsNullable(Type type)
        {
            if (type.IsGenericType)
            {
                if (type.GetGenericTypeDefinition() ==
                    typeof(Nullable<>)) return true;
            }
            return false;
        }
        private Type GetType(string typeName)
        {

            Type t = null;
            t = Type.GetType(typeName);

            if (t == null)
            {
                if (TypeCache == null) TypeCache = new Dictionary<string,Type>();
                if(TypeCache.ContainsKey(typeName)) t = TypeCache[typeName];
            }
            if (t == null)
            {

                AppDomain a = AppDomain.CurrentDomain;
                Assembly[] asms = a.GetAssemblies();
                for (int i = 0; i < asms.Length; i++)
                {
                    t = asms[i].GetType(typeName);
                    if (t != null)
                    {
                        TypeCache.Add(typeName, t);
                        break;
                    }
                }
            }
            return t;
        }

        string getSerializedTypeNameBase(string s)
        {
            int posType = s.IndexOf(":");
            if (posType < 0) return "";

            int posValue = s.IndexOf("=");
            if (posValue < 0) return s.Substring(posType + 1);

            if (posType > posValue) return "";
            else return s.Substring(posType + 1, posValue - posType - 1);

        }
        string getSerializedTypeName(string s)
        {
            string typenameBase = getSerializedTypeNameBase(s);

            int posLength = typenameBase.IndexOf(";");
            if (posLength < 0) return typenameBase;
            else return typenameBase.Substring(0, posLength);

        }
        int getSerializedListLength(string s)
        {
            string typenameBase = getSerializedTypeNameBase(s);

            int posLength = typenameBase.IndexOf(";");
            if (posLength < 0) return 0;
            else return int.Parse(typenameBase.Substring(posLength + 1));

        }
        string getSerializedValue(string s)
        {
            int posValue = s.IndexOf("=");
            if (posValue < 0) return null;
            else return s.Substring(posValue + 1);

        }
        string getSerializedFieldName(string s)
        {

            int posValue = s.IndexOf("=");
            int posType = s.IndexOf(":");

            if (posValue < 0)
            {
                if(posType < 0) return "";
                return s.Substring(0, posType).Replace("\t", "");
            }

            if (posType < 0) return s.Substring(0, posValue).Replace("\t","");

            if (posType < posValue) return s.Substring(0, posType).Replace("\t", "");
            else return s.Substring(0, posValue).Replace("\t", "");


        }
        string getSerializedPath(string s)
        {
            // pX̍Ō"/"ȍ~,pX̍Ō̓^Cv̑O
            int posType = s.IndexOf(":");
            if (posType < 0) return "";
            return s.Substring(0, posType);
        }
        string getBasePath(string path)
        {
            int posLastPathDelimiter = path.LastIndexOf("/");
            if (posLastPathDelimiter < 0) return "";
            else return path.Substring(0, posLastPathDelimiter);
        }
        string escape(string s)
        {
            if (s == null || s.Length == 0)
            {
                return "";
            }
            char c;
            int i;
            int len = s.Length;
            StringBuilder sb = new StringBuilder(len + 4);


            for (i = 0; i < len; i += 1)
            {
                c = s[i];
                if ((c == '\\') || (c == '"') || (c == '>'))
                {
                    sb.Append('\\');
                    sb.Append(c);
                }
                else if (c == '\b')
                    sb.Append("\\b");
                else if (c == '\t')
                    sb.Append("\\t");
                else if (c == '\n')
                    sb.Append("\\n");
                else if (c == '\f')
                    sb.Append("\\f");
                else if (c == '\r')
                    sb.Append("\\r");
                else
                {
                    if (c < ' ')
                    {
                        //t = "000" + Integer.toHexString(c);
                        //łcparseĂ܂BeXgĂȂ
                        //////string tmp = new string(c, 1);
                        //////t = "000" + int.Parse(tmp, System.Globalization.NumberStyles.HexNumber);
                        //////sb.Append("\\u" + t.Substring(t.Length - 4));
                        string tmp = ((int)c).ToString("x4");
                        sb.Append("\\u" + tmp);

                    }
                    else
                    {
                        sb.Append(c);
                    }
                }
            }
            return sb.ToString();
        }
        string unescape(string s)
        {
            if (s == null) return null;
            char c;
            int p = 0;
            char[] ss = s.ToCharArray();
            bool hasData = (string.IsNullOrEmpty(s) ? false :true );
            StringBuilder sb = new StringBuilder();
            while (hasData)
            {
                c = ss[p++];
                if ((c == 0x00) || (c == 0x0A) || (c == 0x0D))
                {
                    throw (new Exception("Unterminated string"));
                }
                // CTRL chars
                if (c == '\\')
                {
                    c = ss[p++];
                    switch (c)
                    {
                        case 'b': //Backspace
                            sb.Append('\b');
                            break;
                        case 't': //Horizontal tab
                            sb.Append('\t');
                            break;
                        case 'n':  //newline
                            sb.Append('\n');
                            break;
                        case 'f':  //Form feed
                            sb.Append('\f');
                            break;
                        case 'r':  // Carriage return
                            sb.Append('\r');
                            break;
                        case 'u':
                            //sb.append((char)Integer.parseInt(next(4), 16)); // 16 == radix, ie. hex
                            char[] intc = new char[4] { ss[p], ss[p+1], ss[p+2], ss[p+3] };
                            p += 4;
                            string ints = new string(intc);
                            int iascii = int.Parse(ints, System.Globalization.NumberStyles.HexNumber);
                            sb.Append((char)iascii);
                            break;
                        default:
                            sb.Append(c);
                            break;
                    }
                }
                else
                {

                    sb.Append(c);
                }
                if (p >= ss.Length) break;
            }//END-while
            return sb.ToString();
        }
    }
}
