using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
namespace OFW.Log
{
    /// <summary>
    /// [U[ʃO
    /// </summary>
    public class UserLogWriter : LogWriter
    {
        private const int SLEEP_TIME = 50;
        private const int RETRY_TIMES_MAX = 5;

        string baseDir;
        string baseName;
        OFW.IO.FileSystem fileSystem;
        
        /// <summary>
        /// 
        /// </summary>
        /// <param name="configString"></param>
        public override void Init(string configString)
        {
            string[] conf = configString.Split(';');
            for(int i = 0;i < conf.Length;i++)
            {
                string[] el = conf[i].Split('=');
                if (el[0] == "baseDir")
                {
                    this.baseDir = el[1];
                    continue;
                }
                if (el[0] == "baseName")
                {
                    this.baseName = el[1];
                    continue;
                }

            }
            fileSystem = IO.FileSystemFactory.GetInstance();


        }
        /// <summary>
        /// Oo͏ꏊm
        /// </summary>
        string createDirectory(string userId)
        {
            if (string.IsNullOrEmpty(userId)) userId = "anonymous";

            if (!fileSystem.DirectoryExists(this.baseDir))
            {
                fileSystem.CreateDirectory(this.baseDir);
            }
            DateTime now = DateTime.Now;
            string dir = fileSystem.CreateDirectory(this.baseDir,
                now.ToString("yyyy"),
                now.ToString("yyyyMM"),
                now.ToString("yyyyMMdd"),
                userId
            );
            return dir;

        }
        /// <summary>
        /// writer擾
        /// </summary>
        /// <param name="dir">ݐ</param>
        /// <param name="logTime">O</param>
        /// <param name="level">o͂郁bZ[W̃x</param>
        /// <param name="moduleName">gp҂̃W[</param>
        /// <param name="methodName">gp҂̃\bh</param>
        /// <returns></returns>
        /// <remarks>
        /// writergpł΂writerԂ
        /// writerĂ/܂gpłȂȂVwriter𐶐ĕԂB<br />
        /// {[ɂ萶g[Xt@C̃t@CgpȂΈ莞ԑ҂ēx̃t@C̎gps邪A܂łĂJȂꍇt@CɘAԂtĎsB10񎎍ssO𑗏o
        /// </remarks>
        private StreamWriter getWriter(string dir,DateTime logTime, LogLevel level, string moduleName, string methodName)
        {


            FileStream fs = null;
            StreamWriter writer = null;
            int numRetry = 0;
            int numFile = 0;
            while (writer == null)
            {
                try
                {
                    string filename = getTraceFileName(logTime,numFile,level, moduleName, methodName);
                    fs = new FileStream(Path.Combine(dir, filename), FileMode.Append, FileAccess.Write, FileShare.None);
                    writer = new StreamWriter(fs);
                    break;
                }
                catch
                {
                }
                numRetry++;
                if (numRetry > RETRY_TIMES_MAX)
                {
                    numFile++;
                    if (numFile > 10) break;
                    numRetry = 0;
                }

                System.Threading.Thread.Sleep(SLEEP_TIME);
            }
            if (writer == null) throw new Exception("trace file cannot be created " + dir );
            return writer;
        }
        private string getTraceFileName(DateTime logTime,int num, LogLevel level, string moduleName, string methodName)
        {
            string suffix = "";
            if (num > 0) suffix = "-" + num.ToString("00");

            string fileName = "";
            if( this.baseName != "") fileName += this.baseName + ".";
            fileName += logTime.ToString("yyyyMMdd_HHmmddfff") + "-" + level.ToString() + "-" + moduleName + "-" + methodName + suffix + ".log";

            return fileName;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="level"></param>
        /// <param name="userId"></param>
        /// <param name="moduleName"></param>
        /// <param name="methodName"></param>
        /// <param name="message"></param>
        public override void Write(LogLevel level, string userId, string moduleName, string methodName, string message)
        {
            string dir = createDirectory(userId);
            DateTime logTime = DateTime.Now;
            StreamWriter writer = getWriter(dir,logTime,level, moduleName, methodName);
            writer.Write(logTime.ToString("yyyy/MM/dd HH:mm:ss.fff"));
            writer.Write(" ");
            writer.WriteLine(message);
            writer.Close();
        }
        /// <summary>
        /// Lv`[ACe܂Ƃ߂ăOɏo͂
        /// </summary>
        /// <param name="items">Lv`[ACeXg</param>
        public override void WriteCaptured(IEnumerable<LogCaptureItem> items)
        {
            
            DateTime logTime = DateTime.Now;
            StreamWriter writer = null;
            foreach (LogCaptureItem item in items)
            {
                if (writer == null)
                {
                    string dir = createDirectory(item.userId);
                    writer = getWriter(dir, logTime, item.level, item.moduleName, item.methodName);
                }
                writer.Write(logTime.ToString("yyyy/MM/dd HH:mm:ss.fff"));
                writer.Write("\t");
                writer.WriteLine("[" + item.level.ToString() + "]");
                writer.Write("\t");
                writer.WriteLine(item.moduleName + "#" + item.methodName);
                writer.Write("\t");
                writer.WriteLine(item.message);
            }
            if(writer != null) writer.Close();

        }
    }
}
