using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
namespace OFW.Log
{
    /// <summary>
    /// ftHg̃Oo
    /// System.Diagnostics.Traceɏ
    /// </summary>
    /// <remarks>option="name=(name)"ɂtrace/listenersɎw肵(name)̖̂Xi[ɏo͂Bw肪ΑSẴXi[ɏóB</remarks>
    public class DefaultLogWriter : LogWriter
    {
        string listenerName;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="configString"></param>
        /// <remarks>name=(name)ɂtrace/listenersɎw肵Xi[ɏo͂Bw肪ΑSẴXi[ɏóB</remarks>
        public override void Init(string configString)
        {
            listenerName = "";
            string[] keyValue = OFW.Util.StringUtil.SplitKeyValue(configString,"=");
            if (keyValue[0] == "name")
            {
                listenerName = keyValue[1];
            }
        }

        /// <summary>
        /// O
        /// </summary>
        /// <param name="level"></param>
        /// <param name="userId">ݎgp̃[U[</param>
        /// <param name="moduleName">gp҂̃W[</param>
        /// <param name="methodName">gp҂̃\bh</param>
        /// <param name="message"></param>
        public override void Write(LogLevel level, string userId, string moduleName, string methodName, string message)
        {
            if (this.listenerName != "")
            {
                System.Diagnostics.Trace.Listeners[listenerName].WriteLine(this.FormatMessage(userId, moduleName, methodName, message), level.ToString());
            }
            else
            {
                System.Diagnostics.Trace.WriteLine(this.FormatMessage(userId, moduleName, methodName, message), level.ToString());
            }
        }
        /// <summary>
        /// Lv`[ꂽACeo
        /// </summary>
        /// <param name="items">Lv`[ꂽACe</param>
        /// <remarks>`͂Ă(Lv`[ꂽeACeɂWrite)AړÏׂɂ͎NXłƂǂB</remarks>
        public override void WriteCaptured(IEnumerable<LogCaptureItem> items)
        {
            if (this.listenerName != "")
            {
                System.Diagnostics.TraceListener listener = System.Diagnostics.Trace.Listeners[listenerName];
                foreach (LogCaptureItem item in items)
                {
                    listener.Write(item.capturedTime.ToString("yyyy/MM/dd HH:mm:ss.ffffff"));
                    listener.Write("\t");
                    listener.Write(item.level.ToString());
                    listener.Write("\t");
                    listener.Write(item.userId);
                    listener.Write("\t");
                    listener.Write(item.moduleName);
                    listener.Write("\t");
                    listener.Write(item.methodName);
                    listener.Write("\t");
                    listener.Write(item.message.ToString());
                    listener.Write(Environment.NewLine);
                }
                listener.WriteLine("");

            }
            else
            {
                foreach (LogCaptureItem item in items)
                {
                    System.Diagnostics.Trace.Write(item.capturedTime.ToString("yyyy/MM/dd HH:mm:ss.fff"));
                    System.Diagnostics.Trace.Write("\t");
                    System.Diagnostics.Trace.Write(item.level.ToString());
                    System.Diagnostics.Trace.Write("\t");
                    System.Diagnostics.Trace.Write(item.userId);
                    System.Diagnostics.Trace.Write("\t");
                    System.Diagnostics.Trace.Write(item.moduleName);
                    System.Diagnostics.Trace.Write("\t");
                    System.Diagnostics.Trace.Write(item.methodName);
                    System.Diagnostics.Trace.Write("\t");
                    System.Diagnostics.Trace.Write(item.message.ToString());
                    System.Diagnostics.Trace.Write(Environment.NewLine);

                }
                System.Diagnostics.Trace.WriteLine("");
            }

        }
        /// <summary>
        /// wOo͂ł`ɐ`
        /// </summary>
        /// <param name="userId">[U[ID</param>
        /// <param name="moduleName">W[</param>
        /// <param name="methodName">\bh</param>
        /// <param name="message">[U[ǉbZ[W</param>
        /// <returns>`ς݃bZ[W</returns>
        string FormatMessage(string userId, string moduleName, string methodName, string message)
        {
            string formattedMessage= "";
            if (!string.IsNullOrEmpty(userId))
            {
                formattedMessage += userId;
            }
            formattedMessage += "\t";
            
            if (!string.IsNullOrEmpty(moduleName))
            {
                formattedMessage += moduleName;
            }
            if (!string.IsNullOrEmpty(methodName))
            {
                formattedMessage += "#" + methodName;
            }
            formattedMessage += "\t" + message;
            return formattedMessage;
        }
    }
}
