using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
namespace OFW.IO
{
    /// <summary>
    /// ftHgt@CVXe
    /// </summary>
    public class DefaultFileSystem : FileSystem
    {
        /// <summary>
        /// 
        /// </summary>
        public DefaultFileSystem()
        {

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <param name="buffer"></param>
        /// <param name="mode"></param>
        /// <returns></returns>
        public override int WriteBinary(string path,byte[] buffer, FileMode mode)
        {
            int readLimit = buffer.Length;

            BinaryWriter writer = new BinaryWriter(new FileStream(path, mode, FileAccess.Write));
            writer.Write(buffer);
            writer.Close();

            return readLimit;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <param name="buffer"></param>
        /// <param name="mode"></param>
        /// <returns></returns>
        public override int WriteText(string path, string buffer, FileMode mode)
        {
            int readLimit = buffer.Length;

            StreamWriter writer = new StreamWriter(new FileStream(path, mode, FileAccess.Write));
            writer.Write(buffer);
            writer.Close();

            return readLimit;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <param name="buffer"></param>
        /// <param name="mode"></param>
        /// <param name="encoding"></param>
        /// <returns></returns>
        public override int WriteText(string path, string buffer, FileMode mode, System.Text.Encoding encoding)
        {
            int readLimit = buffer.Length;

            StreamWriter writer = new StreamWriter(new FileStream(path, mode, FileAccess.Write),encoding);
            writer.Write(buffer);
            writer.Close();

            return readLimit;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <param name="buffer"></param>
        /// <param name="mode"></param>
        /// <returns></returns>
        public override int WriteTextShiftJIS(string path, string buffer, FileMode mode)
        {
            System.Text.Encoding sjisEncodnig = System.Text.Encoding.GetEncoding("Shift_JIS");
            return WriteText(path, buffer,mode, sjisEncodnig);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <param name="mode"></param>
        /// <returns></returns>
        public override string ReadText(string path, FileMode mode)
        {
            FileInfo fi = new FileInfo(path);
            if (fi == null) throw new FileNotFoundException();
            if (!fi.Exists) throw new FileNotFoundException();
            StreamReader reader = new StreamReader(new FileStream(path, mode, FileAccess.Read));
            string s = reader.ReadToEnd();
            reader.Close();
            return s;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <param name="mode"></param>
        /// <param name="encoding"></param>
        /// <returns></returns>
        public override string ReadText(string path, FileMode mode, System.Text.Encoding encoding)
        {
            FileInfo fi = new FileInfo(path);
            if (fi == null) throw new FileNotFoundException();
            if (!fi.Exists) throw new FileNotFoundException();
            StreamReader reader = new StreamReader(new FileStream(path, mode, FileAccess.Read),encoding);
            string s = reader.ReadToEnd();
            reader.Close();
            return s;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <param name="mode"></param>
        /// <returns></returns>
        public override string ReadTextShiftJIS(string path, FileMode mode)
        {
            System.Text.Encoding sjisEncodnig = System.Text.Encoding.GetEncoding("Shift_JIS");
            return ReadText(path, mode, sjisEncodnig);

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <param name="mode"></param>
        /// <returns></returns>
        public override byte[] ReadBinary(string path, FileMode mode)
        {
            FileInfo fi = new FileInfo(path);
            if (fi == null) throw new FileNotFoundException();
            if (!fi.Exists) throw new FileNotFoundException();
            BinaryReader reader = new BinaryReader(new FileStream(path, mode, FileAccess.Read));
            long readLimit = fi.Length;
            byte[] buffer = reader.ReadBytes((int)readLimit); //KRIɂQG܂łɂȂĂ܂AȂɓǂ܂ĂB
            reader.Close();

            return buffer;

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <param name="attr"></param>
        public override void SetAttribute(string path, int attr)
        {
            FileAttributes fileattr = (FileAttributes)attr;
            System.IO.File.SetAttributes(path,fileattr);
            
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public override int GetAttribute(string path)
        {
            return (int)System.IO.File.GetAttributes(path );

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="src"></param>
        /// <param name="dst"></param>
        public override void CopyFile(string src, string dst)
        {
            System.IO.File.Copy(src, dst);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="src"></param>
        /// <param name="dst"></param>
        /// <param name="overwrite"></param>
        public override void CopyFile(string src, string dst, bool overwrite)
        {
            System.IO.File.Copy(src, dst, overwrite);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        public override void DeleteFile(string path)
        {
            System.IO.File.Delete(path);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public override bool FileExists(string path)
        {
            return System.IO.File.Exists(path);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="src"></param>
        /// <param name="dst"></param>
        public override void MoveFile(string src, string dst)
        {
            System.IO.File.Move(src,dst);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <param name="spec">ǉfBNg̎dl</param>
        /// <returns></returns>
        public override string CreateDirectory(string path,params string[] spec)
        {
            DirectoryInfo di = null;
            if(!System.IO.Directory.Exists(path)) di = System.IO.Directory.CreateDirectory(path);

            if (spec == null) return path;

            string specPath = path;
            for (int i = 0; i < spec.Length; i++)
            {
                specPath = CombineName(specPath, spec[i]);
                if (!System.IO.Directory.Exists(specPath)) di = System.IO.Directory.CreateDirectory(specPath);
            }

            return specPath;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="src"></param>
        /// <param name="dst"></param>
        public override void MoveDirectory(string src, string dst)
        {
            System.IO.Directory.Move(src,dst);

            return ;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        public override void DeleteDirectory(string path)
        {
            System.IO.Directory.Delete(path);

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <param name="recursive"></param>
        public override void DeleteDirectory(string path, bool recursive)
        {
            System.IO.Directory.Delete(path,recursive);

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public override bool DirectoryExists(string path)
        {
            return System.IO.Directory.Exists(path);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public override string[] GetDirectories(string path)
        {
            return System.IO.Directory.GetDirectories(path);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public override string[] GetFiles(string path)
        {
            return System.IO.Directory.GetFiles(path);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path1"></param>
        /// <param name="path2"></param>
        /// <returns></returns>
        public override string CombineName(string path1, string path2)
        {
            return System.IO.Path.Combine(path1,path2);
        }
        /// <summary>
        /// 
        /// </summary>
        public override char DirectorySeparetorChar
        {
            get
            {
                return System.IO.Path.DirectorySeparatorChar;
            }
        }
        /// <summary>
        /// pathɊ܂܂path delimiter̂悤Ȃ̂oB
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        /// <remarks>\Ƀ`FbNĂ\ 
        /// Ȃ/TĂ/
        /// Ȃ\</remarks>
        public override string GetSeparator(string path)
        {
            if (path.IndexOf("\\") >= 0) return "\\";
            if (path.IndexOf("/") >= 0) return "/";
            return "\\";
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public override string GetDirectoryName(string path)
        {
            return System.IO.Path.GetDirectoryName(path);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public override string GetExtension(string path)
        {
            return System.IO.Path.GetExtension(path);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public override string GetFileName(string path)
        {
            return System.IO.Path.GetFileName(path);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public override string GetFullPath(string path)
        {
            return  System.IO.Path.GetFullPath(path);

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public override long FileSize(string path)
        {
            return new FileInfo(path).Length;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public override FileInfo FileInfo(string path)
        {
            return new FileInfo(path);
        }

      

    }
}
