using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

namespace OFW.Forms.Filters
{
    /// <summary>
    /// ltB^[
    /// </summary>
    public class NumberFilter<T> : Filter 
    {
        int precision;
        int scale;
        bool truncateOnExceed;
        bool zeroOnError;
        /// <summary>
        /// ftHg
        /// </summary>
        public NumberFilter()
        {
            this.precision = 28;
            this.scale = 0;
            this.truncateOnExceed = false;
            this.zeroOnError = false;
        }
        /// <summary>
        /// Axw
        /// </summary>
        /// <param name="precision"></param>
        /// <param name="scale">x</param>
        public NumberFilter(int precision,int scale)
        {
            this.precision = precision;
            this.scale = scale;
            this.truncateOnExceed = true;
            this.zeroOnError = false;
        }
        /// <summary>
        /// xA؎̂Ďw
        /// </summary>
        /// <param name="precision"></param>
        /// <param name="scale">x</param>
        /// <param name="truncateOnExceed">z̏ꍇɐ؂̂Ă邩</param>
        public NumberFilter(int precision, int scale,bool truncateOnExceed)
        {
            this.precision = precision;
            this.scale = scale;
            this.truncateOnExceed = truncateOnExceed;
            this.zeroOnError = false;
        }
        /// <summary>
        /// xA؎̂Ďw
        /// </summary>
        /// <param name="precision"></param>
        /// <param name="scale">x</param>
        /// <param name="truncateOnExceed">z̏ꍇɐ؂̂Ă邩</param>
        /// <param name="zeroOnError">G[̏ꍇ0ɂ</param>
        public NumberFilter(int precision, int scale, bool truncateOnExceed,bool zeroOnError)
        {
            this.precision = precision;
            this.scale = scale;
            this.truncateOnExceed = truncateOnExceed;
            this.zeroOnError = zeroOnError;
        }
        /// <summary>
        /// vpeBw
        /// </summary>
        /// <param name="prop">vpeB</param>
        public NumberFilter(FieldProperties.FieldProperty prop)
        {
            this.precision = prop.Precision;
            this.scale = prop.Scale;
            this.zeroOnError = false;
        }
        /// <summary>
        /// vpeBw
        /// </summary>
        /// <param name="prop">vpeB</param>
        /// <param name="truncateOnExceed">z̏ꍇɐ؂̂Ă邩</param>
        public NumberFilter(FieldProperties.FieldProperty prop, bool truncateOnExceed)
        {
            this.precision = prop.Precision;
            this.scale = prop.Scale;
            this.truncateOnExceed = truncateOnExceed;
            this.zeroOnError = false;
        }
        /// <summary>
        /// vpeBw
        /// </summary>
        /// <param name="prop">vpeB</param>
        /// <param name="truncateOnExceed">z̏ꍇɐ؂̂Ă邩</param>
        /// <param name="zeroOnError">G[̏ꍇ0ɂ</param>
        public NumberFilter(FieldProperties.FieldProperty prop, bool truncateOnExceed, bool zeroOnError)
        {
            this.precision = prop.Precision;
            this.scale = prop.Scale;
            this.truncateOnExceed = truncateOnExceed;
            this.zeroOnError = zeroOnError;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="o">͒l</param>
        /// <returns>tB^[̒l</returns>
        public override object FilterValue(object o)
        {
            if (o == null) return "";
            
            string stringValue = o.ToString();
            //AA_𒊏o
            stringValue = Util.StringUtil.NormalizeNumeric(stringValue);
            if (stringValue == "") return default(T);

            string[] numericParts = Util.StringUtil.Split(stringValue, ".");

            int sign = 1;
            if (numericParts[0].StartsWith("-")) sign = -1;

            string intPart = Regex.Replace(numericParts[0], "^[+\\-]?0*", "");
            if (intPart == "") intPart = "0";

            string decimalPart = "";
            if (numericParts.Length > 1)
            {
                decimalPart = Regex.Replace(numericParts[1], "0*$", "");
                if (decimalPart == "") decimalPart = "0";
            }


            if (this.truncateOnExceed)
            {
                intPart = Util.StringUtil.Right(intPart, this.precision - this.scale);
                decimalPart = Util.StringUtil.Left(decimalPart, this.scale);
            }
            string filterd = "";
            if (sign < 0) filterd += "-";
            filterd += intPart;
            if (decimalPart != "") filterd += "." + decimalPart;

            T val = Util.NumberUtil.Parse<T>( filterd );
            T zero = Util.NumberUtil.Parse<T>("0"); 

            //ł͋󕶎͂肦Ȃ̂ŁAϊʂnullɂȂꍇ=I[o[ƂŕϊłȂꍇłB
            if (val == null)
            {
                if (this.zeroOnError) return (T)zero;
                //̂̕܂ܕԂB
                return filterd; 
            }
            //ł͋󕶎͂肦Ȃ̂ŁAϊʂ0ɂȂꍇ=I[o[ƂŕϊłȂꍇ܂͌0̏ꍇłB
            string checkZero = val.ToString();

            if ((checkZero  == "0")||(checkZero  == "0.0"))
            {
                if ((filterd == "0") || (filterd == "0.0"))
                {
                    //[B
                    return (T)zero;
                }
                else
                {
                    //G[ă[ɂꂽ
                    if (this.zeroOnError) return (T)zero;
                    //̂̕܂ܕԂB
                    return filterd;

                }
            }


            return val;
        }
    }
}
