using System;
using System.Collections.Generic;
using System.Text;

namespace OFW.Forms.Filters
{
    /// <summary>
    /// t^̃tB^[
    /// </summary>
    public class DateTimeFilter : Filter
    {
        /// <summary>
        /// ̓tH[}bg
        /// </summary>
        string inputFormat;

        bool nullOnError;

        /// <summary>
        /// ftHg\z
        /// </summary>
        public DateTimeFilter()
        {
            this.inputFormat = OFW.DateTimeInputFormat.DATE_LONG;
            this.nullOnError = false;
        }
        /// <summary>
        /// ̓tH[}bgw
        /// </summary>
        /// <param name="inputFormat">̓tH[}bg</param>
        public DateTimeFilter(string inputFormat)
        {
            this.inputFormat = inputFormat;
            this.nullOnError = false;

        }
        /// <summary>
        /// ̓tH[}bgwAtH[}bgG[̂ƂnullԂIvVw
        /// </summary>
        /// <param name="inputFormat">̓tH[}bg</param>
        /// <param name="nullOnError">tH[}bgG[̂ƂnullԂ</param>
        public DateTimeFilter(string inputFormat,bool nullOnError)
        {
            this.inputFormat = inputFormat;
            this.nullOnError = nullOnError;

        }
        /// <summary>
        /// tB^[
        /// </summary>
        /// <param name="o">͒l</param>
        /// <returns>tB^[̒l</returns>
        public override object FilterValue(object o)
        {
            if (o == null) return null;

            if (o is DateTime)
            {
                string s = OFW.Util.DateUtil.Format(o,this.inputFormat);
                DateTime d = (DateTime) OFW.Util.DateUtil.Parse(s, this.inputFormat);

                return d;
            }
            else
            {
                string s = Util.StringUtil.NormalizeDateTime(o.ToString());
                if (s == "") return null;

                DateTime? d = null;
                if (inputFormat.StartsWith("H"))
                {
                    d = Util.DateUtil.ParseTime(s);
                }
                else
                {
                    d = Util.DateUtil.Parse(s);
                }
                //͂ĂnullɂȂȂ牽G[񂾂낤B
                if (d == null)
                {
                    if (this.nullOnError) return null;
                    return s;
                }

                string normalize = Util.DateUtil.Format(d, this.inputFormat);
                d = Util.DateUtil.Parse(normalize);
                return d;
            }
        }
    }
}
