using System;
using System.Collections.Generic;
using System.Text;
using OFW.Util;
namespace OFW.FieldProperties
{
    /// <summary>
    /// pFieldPRoperty
    /// </summary>
    [Serializable()]
    public class StringFieldProperty : FieldProperty
    {
        /// <summary>
        /// ŏ̒(ꖢȂG[)
        /// </summary>
        int minLength;


        /// <summary>
        /// ŏ̒(ꖢȂG[)
        /// </summary>
        public int MinLength
        {
            get { return minLength; }
            set { minLength = value; }
        }

        bool useWideChar;
        /// <summary>
        /// Ch`gB̒́u1vPʂƂȂB
        /// </summary>
        public bool UseWideChar
        {
            get { return useWideChar; }
            set { useWideChar = value; }
        }

        
        /// <summary>
        /// default construct
        /// </summary>
        public StringFieldProperty()
            : base()
        {
            FieldType = typeof(string);
            setup("nvarchar", "", "", "", 8000, 4000, 0, false, "", false);
            Format = "";
            useWideChar = true;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="entityName"></param>
        /// <param name="fieldName"></param>
        /// <param name="displayName"></param>
        public StringFieldProperty(string entityName, string fieldName, string displayName)
            : base()
        {
            FieldType = typeof(short);
            setup("nvarchar", entityName, fieldName, displayName, 8000, 4000, 0, false, "", false);
            useWideChar = true;
        }
        /// <summary>
        /// Rs[RXgN^ǂ
        /// </summary>
        /// <param name="p"></param>
        public StringFieldProperty(FieldProperty p)
            : base(p)
        {
            FieldType = typeof(string);
            if (p.GetType() == this.GetType())
            {
                Format = ((StringFieldProperty)p).Format;
            }
        }
        /// <summary>
        /// ftHgl
        /// </summary>
        public override object DefaultValue
        {
            get
            {
                return this.mDefaultValue;
            }
            set
            {
                this.mDefaultValue = StringUtil.StringValue( value );
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override object Clone()
        {
            return new StringFieldProperty(this);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="length"></param>
        /// <param name="precision"></param>
        /// <param name="scale"></param>
        public override void setSize(int length, int precision, int scale)
        {
            if ((length == 0) && (precision == 0) && (scale == 0)) return;
            if ((length != 0) && (precision == 0) && (scale == 0))
            {
                if (useWideChar)
                {
                    this.Length = length * 2; //ۂ̃oCg͕񒷂3{ȂAvalidateparameterۂɂprecisionĝœK
                    this.Precision = length;
                }
                else
                {
                    this.Length = length;
                    this.Precision = length;
                }
                return;
            }
            this.Length = length;
            this.Precision = precision;
            this.Scale = scale;

               
        }
    }
    
}
