using System;
using System.Collections.Generic;
using System.Text;
using OFW.Util;

namespace OFW.FieldProperties
{
    /// <summary>
    /// int pFieldProperty
    /// </summary>
    [Serializable()]
    public class ShortFieldProperty : FieldProperty
    {
        /// <summary>
        /// ől
        /// </summary>
        public short MaxValue = Int16.MaxValue;
        /// <summary>
        /// ŏl
        /// </summary>
        public short MinValue = Int16.MinValue;
        /// <summary>
        /// default construct
        /// </summary>
        public ShortFieldProperty()
            : base()
        {
            FieldType = typeof(short);
            setup("smallint", "", "", "", 2, 5, 0, false, 0, false);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="entityName"></param>
        /// <param name="fieldName"></param>
        /// <param name="displayName"></param>
        public ShortFieldProperty(string entityName, string fieldName, string displayName)
            : base()
        {
            FieldType = typeof(short);
            setup("smallint", entityName, fieldName, displayName, 2, 5, 0, false, 0, false);
        }
        /// <summary>
        /// Rs[RXgN^ǂ
        /// </summary>
        /// <param name="p">ɂȂvpeB</param>
        public ShortFieldProperty(FieldProperty p)
            : base(p)
        {
            FieldType = typeof(int);
            if (p.GetType() == this.GetType())
            {
                MaxValue = ((ShortFieldProperty)p).MaxValue;
                MinValue = ((ShortFieldProperty)p).MinValue;
            }
        }
        /// <summary>
        /// ő咷
        /// </summary>
        /// <returns>ő͒</returns>
        /// <remarks>J}AA_܂񂾒Ԃ</remarks>
        public override int MaxLength
        {
            get
            {
                int max = this.Precision;

                //","؂̕
                max += (this.Precision - this.Scale - 1) / 3;
                //̕
                max += 1;

                return max;
            }
        }
        /// <summary>
        /// ftHgl
        /// </summary>
        /// <returns>ftHgl̕\</returns>
        public override string DefaultValueDisplay()
        {
            return NumberUtil.Format(this.DefaultValue,"#");
        }
        /// <summary>
        /// ftHgl
        /// </summary>
        public override object DefaultValue
        {
            get
            {
                return this.mDefaultValue;
            }
            set
            {
                this.mDefaultValue = NumberUtil.Value<short?>(value);
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override object Clone()
        {
            return new ShortFieldProperty(this);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="length"></param>
        /// <param name="precision"></param>
        /// <param name="scale"></param>
        public override void setSize(int length, int precision, int scale)
        {
            //length,scale͖B
            if (precision != 0) this.Precision = precision;
        }

    }
}
