using System;
using System.Collections.Generic;
using System.Text;
using OFW.Util;
namespace OFW.FieldProperties
{
    /// <summary>
    /// 10ipFieldProperty
    /// </summary>
    [Serializable()]
    public class FloatFieldProperty : FieldProperty
    {
        /// <summary>
        /// ől
        /// </summary>
        public float MaxValue;
        /// <summary>
        /// ŏl
        /// </summary>
        public float MinValue;
        /// <summary>
        /// default constructor
        /// </summary>
        public FloatFieldProperty()
            : base()
        {
            FieldType = typeof(float);
            setup("real", "", "", "", 4, 7, 0, false, 0, false);
            MaxValue = float.MaxValue;
            MinValue = float.MinValue;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="entityName"></param>
        /// <param name="fieldName"></param>
        /// <param name="displayName"></param>
        public FloatFieldProperty(string entityName, string fieldName, string displayName)
            : base()
        {
            FieldType = typeof(float);
            setup("float", entityName, fieldName, displayName, 4, 7, 0, false, 0, false);

            MaxValue = float.MaxValue;
            MinValue = float.MinValue;
        }

        /// <summary>
        /// Rs[RXgN^ǂ
        /// </summary>
        /// <param name="p">ɂȂvpeB</param>
        public FloatFieldProperty(FieldProperty p)
            : base(p)
        {
            FieldType = typeof(float);

            if (p.GetType() == this.GetType())
            {
                MaxValue = ((FloatFieldProperty)p).MaxValue;
                MinValue = ((FloatFieldProperty)p).MinValue;
            }
        }
        /// <summary>
        /// ő咷
        /// </summary>
        /// <returns>ő͒</returns>
        /// <remarks>J}AA_܂񂾒Ԃ</remarks>
        public override int MaxLength
        {
            get
            {
                //_̏ꍇLI[o[ƏɊۂ߂B
                //ē͕̂ĂȂ߂ɂ͓͂LȓɎ߂Ȃ΂ȂȂB

                int max = this.Precision; //


                //","؂̕
                max += (max - 1) / 3;
                //̕
                max += 1;
                //_̕
                max += 1;

                return max;
            }
        }
        /// <summary>
        /// ftHgl̕\
        /// </summary>
        /// <returns></returns>
        public override string DefaultValueDisplay()
        {
            return NumberUtil.Format(this.DefaultValue, "#");
        }
        /// <summary>
        /// ftHgl
        /// </summary>
        public override object DefaultValue
        {
            get
            {
                return this.mDefaultValue;
            }
            set
            {
                this.mDefaultValue = NumberUtil.Value<float?>(value);
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override object Clone()
        {
            return new FloatFieldProperty(this);
        }
    }
}
