using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using OFW.Util;

namespace OFW.FieldProperties
{
    /// <summary>
    /// tB[h`̒
    /// </summary>
    [Serializable()]
    public abstract class FieldProperty : ICloneable
    {
        /// <summary>
        /// ɂȂe[u
        /// </summary>
        public string TableName; 
        /// <summary>
        /// ɂȂ
        /// </summary>
        public string FieldName; 
        /// <summary>
        /// ^Cv
        /// </summary>
        public Type FieldType;
        /// <summary>
        /// 
        /// </summary>
        public int Length; 
        /// <summary>
        /// L
        /// </summary>
        public int Precision; 
        /// <summary>
        /// x
        /// </summary>
        public int Scale; 
        /// <summary>
        /// NULL
        /// </summary>
        public bool IsNullable;
        /// <summary>
        /// primary key
        /// </summary>
        public bool IsPrimaryKey;
        /// <summary>
        /// 
        /// </summary>
        public string Description;
        /// <summary>
        /// ɂȂe[uɒ`ꂽ^̖O
        /// </summary>
        public string sqlTypeName;
        /// <summary>
        /// \p̖
        /// </summary>
        /// <remarks>TODOFɂɎׂ</remarks>
        public string DisplayName; 
        /// <summary>
        /// XVΏۗ
        /// </summary>
        public bool DoUpdate; 
        /// <summary>
        /// ̓tH[}bg
        /// </summary>
        public string Format;
        /// <summary>
        /// \ptH[}bg
        /// </summary>
        /// <remarks>#0,yyyy/MM/dd,etc...</remarks>
        public string DisplayFormat; 
        /// <summary>
        /// DBł̃tH[}bg
        /// </summary>
        /// <remarks>ۑ̓svarcharȂǂŒ`Ăʂ̃^Cv̍ڂۑƂɓKptH[}bg<br />
        /// tyyyyMMddŕۑꍇȂǂɎgp</remarks>
        public string DbFormat; //yyyyMMdd etc...
        /// <summary>
        /// default
        /// </summary>
        protected object mDefaultValue;
        /// <summary>
        /// ftHgl
        /// </summary>
        public virtual object DefaultValue
        {
            get { return mDefaultValue; }
            set { mDefaultValue = value; }
        }

        /// <summary>
        /// AllowZero
        /// </summary>
        public bool AllowZero;
        /// <summary>
        /// Visible
        /// </summary>
        public bool IgnoreValidation;
        /// <summary>
        /// default constructor
        /// </summary>
        public FieldProperty()
        {

            TableName = "";
            FieldName = "";
            DisplayName = "";
            //FieldType;
            Length = 0;
            Precision = 0;
            Scale = 0;
            IsNullable = true;
            IsPrimaryKey = false;
            DefaultValue = null;
            Description = "";
            DoUpdate = true;
            Format = "";
            DisplayFormat = "";
            DbFormat = "";

            AllowZero = false;
            this.IgnoreValidation = false;
        }
        /// <summary>
        /// Rs[RXgN^ǂ
        /// </summary>
        /// <param name="p">ɂȂFieldProperty</param>
        public FieldProperty(FieldProperty p)
        {
            this.TableName = p.TableName;
            this.FieldName = p.FieldName;
            this.FieldType = p.FieldType;
            this.Length = p.Length;
            this.Precision = p.Precision;
            this.Scale = p.Scale;
            this.IsNullable = p.IsNullable;
            this.IsPrimaryKey = p.IsPrimaryKey;
            this.DefaultValue = p.DefaultValue;
            this.Description = p.Description;
            this.sqlTypeName = p.sqlTypeName;
            this.DisplayName = p.DisplayName;
            this.Format = p.Format;
            this.DisplayFormat = p.DisplayFormat;
            this.DbFormat = p.DbFormat;
            this.DoUpdate = p.DoUpdate;
            this.AllowZero= p.AllowZero;
            this.IgnoreValidation = p.IgnoreValidation;

        }
        /// <summary>
        /// \zݒ
        /// </summary>
        /// <param name="sqlTypeName"></param>
        /// <param name="entityName"></param>
        /// <param name="fieldName"></param>
        /// <param name="displayName"></param>
        /// <param name="length"></param>
        /// <param name="precision"></param>
        /// <param name="scale"></param>
        /// <param name="nullable"></param>
        /// <param name="defaultValue"></param>
        /// <param name="isPrimaryKey"></param>
        public virtual void setup(string sqlTypeName, string entityName, string fieldName, string displayName, int length, int precision, int scale, bool nullable, object defaultValue, bool isPrimaryKey)
        {

            this.sqlTypeName = sqlTypeName;
            this.TableName = entityName;
            this.FieldName = fieldName;
            this.DisplayName = displayName;

            this.Length = length;
            this.Precision = precision;
            this.Scale = scale;
            this.IsNullable = nullable;
            this.IsPrimaryKey = isPrimaryKey;

            this.DefaultValue = defaultValue;

            this.Description = "";
            this.DoUpdate = true;
            this.Format = "";
            this.DisplayFormat = "";
            this.DbFormat = "";

            this.AllowZero = false;
            this.IgnoreValidation = false;

        }
        /// <summary>
        /// ֌W̒l܂Ƃ߂Đݒ
        /// </summary>
        /// <param name="length"></param>
        /// <param name="precision"></param>
        /// <param name="scale"></param>
        public virtual void setSize(int length, int precision, int scale)
        {
            if ((length == 0) && (precision == 0) && (scale == 0)) return;

            if (length != 0) this.Length = length;
            if (precision != 0) this.Precision = precision;
            if (scale != 0) this.Scale = scale;
        }
        /// <summary>
        /// ȈՃ\bh
        /// </summary>
        /// <param name="sqlTypeName"></param>
        /// <returns></returns>
        public static FieldProperty create(string sqlTypeName)
        {
            return NewInstance(sqlTypeName);
        }
        /// <summary>
        /// ȈՃ\bh Ow
        /// </summary>
        /// <param name="sqlTypeName"></param>
        /// <param name="tableName"></param>
        /// <param name="columnName"></param>
        /// <param name="displayName"></param>
        /// <returns></returns>
        public static FieldProperty create(string sqlTypeName, string tableName, string columnName, string displayName)
        {
            FieldProperty p = NewInstance(sqlTypeName);
            if (p != null)
            {
                p.TableName = tableName;
                p.FieldName = columnName;
                p.DisplayName = displayName;
            }
            return p;
        }
        /// <summary>
        /// ȈՃ\bh(stringp)
        /// </summary>
        /// <param name="sqlTypeName"></param>
        /// <param name="length"></param>
        /// <returns></returns>
        public static FieldProperty create(string sqlTypeName,int length)
        {
            FieldProperty p = NewInstance(sqlTypeName);
            p.setSize(length, 0, 0);
            return p;
        }
        /// <summary>
        /// ȈՃ\bh(decimalp)
        /// </summary>
        /// <param name="sqlTypeName"></param>
        /// <param name="precision"></param>
        /// <param name="scale"></param>
        /// <returns></returns>
        public static FieldProperty create(string sqlTypeName, int precision, int scale)
        {
            FieldProperty p = NewInstance(sqlTypeName);
            p.setSize(0, precision, scale);
            return p;
        }
        /// <summary>
        /// ȈՃ\bh(\bhZk)
        /// </summary>
        /// <param name="sqlTypeName"></param>
        /// <param name="tableName"></param>
        /// <param name="columnName"></param>
        /// <param name="displayName"></param>
        /// <param name="length"></param>
        /// <param name="prec"></param>
        /// <param name="scale"></param>
        /// <param name="nullable"></param>
        /// <param name="columnDef"></param>
        /// <param name="isPrimaryKey"></param>
        /// <returns></returns>
        public static FieldProperty create(string sqlTypeName, string tableName, string columnName, string displayName, int length, int prec, int scale, bool nullable, object columnDef, bool isPrimaryKey)
        {
            FieldProperty p = NewInstance(sqlTypeName);
            if (p != null)
            {
                p.TableName = tableName;
                p.FieldName = columnName;
                p.DisplayName = displayName;
                p.IsNullable = nullable;
                p.IsPrimaryKey = isPrimaryKey;
                if (p is StringFieldProperty || p is DecimalFieldProperty)
                {
                    p.setSize(length, prec, scale);
                }
                p.DefaultValue = columnDef;
            }
            return p;
        }
        /// <summary>
        /// ȈՃ\bh
        /// </summary>
        /// <param name="type"></param>
        /// <returns></returns>
        public static FieldProperty create(Type type)
        {
            return NewInstance(type);
        }
        /// <summary>
        /// ȈՃ\bh Ow
        /// </summary>
        /// <param name="type"></param>
        /// <param name="tableName"></param>
        /// <param name="columnName"></param>
        /// <param name="displayName"></param>
        /// <returns></returns>
        public static FieldProperty create(Type type, string tableName, string columnName, string displayName)
        {
            FieldProperty p = NewInstance(type);
            if (p != null)
            {
                p.TableName = tableName;
                p.FieldName = columnName;
                p.DisplayName = displayName;
            }
            return p;
        }
        /// <summary>
        /// ȈՃ\bh(stringp)
        /// </summary>
        /// <param name="type"></param>
        /// <param name="length"></param>
        /// <returns></returns>
        public static FieldProperty create(Type type, int length)
        {
            FieldProperty p = NewInstance(type);
            p.setSize(length, 0, 0);
            return p;
        }
        /// <summary>
        /// ȈՃ\bh(decimalp)
        /// </summary>
        /// <param name="type"></param>
        /// <param name="precision"></param>
        /// <param name="scale"></param>
        /// <returns></returns>
        public static FieldProperty create(Type type, int precision, int scale)
        {
            FieldProperty p = NewInstance(type);
            p.setSize(0, precision, scale);
            return p;
        }
        /// <summary>
        /// ȈՃ\bh(\bhZk)
        /// </summary>
        /// <param name="type"></param>
        /// <param name="tableName"></param>
        /// <param name="columnName"></param>
        /// <param name="displayName"></param>
        /// <param name="length"></param>
        /// <param name="prec"></param>
        /// <param name="scale"></param>
        /// <param name="nullable"></param>
        /// <param name="columnDef"></param>
        /// <param name="isPrimaryKey"></param>
        /// <returns></returns>
        public static FieldProperty create(Type type, string tableName, string columnName, string displayName, int length, int prec, int scale, bool nullable, object columnDef, bool isPrimaryKey)
        {
            FieldProperty p = NewInstance(type);
            if (p != null)
            {
                p.TableName = tableName;
                p.FieldName = columnName;
                p.DisplayName = displayName;
                p.IsNullable = nullable;
                p.IsPrimaryKey = isPrimaryKey;
                if (p is StringFieldProperty || p is DecimalFieldProperty)
                {
                    p.setSize(length, prec, scale);
                }
                p.DefaultValue = columnDef;
            }
            return p;
        }

        /// <summary>
        /// SQL^CvɑΉK؂ȃ^CvFieldProperty𐶐B
        /// </summary>
        /// <param name="sqlTypeName">SQL^Cv</param>
        /// <returns>SQL^CvɑΉK؂ȃ^CvFieldProperty</returns>
        public static FieldProperty NewInstance(string sqlTypeName)
        {

            if (sqlTypeName.CompareTo("decimal") == 0)
            {
                DecimalFieldProperty p = new DecimalFieldProperty();
                return p;
            }
            if (sqlTypeName.CompareTo("int") == 0)
            {
                IntFieldProperty p = new IntFieldProperty();
                return p;
            }
            if (sqlTypeName.CompareTo( "smallint" ) == 0)
            {
                ShortFieldProperty p = new ShortFieldProperty();
                return p;
            }
            if (sqlTypeName.CompareTo("varchar") == 0)
            {
                StringFieldProperty p = new StringFieldProperty();
                p.UseWideChar = false;
                return p;
            }
            if (sqlTypeName.CompareTo("char") == 0)
            {
                StringFieldProperty p = new StringFieldProperty();
                p.UseWideChar = false;
                return p;
            }
            if (sqlTypeName.CompareTo("text") == 0)
            {
                StringFieldProperty p = new StringFieldProperty();
                p.UseWideChar = false;
                return p;
            }
            if (sqlTypeName.CompareTo("nvarchar") == 0)
            {
                StringFieldProperty p = new StringFieldProperty();
                p.UseWideChar = true;
                return p;
            }
            if (sqlTypeName.CompareTo("nchar" ) == 0)
            {
                StringFieldProperty p = new StringFieldProperty();
                p.UseWideChar = true;
                return p;
            }
            if (sqlTypeName.CompareTo("ntext") == 0)
            {
                StringFieldProperty p = new StringFieldProperty();
                p.UseWideChar = true;
                return p;
            }
            if (sqlTypeName.CompareTo("datetime") == 0)
            {
                DateFieldProperty p = new DateFieldProperty();
                return p;
            }
            if (sqlTypeName.CompareTo("smalldatetime") == 0)
            {
                DateFieldProperty p = new DateFieldProperty();
                p.sqlTypeName = sqlTypeName;
                p.MinValue = new DateTime(1900, 1, 1);
                p.MaxValue = new DateTime(2079, 6, 6);
                return p;
            }

            if (sqlTypeName == "bigint")
            {
                LongFieldProperty p = new LongFieldProperty();
                return p;
            }
            if (sqlTypeName == "int identity")
            {
                IntFieldProperty p = new IntFieldProperty();
                return p;
            }
            if (sqlTypeName == "bigint identity")
            {
                LongFieldProperty p = new LongFieldProperty();
                return p;
            }
            if (sqlTypeName == "tinyint")
            {
                ByteFieldProperty p = new ByteFieldProperty();
                return p;
            }

            if (sqlTypeName == "money")
            {
                DecimalFieldProperty p = new DecimalFieldProperty();
                p.setSize(20, 19, 4);
                p.sqlTypeName = sqlTypeName;

                return p;
            }
            if (sqlTypeName == "float")
            {
                DoubleFieldProperty p = new DoubleFieldProperty();
                return p;
            }
            return null;
        }
        /// <summary>
        /// L^CvɑΉK؂ȃ^CvFieldProperty𐶐B
        /// </summary>
        /// <param name="type">^Cv</param>
        /// <returns>SQL^CvɑΉK؂ȃ^CvFieldProperty</returns>
        public static FieldProperty NewInstance(Type type)
        {

            if (type == typeof(int) )
            {
                IntFieldProperty p = new IntFieldProperty();
                return p;
            }
            if (type == typeof(long))
            {
                LongFieldProperty p = new LongFieldProperty();
                return p;
            }
            if (type == typeof(byte))
            {
                ByteFieldProperty p = new ByteFieldProperty();
                return p;
            }
            if (type == typeof(short))
            {
                ShortFieldProperty p = new ShortFieldProperty();
                return p;
            }
            if (type == typeof(string))
            {
                StringFieldProperty p = new StringFieldProperty();
                return p;
            }
            if (type == typeof(decimal))
            {
                DecimalFieldProperty p = new DecimalFieldProperty();
                return p;
            }
            if (type == typeof(float))
            {
                FloatFieldProperty p = new FloatFieldProperty();
                return p;
            }
            if (type == typeof(double))
            {
                DoubleFieldProperty p = new DoubleFieldProperty();
                return p;
            }
            if (type == typeof(DateTime))
            {
                DateFieldProperty p = new DateFieldProperty();
                return p;
            }
            return null;
        }
        /// <summary>
        /// sp_columnšʂFieldProperty𐶐
        /// </summary>
        /// <param name="row">sp_columnšʂ1s</param>
        /// <returns>sp_columns̒`ɂFieldProperty</returns>
        public static FieldProperty NewInstance(DataRow row)
        {
            string sqlTypeName = row["TYPE_NAME"].ToString();
            FieldProperty p = NewInstance(sqlTypeName);
            if (p != null)
            {
                p.setup(sqlTypeName,
                    row["TABLE_NAME"].ToString(),
                    row["COLUMN_NAME"].ToString(),
                    "",
                    NumberUtil.IntValue(row["LENGTH"].ToString()),
                    NumberUtil.IntValue(row["PRECISION"].ToString()),
                    NumberUtil.IntValue(row["SCALE"].ToString()),
                    NumberUtil.BoolValue(row["NULLABLE"].ToString()),
                    ParseDefault(row["COLUMN_DEF"]),
                    false
                );

            }
            return p;
        }
        /// <summary>
        /// KvȑFieldProperty𐶐
        /// </summary>
        /// <param name="sqlTypeName">SQL^Cv</param>
        /// <param name="tableName">e[u</param>
        /// <param name="columnName"></param>
        /// <param name="displayName">\</param>
        /// <param name="length"></param>
        /// <param name="prec">L</param>
        /// <param name="scale">x</param>
        /// <param name="nullable">null</param>
        /// <param name="columnDef">ftHgl</param>
        /// <param name="isPrimaryKey">L[</param>
        /// <returns>FieldProeprty</returns>
        public static FieldProperty NewInstance(string sqlTypeName, string tableName, string columnName, string displayName, int length, int prec, int scale, bool nullable, object columnDef, bool isPrimaryKey)
        {
            FieldProperty p = NewInstance(sqlTypeName);
            if (p != null)
            {
                p.TableName = tableName;
                p.FieldName = columnName;
                p.DisplayName = displayName;
                p.IsNullable = nullable;
                p.IsPrimaryKey = isPrimaryKey;
                if (p is StringFieldProperty || p is DecimalFieldProperty)
                {
                    p.setSize(length, prec, scale);
                }
                p.DefaultValue = columnDef;

            }
            return p;
        }
        /// <summary>
        /// vpeBݒ
        /// </summary>
        /// <param name="aProperty">ΏۃvpeB</param>
        /// <param name="tableName">e[u</param>
        /// <param name="columnName"></param>
        /// <param name="displayName">\</param>
        /// <param name="length"></param>
        /// <param name="prec">L</param>
        /// <param name="scale">x</param>
        /// <param name="nullable">null</param>
        /// <param name="columnDef">ftHg</param>
        /// <param name="isPrimaryKey">L[</param>
        public static void SetFieldProperty(FieldProperty aProperty, string tableName, string columnName, string displayName, int length, int prec, int scale, bool nullable, object columnDef, bool isPrimaryKey)
        {
            aProperty.FieldName = columnName;
            aProperty.TableName = tableName;

            aProperty.Length = length;
            aProperty.Precision = prec;
            aProperty.Scale = scale;

            aProperty.IsNullable = nullable;

            aProperty.DefaultValue = columnDef;

            aProperty.IsPrimaryKey = isPrimaryKey;
            aProperty.DisplayName = displayName;


        }

        /// <summary>
        /// \L̃ftHgliSQLT[o[L@)Ή^̃^Cvłɕϊ
        /// </summary>
        /// <param name="o">ftHg\L</param>
        /// <returns></returns>
        public static object ParseDefault(object o)
        {

            if (o == null)
            {
                return null;
            }
            string s = StringUtil.StringValue(o);
            if (s == "")
            {
                return null;
            }
            string ss = s;
            if (ss.StartsWith("(") && ss.EndsWith(")"))
            {
                ss = ss.Substring(1, ss.Length - 2);
            }
            //SQL2005H"("dĂB
            if (ss.StartsWith("(") && ss.EndsWith(")"))
            {
                ss = ss.Substring(1, ss.Length - 2);
            }
            if (ss == "null")
            {
                return null;
            }

            if (DefaultIsValue(ss))
            {
                if (ss.StartsWith("(") && ss.EndsWith(")"))
                {
                    ss = ss.Substring(1, ss.Length - 2);
                }
                if (ss.StartsWith("'") && ss.EndsWith("'"))
                {
                    ss = ss.Substring(1, ss.Length - 2);
                }

                return ss;
            }
            else
            {
                return ss;
            }
        }

        /// <summary>
        /// default֐\ۂ
        /// </summary>
        /// <returns></returns>
        public static bool DefaultIsValue(object o)
        {
            if (o == null) return true;
            string s = o.ToString();

            if (s.StartsWith("'") && s.EndsWith("'")) //string̎Ȃ
            {
                return true;
            }

            if (s.IndexOf("(") < 0) return true;

            return false;
        }


        /// <summary>
        /// SQL^CvɑΉSqlDbType enum̒lԂ
        /// </summary>
        /// <returns>SQL^CvɑΉSqlDbType enum</returns>
        public DbType SqlType()
        {
            
            
            if (sqlTypeName == "int")
            {
                return DbType.Int32;
            }
            if (sqlTypeName == "bigint")
            {
                return DbType.Int64;
            }
            if (sqlTypeName == "long")
            {
                return DbType.Int64;
            }
            if (sqlTypeName == "byte")
            {
                return DbType.Byte;
            }
            if (sqlTypeName == "tinyint")
            {
                return DbType.Byte;
            }
            if (sqlTypeName == "smallint")
            {
                return DbType.Int16;
            }
            if (sqlTypeName == "short")
            {
                return DbType.Int16;
            }
            if (sqlTypeName == "varchar")
            {
                return DbType.String;
            }
            if (sqlTypeName == "nvarchar")
            {
                return DbType.String;
            }
            if (sqlTypeName == "char")
            {
                return DbType.StringFixedLength;
            }
            if (sqlTypeName == "nchar")
            {
                return DbType.StringFixedLength;
            }
            if (sqlTypeName == "decimal")
            {
                return DbType.Decimal;
            }
            if (sqlTypeName == "money")
            {
                return DbType.Decimal;
            }
            if (sqlTypeName == "float")
            {
                return DbType.Double;
            }
            if (sqlTypeName == "real")
            {
                return DbType.Single;
            }
            if (sqlTypeName == "datetime")
            {
                return DbType.DateTime;
            }
            if (sqlTypeName == "smalldatetime")
            {
                return DbType.DateTime;
            }
            return DbType.String;
        }
        /// <summary>
        /// ő咷
        /// </summary>
        /// <returns>ő͒</returns>
        public virtual int MaxLength
        {
            get { return Precision; }
            set { this.Precision = value; }
        }
        /// <summary>
        /// ftHgl
        /// </summary>
        /// <returns>ftHgl</returns>
        public virtual string DefaultValueDisplay()
        {
            return string.Empty;
        }
        /// <summary>
        /// ̗̃t
        /// </summary>
        /// <returns></returns>
        public string FullName()
        {
            return this.TableName + "." + this.FieldName;
        }
        /// <summary>
        /// ̗̕ʖ
        /// </summary>
        /// <returns></returns>
        public string Alias()
        {
            return this.TableName + "__" + this.FieldName;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public virtual object Clone()
        {
            return null; //NXłgȂ
        }
    }

}
