using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Xml;
using System.Diagnostics;

namespace OFW.ErrorHandler
{
    /// <summary>
    /// ʃG[nh[̒
    /// </summary>
    /// <remarks>ۃG[nh[`ƂȂNX
    /// <br />Ǝ̃G[nhOKvȗO͑Ήnh[쐬B
    /// <br />nh[̖[:dac.adc.common.(ONX)Handler
    /// </remarks>
    public abstract class ErrorMessageBuilder
    {
        /// <summary>
        /// nh[O
        /// </summary>
        protected internal Exception mException;

        /// <summary>
        /// gĂ郆[U[
        /// </summary>
        protected internal OFW.Auth.IUser currentUser = null;


        /// <summary>
        /// ErrorHandler 
        /// \z O璼ڐȂ
        /// </summary>
        protected internal ErrorMessageBuilder()
        {

        }
        /// <summary>
        /// bZ[W擾
        /// </summary>
        /// <returns></returns>
        public string GetMessage()
        {
            return mException.Message;
        }
        /// <summary>
        /// ہF\bZ[Wgݗ
        /// </summary>
        /// <returns>OɑΉ郁bZ[W</returns>
        public abstract string BuildMessage();
        /// <summary>
        /// Oo͗pbZ[W̑gݗ
        /// </summary>
        /// <returns>Oo͗pɑgݗĂꂽbZ[W</returns>
        public abstract string BuildLogMessage();
        /// <summary>
        /// Oɏo
        /// </summary>
        public virtual void WriteLog()
        {
            WriteLog(2);
        }
        /// <summary>
        /// Oɏo
        /// </summary>
        /// <param name="frame">Ăяõt[B</param>
        public virtual void WriteLog(int frame)
        {
            try
            {
                //̃\bh(WriteLog)Ăяo\bhoB
                StackFrame sf = new StackFrame(frame, true);
                //̃\bh(WriteLog)Ăяo\bh̒`NXÔƂB

                StringBuilder messageBuilder = new StringBuilder();
                messageBuilder.AppendLine("Exception:" + mException.GetType().Name);
                messageBuilder.AppendLine(BuildLogMessage());
                messageBuilder.AppendLine("StackTrace:" + Environment.NewLine + mException.StackTrace);

                //TODO:g[XxƂ
                if (this.mException.InnerException != null)
                {
                    messageBuilder.AppendLine(this.mException.InnerException.Message);
                    messageBuilder.AppendLine("StackTrace:");
                    messageBuilder.AppendLine(this.mException.InnerException.StackTrace);


                }

                Config.LogConfigSettingSection section = (Config.LogConfigSettingSection)Config.ConfigFactory.GetConfig().GetSection("log");
                foreach (Config.LogConfigSettingElement el in section.LogConfigs)
                {
                    OFW.Log.Logger logger = OFW.Log.LoggerFactory.GetLogger(el.Name, sf.GetMethod().DeclaringType.Name); //fullname͂ɒ
                    logger.Error(this.currentUser, sf.GetMethod().Name, messageBuilder.ToString());
                }
            }
            catch { }

        }
        /// <summary>
        /// O̓eXmlNodegݗĂĕԂB
        /// SoapException#Defailɐݒ肷邽
        /// </summary>
        /// <returns>O̓egݗĂXmlNode</returns>
        public virtual XmlNode BuildMessageAsXmlNode()
        {
            // Build the detail element of the SOAP fault.
            System.Xml.XmlDocument doc = new System.Xml.XmlDocument();
            System.Xml.XmlElement root = doc.CreateElement("exception");

            System.Xml.XmlElement typeElement = doc.CreateElement("type");
            System.Xml.XmlText typeText = doc.CreateTextNode(this.mException.GetType().FullName);
            typeElement.AppendChild(typeText);
            root.AppendChild(typeElement);

            System.Xml.XmlElement messageElement = doc.CreateElement("message");
            System.Xml.XmlCDataSection messageContent = doc.CreateCDataSection(this.BuildMessage());
            messageElement.AppendChild(messageContent);
            root.AppendChild(messageElement);

            System.Xml.XmlElement stackTraceElement = doc.CreateElement("stackTrace");
            System.Xml.XmlCDataSection stackTraceContent = doc.CreateCDataSection(this.mException.StackTrace);
            stackTraceElement.AppendChild(stackTraceContent);
            root.AppendChild(stackTraceElement);

            return root;
        }
        /// <summary>
        /// O̓eXmlNodegݗĂĕԂB
        /// SoapException#Defailɐݒ肷邽
        /// </summary>
        /// <param name="doc">ɂXMLhLg</param>
        /// <returns>O̓egݗĂXmlNode</returns>
        public virtual XmlNode BuildMessageAsXmlNode(System.Xml.XmlDocument doc)
        {
            // Build the detail element of the SOAP fault.
            System.Xml.XmlElement root = doc.CreateElement("exception");

            //Õ^Cv
            System.Xml.XmlElement typeElement = doc.CreateElement("type");
            System.Xml.XmlText typeText = doc.CreateTextNode(this.mException.GetType().FullName);
            typeElement.AppendChild(typeText);
            root.AppendChild(typeElement);

            //ÕbZ[W
            System.Xml.XmlElement messageElement = doc.CreateElement("message");
            System.Xml.XmlCDataSection messageContent = doc.CreateCDataSection(this.BuildMessage());
            messageElement.AppendChild(messageContent);
            root.AppendChild(messageElement);

            //X^bNg[X
            System.Xml.XmlElement stackTraceElement = doc.CreateElement("stackTrace");
            System.Xml.XmlCDataSection stackTraceContent = doc.CreateCDataSection(this.mException.StackTrace);
            stackTraceElement.AppendChild(stackTraceContent);
            root.AppendChild(stackTraceElement);

            //[U[
            System.Xml.XmlElement currentUserElement = doc.CreateElement("currentUser");
            if (this.currentUser != null)
            {
                System.Xml.XmlText currentUserText = doc.CreateTextNode(this.currentUser.Name);
                currentUserElement.AppendChild(currentUserText);
            }
            root.AppendChild(currentUserElement);



            return root;
        }


    }

    /// <summary>
    /// ftHg̃G[nh[
    /// </summary>
    /// <remarks>nꂽOSystem.ExceptionƂĈ</remarks>
    public class DefaultErrorMessageBuilder : ErrorMessageBuilder
    {
        /// <summary>
        /// bZ[Wgݗ
        /// </summary>
        /// <returns>gݗĂbZ[W</returns>
        /// <remarks>System.Exceptionȏ͕̏sȂ̂Messagê݂Ԃ</remarks>
        public override string BuildMessage()
        {
            try
            {
                return this.mException.Message;
            }
            catch
            {
                return "error";
            }
        }

        /// <summary>
        /// ObZ[W쐬
        /// </summary>
        /// <returns></returns>
        public override string BuildLogMessage()
        {
            return mException.Message;
        }
    }
    /// <summary>
    /// SQLł̃G[nh[
    /// </summary>
    /// <remarks>SQLł̃G[ʂł悤SQLSTATE,ERROR NUMBERȂǂ\AOɏo</remarks>
    public class SqlExceptionMessageBuilder : ErrorMessageBuilder
    {
        /// <summary>
        /// G[̎
        /// </summary>
        public enum ErrorKindEnum
        {
            /// <summary>
            /// L[NQ
            /// </summary>
            PrimaryKeyDuplicated = 2627,
            /// <summary>
            /// Ӑᔽ
            /// </summary>
            UniqueIndexDuplicated = 2601
        }
        /// <summary>
        /// bZ[Wgݗ
        /// </summary>
        /// <returns>gݗĂbZ[W</returns>
        /// <remarks>SQLSTATE,ErrorCodeȂǏڍׂȏgݗĂB</remarks>
        public override string BuildMessage()
        {
            return BuildShortMessage();
        }
        /// <summary>
        /// bZ[W쐬
        /// </summary>
        /// <returns></returns>
        private string BuildShortMessage()
        {
            //            string msg = "";
            StringBuilder msgBuilder = new StringBuilder();
            //SQLG[ɃLXg
            SqlException sqlEx = (SqlException)mException;
            //Kvȏgݗ
            //1){̏
            msgBuilder.Append("SQL O " + sqlEx.Message + Environment.NewLine);
            msgBuilder.Append("SERVER=" + sqlEx.Server);

            msgBuilder.Append(" STATE=" + sqlEx.State);
            msgBuilder.Append(" CODE=" + sqlEx.ErrorCode);
            msgBuilder.Append(" NUMBER =" + sqlEx.Number);
            msgBuilder.Append(" AT " + sqlEx.Procedure + " LINE =" + sqlEx.LineNumber.ToString() + Environment.NewLine);

            msgBuilder.Append(sqlEx.Message + Environment.NewLine);

            return msgBuilder.ToString();
        }
        /// <summary>
        /// G[
        /// </summary>
        /// <param name="kind"></param>
        /// <returns></returns>
        public bool HasError(ErrorKindEnum kind)
        {

            //SQLG[ɃLXg
            SqlException sqlEx = (SqlException)mException;
            foreach (SqlError err in sqlEx.Errors)
            {
                if (err.Number == (int)kind)
                {
                    return true;
                }
            }
            return false;
        }
        /// <summary>
        /// FullbZ[W쐬
        /// </summary>
        /// <returns></returns>
        private string BuildFullMessage()
        {
            string msg = "";
            StringBuilder msgBuilder = new StringBuilder();
            //SQLG[ɃLXg
            SqlException sqlEx = (SqlException)mException;
            //Kvȏgݗ
            //1){̏
            msgBuilder.Append(BuildShortMessage());
            msgBuilder.Append(Environment.NewLine);


            //ꍇ͑Slߍ
            if (sqlEx.Errors.Count > 1)
            {
                msgBuilder.Append("Messages following:" + Environment.NewLine);
                int i = 1;
                for (i = 1; i < sqlEx.Errors.Count; i++) //2ڂB
                {
                    SqlError err = sqlEx.Errors[i];

                    msgBuilder.Append("SERVER=" + err.Server);

                    msgBuilder.Append(" STATE=" + err.State);
                    msgBuilder.Append(" CLASS=" + err.Class);
                    msgBuilder.Append(" NUMBER =" + err.Number);
                    msgBuilder.Append(" AT " + err.Procedure + " LINE =" + err.LineNumber + Environment.NewLine);

                    msgBuilder.Append(sqlEx.Message + Environment.NewLine);
                    if (i > 10) break;
                }
            }
            msgBuilder.Append(Environment.NewLine);
            msg = msgBuilder.ToString();
            return msg;
        }
        /// <summary>
        /// ObZ[W쐬iI[o[Chj
        /// </summary>
        /// <returns></returns>
        public override string BuildLogMessage()
        {
            return BuildFullMessage();
        }
        /// <summary>
        /// O̓eXmlNodegݗĂĕԂB
        /// SoapException#Defailɐݒ肷邽
        /// </summary>
        /// <returns>O̓egݗĂXmlNode</returns>
        public override XmlNode BuildMessageAsXmlNode()
        {
            // Build the detail element of the SOAP fault.
            System.Xml.XmlDocument doc = new System.Xml.XmlDocument();
            System.Xml.XmlElement root = doc.CreateElement("exception");

            System.Xml.XmlElement typeElement = doc.CreateElement("type");
            System.Xml.XmlText typeText = doc.CreateTextNode(this.mException.GetType().FullName);
            typeElement.AppendChild(typeText);
            root.AppendChild(typeElement);

            System.Xml.XmlElement messageElement = doc.CreateElement("message");
            System.Xml.XmlCDataSection messageContent = doc.CreateCDataSection(this.BuildMessage());
            messageElement.AppendChild(messageContent);
            root.AppendChild(messageElement);

            System.Xml.XmlElement stackTraceElement = doc.CreateElement("stackTrace");
            System.Xml.XmlCDataSection stackTraceContent = doc.CreateCDataSection(this.mException.StackTrace);
            stackTraceElement.AppendChild(stackTraceContent);
            root.AppendChild(stackTraceElement);

            //[U[
            System.Xml.XmlElement currentUserElement = doc.CreateElement("currentUser");
            if (this.currentUser != null)
            {
                System.Xml.XmlText currentUserText = doc.CreateTextNode(this.currentUser.Name);
                currentUserElement.AppendChild(currentUserText);
            }
            root.AppendChild(currentUserElement);

            return root;
        }
    }
    /// <summary>
    /// [Tv]
    /// InvalidCastExceptioñG[nh[
    /// </summary>
    public class InvalidCastExceptionMessageBuilder : ErrorMessageBuilder
    {
        /// <summary>
        /// bZ[Wgݗ
        /// </summary>
        /// <returns>gݗĂbZ[W</returns>
        /// <remarks>eException.Messagê</remarks>
        public override string BuildMessage()
        {
            string msg = "";
            StringBuilder msgBuilder = new StringBuilder();
            //SQLG[ɃLXg
            InvalidCastException ex = (InvalidCastException)mException;
            //Kvȏgݗ
            //1){̏
            msgBuilder.Append("INVALID CAST EXCEPTION ");
            msgBuilder.Append(" " + ex.Message + "\r\n");

            msg = msgBuilder.ToString();
            return msg;
        }
        /// <summary>
        /// ObZ[Wgݗ
        /// </summary>
        /// <returns></returns>
        public override string BuildLogMessage()
        {
            return BuildMessage();
        }
    }
    /// <summary>
    /// [Tv]
    /// FormatExceptioñG[nh[
    /// Int32.ParseȂǂŎsꍇ
    /// </summary>
    public class FormatExceptionMessageBuilder : ErrorMessageBuilder
    {
        /// <summary>
        /// bZ[Wgݗ
        /// </summary>
        /// <returns>gݗĂbZ[W</returns>
        /// <remarks>eException.Messagê</remarks>
        public override string BuildMessage()
        {

            string msg = "";
            StringBuilder msgBuilder = new StringBuilder();
            //SQLG[ɃLXg
            FormatException ex = (FormatException)mException;
            //Kvȏgݗ
            //1){̏
            msgBuilder.Append(" FORMAT EXCEPTION ");
            msgBuilder.Append(" " + ex.Message + "\r\n");

            msg = msgBuilder.ToString();
            return msg;
        }
        /// <summary>
        /// Oo͗pbZ[Wgݗ
        /// </summary>
        /// <returns></returns>
        public override string BuildLogMessage()
        {
            return BuildMessage();
        }
    }
}
