using System;
using System.Collections.Generic;
using System.Text;
using System.Configuration;
using System.IO;
using System.Reflection;
namespace OFW.Config
{
    /// <summary>
    /// RtBO
    /// </summary>
    public class ConfigFactory
    {
        static Dictionary<string, ConfigFile> configs = new Dictionary<string,ConfigFile>();
        /// <summary>
        /// ftHg̐ݒIuWFNg𐶐B
        /// {Iɂapp.configweb.config
        /// </summary>
        /// <returns></returns>
        public static ConfigFile GetConfig()
        {
            return GetConfig("app.config"); 
        }
        /// <summary>
        /// w薼̂̐ݒIuWFNg𐶐
        /// </summary>
        /// <param name="name">ݒ薼</param>
        /// <returns></returns>
        public static ConfigFile GetConfig(string name)
        {
            //ɃCX^X݂΂̃CX^XԂ
            if (configs.ContainsKey(name))
            {
                return configs[name];
            }

            if (name == "app.config")
            {   
                DefaultConfig defaultConfig = new DefaultConfig();
                if (defaultConfig.GetAppSettingString("common.config") != null)
                {
                    defaultConfig.commonConfig = OpenConfigFile("", defaultConfig.GetAppSettingString("common.config"));
                }
                return defaultConfig;
            }

            ExtConfig config = new ExtConfig();
            config.config = GetBaseConfig(name);

            if (config.config.AppSettings.Settings["common.config"] != null)
            {
                config.commonConfig = OpenConfigFile("", config.config.AppSettings.Settings["common.config"].Value);
            }

            configs[name] = config;
            return config;

        }
        /// <summary>
        /// app.configJ
        /// </summary>
        /// <returns></returns>
        static Configuration OpenAppConfig()
        {
            Configuration conf = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
            return conf;

        }

        /// <summary>
        /// Oݒt@C̎擾
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        static Configuration GetBaseConfig(string name)
        {
            string appDir = Path.GetDirectoryName(Assembly.GetExecutingAssembly().GetModules()[0].FullyQualifiedName);

            Configuration config = GetBaseConfig(appDir, name);
            if (config != null) return config;

            config = GetBaseConfig(Directory.GetCurrentDirectory(), name);
            if (config != null) return config;

            config = GetBaseConfig("", name);
            if (config != null) return config;

            return null;

        }
        /// <summary>
        /// ̌pXTĐݒt@C擾
        /// </summary>
        /// <param name="basePath"></param>
        /// <param name="name"></param>
        /// <returns></returns>
        static Configuration GetBaseConfig(string basePath, string name)
        {

            //pXT
            Configuration config = OpenConfigFile(basePath, name);
            if (config != null) return config;

            //pX/config/T
            config = OpenConfigFile(Path.Combine(basePath, "config"), name);
            if (config != null) return config;

            //pX/../config/T
            config = OpenConfigFile(Path.Combine(basePath, "..\\config"), name);
            if (config != null) return config;
            return null;
        }
        /// <summary>
        /// \t@CJ
        /// </summary>
        /// <param name="basePath">pX</param>
        /// <param name="name">(hoge.configȂ)</param>
        /// <returns></returns>
        static Configuration OpenConfigFile(string basePath, string name)
        {
            string filePath = Path.Combine(basePath, name);
            if (!File.Exists(filePath))
            {
                return null;
            }

            ExeConfigurationFileMap map = new ExeConfigurationFileMap();
            map.ExeConfigFilename = filePath;
            Configuration conf = ConfigurationManager.OpenMappedExeConfiguration(map, ConfigurationUserLevel.None);
            return conf;
        }
    }
}
