using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace OFW.Windows.Forms.Adapters
{
    /// <summary>
    /// TreeView̃A_v^[
    /// </summary>
    public abstract class AbstractTreeViewAdapter
    {
        /// <summary>
        /// c[f[^̃ANZX
        /// </summary>
        protected OFW.Database.ITreeDataAccess dataAccess;
        /// <summary>
        /// c[r[{
        /// </summary>
        protected TreeView theView;
        /// <summary>
        /// [gm[h
        /// </summary>
        protected OFW.Models.ITreeNode root;
        /// <summary>
        /// 
        /// </summary>
        /// <param name="view"></param>
        public void Initialize(TreeView view)
        {
            this.theView = view;
            this.dataAccess = this.GetDataAccess();

            //root͂炩ߍĂB
            this.root = dataAccess.newNode();
            this.root.id = 0;
            this.root.name = this.GetRootName();
        }
        /// <summary>
        /// \
        /// </summary>
        /// <param name="node"></param>
        /// <param name="nodeData"></param>
        public void RenderNode(TreeNode node, OFW.Models.ITreeNode nodeData)
        {
            if (nodeData == null)
            {
                nodeData = GetRoot();
                node.Tag = nodeData;
                node.Text = nodeData.name;
            }
            else
            {
                node.Tag = nodeData;
                node.Text = nodeData.name;
            }
            List<OFW.Models.ITreeNode> children = dataAccess.findChildNodes(nodeData);
            node.Nodes.Clear();
            foreach (OFW.Models.ITreeNode child in children)
            {
                child.parent = nodeData;
                TreeNode newNode = new TreeNode();
                newNode.Text = child.name;
                newNode.Tag = child;
                node.Nodes.Add(newNode);
                if (child.hasChild)
                {
                    newNode.Nodes.Add("");
                }
                else
                {
                }
            }
        }
        /// <summary>
        /// VKm[h쐬
        /// </summary>
        /// <param name="targetNode"></param>
        public void NewNode(TreeNode targetNode)
        {
            OFW.Models.ITreeNode newNodeData = dataAccess.newNode();
            OFW.Models.ITreeNode nodeData = targetNode.Tag as OFW.Models.ITreeNode;
            if (nodeData != null)
            {
                newNodeData.parent = nodeData;

                ITreeNodeEditForm form = this.GetEditView();
                DialogResult result = form.Edit(newNodeData);
                if (result == DialogResult.OK)
                {
                    dataAccess.save(form.GetEditData());
                    RenderNode(targetNode, nodeData);
                }

            }

        }
        /// <summary>
        /// m[hҏW
        /// </summary>
        /// <param name="targetNode"></param>
        public void EditNode(TreeNode targetNode)
        {
            OFW.Models.ITreeNode nodeData = targetNode.Tag as OFW.Models.ITreeNode;

            if (nodeData != null)
            {
                if (nodeData.id == 0) return;

                ITreeNodeEditForm form = this.GetEditView();
                DialogResult result = form.Edit(nodeData);
                if (result == DialogResult.OK)
                {
                    dataAccess.save(form.GetEditData());
                    OFW.Models.ITreeNode parentnode = dataAccess.findOne(nodeData.parent);
                    RenderNode(targetNode.Parent, parentnode);
                }
            }

        }
        /// <summary>
        /// m[hۑ
        /// </summary>
        /// <param name="targetNode"></param>
        public void SaveNode(TreeNode targetNode)
        {
            OFW.Models.ITreeNode nodeData = targetNode.Tag as OFW.Models.ITreeNode;

            if (nodeData == null) return;
            dataAccess.save(nodeData);
        }
        /// <summary>
        /// m[h폜
        /// </summary>
        /// <param name="targetNode"></param>
        public void DeleteNode(TreeNode targetNode)
        {
            OFW.Models.ITreeNode nodeData = targetNode.Tag as OFW.Models.ITreeNode;
            if (nodeData.id == 0) return;

            dataAccess.delete(nodeData);

            if (nodeData.parent == null)
            {
                RenderNode(targetNode.Parent, this.GetRoot());
            }
            else
            {
                OFW.Models.ITreeNode parentnode = dataAccess.findOne(nodeData.parent);
                RenderNode(targetNode.Parent, parentnode);
            }
        }
        /// <summary>
        /// ̃A_v^[gĂf[^ANZX擾
        /// </summary>
        /// <returns></returns>
        public abstract OFW.Database.ITreeDataAccess GetDataAccess();
        /// <summary>
        /// ̃A_v^[̖O
        /// </summary>
        /// <returns></returns>
        public abstract string GetTitle();
        /// <summary>
        /// ǉj[
        /// </summary>
        /// <returns></returns>
        public abstract List<System.Windows.Forms.ToolStripMenuItem> GetExtendMenu();
        /// <summary>
        /// m[hҏWtH[擾
        /// </summary>
        /// <returns></returns>
        public abstract ITreeNodeEditForm GetEditView();
        /// <summary>
        /// [gm[h擾
        /// </summary>
        /// <returns></returns>
        public OFW.Models.ITreeNode GetRoot()
        {
            return this.root;
        }

        /// <summary>
        /// rootvf̖O߂B
        /// </summary>
        /// <returns>rootvf̖O</returns>
        public virtual string GetRootName()
        {
            return "root";
        }

    }
}
