using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using OFW.Models;

namespace OFW.Windows.Controls
{
    /// <summary>
    /// 񋓍ڃXg(Enumerations)IPȃWI{^̃Xg
    /// </summary>
    public partial class RadioButtonList : UserControl
    {
        Enumerations _baseList;
        private int _itemHeight;

        /// <summary>
        /// vf̍
        /// </summary>
        public int ItemHeight
        {
            get { return _itemHeight; }
            set { _itemHeight = value; }
        }
        private int _itemWidth;
        /// <summary>
        /// vf̕
        /// </summary>
        public int ItemWidth
        {
            get { return _itemWidth; }
            set { _itemWidth = value; }
        }

        private FlowDirection _flowDirection;
        /// <summary>
        /// vfׂ
        /// </summary>
        public FlowDirection FlowDirection
        {
            get { return _flowDirection; }
            set { _flowDirection = value; }
        }
        /// <summary>
        /// \z
        /// </summary>

        public RadioButtonList()
        {
            InitializeComponent();

        }
        /// <summary>
        /// Ilƕ\ẍׂ̃f[^\[XݒA擾B
        /// </summary>
        /// <remarks>^objectȂ̂͑̃Rg[Ƃ̐̂߂݂̂łāAEnumerationsw肵Ȃ΂ȂȂ</remarks>
        public object DataSource
        {
            get
            {
                return _baseList;
            }
            set
            {
                _baseList = value as Enumerations;
            }
        }

        private void RadioButtonList_Load(object sender, EventArgs e)
        {
            container.FlowDirection = _flowDirection;
        }
        /// <summary>
        /// \XV
        /// </summary>
        public override void Refresh()
        {
            InitializeControls();
        }
        /// <summary>
        /// Ilݒ肷
        /// </summary>
        /// <param name="value"></param>
        public void setValue(object value)
        {
            foreach (Control c in container.Controls)
            {
                RadioButton child = c as RadioButton;
                IEnumerationItem item = child.Tag as IEnumerationItem;

                child.Checked = false;
                if (item.idEqualsTo(value))
                {
                    child.Checked = true;
                    break;
                }
                else
                {
                }

            }


        }
        /// <summary>
        /// Il𓾂
        /// </summary>
        /// <returns></returns>
        public object getValue()
        {
            object value = null;
            foreach (Control c in container.Controls)
            {
                RadioButton child = c as RadioButton;
                if (child.Checked)
                {
                    IEnumerationItem item = child.Tag as IEnumerationItem;

                    value = item.Id;
                    break;//ȂȂ`FbNłȂ
                }
            }
            return value;
        }

        private void InitializeControls()
        {
            container.Controls.Clear();
            if (_baseList == null) return;
            foreach (object e in _baseList)
            {
                IEnumerationItem item = e as IEnumerationItem;
                if (item == null) continue;

                RadioButton c = new RadioButton();
                c.Text = item.Name;
                c.Checked = item.IsDefault;
                c.Tag = item;
                if (_itemHeight > 0)
                {
                    c.Height = _itemHeight;
                }
                if (_itemWidth > 0)
                {
                    c.Width = _itemWidth;
                }

                container.Controls.Add(c);
            }
        }
    }
}
