using System;
using System.Collections.Generic;
using System.Text;
using System.Web.Services.Protocols;

namespace OFW.Web.ErrorHandler
{
    /// <summary>
    /// SOAPO
    /// </summary>
    public class SoapErrorHandler
    {
        /// <summary>
        /// G[
        /// </summary>
        /// <param name="ex">NO</param>
        public void HandleError(Exception ex)
        {
            if (ex is SoapException)
            {
                System.Xml.XmlNode rootNode = ((SoapException)ex).Detail;
                //Detail"exception"vf=JX^OKv
                if (OFW.Util.XmlUtil.NodeExists(rootNode, "exception"))
                {
                    string exceptionType = OFW.Util.StringUtil.StringValue(OFW.Util.XmlUtil.GetText(rootNode, "exception/type"));
                    string message = OFW.Util.StringUtil.StringValue(OFW.Util.XmlUtil.GetText(rootNode, "exception/message"));

                    //̗OڑOȂ(܂WebServiceŃf[^x[XG[Ȃ)e擾ConnectionException蒼
                    if (exceptionType.Equals(typeof(OFW.Database.ConnectionException).FullName))
                    {
                        //̎_łłɃO͏Ă
                    }
                    else
                    {
                        OFW.ErrorHandler.ErrorMessageBuilder builder = OFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                        builder.WriteLog(3);
                    }
                }
                else
                {
                    OFW.ErrorHandler.ErrorMessageBuilder builder = OFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                    builder.WriteLog(3);
                }

            }
            else
            {
                OFW.ErrorHandler.ErrorMessageBuilder builder = OFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog(3);
            }

            //TODO:[ƂFX
        }

    }
}
