using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Configuration;
using System.Diagnostics;
using System.Diagnostics.CodeAnalysis;
using System.Drawing;
using System.Drawing.Design;
using System.Globalization;
using System.IO;
using System.Reflection;
using System.Security;
using System.Security.Permissions;
using System.Text;
using System.Web;
using System.Web.Configuration;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.Handlers;
using System.Web.Util;

namespace OFW.Web.Controls
{
    /// <summary>
    /// OX^CV[g荞݃}l[W
    /// </summary>
    [
   AspNetHostingPermission(SecurityAction.LinkDemand, Level = AspNetHostingPermissionLevel.Minimal),
   AspNetHostingPermission(SecurityAction.InheritanceDemand, Level = AspNetHostingPermissionLevel.Minimal),
   DefaultProperty("StyleSheets"),
   NonVisualControl(),
   ParseChildren(true),
   PersistChildren(false)
   ]
    public class StyleSheetManager : Control
    {
        private StyleSheetReferenceCollection _styleSheets;
        List<StyleSheetManagerProxy> _proxies;
        /// <summary>
        /// X^CV[gQƂւ̃Xg
        /// </summary>
        [
        Category("Behavior"),
        DefaultValue(null),
        PersistenceMode(PersistenceMode.InnerProperty),
        MergableProperty(false),
        ]
        public StyleSheetReferenceCollection StyleSheets
        {
            get
            {
                if (_styleSheets == null)
                {
                    _styleSheets = new StyleSheetReferenceCollection();
                }
                return _styleSheets;
            }
        }
        /// <summary>
        /// eRg[/ʃy[WɔzuꂽvLṼXg
        /// </summary>
        internal List<StyleSheetManagerProxy> Proxies
        {
            get
            {
                if (_proxies == null)
                {
                    _proxies = new List<StyleSheetManagerProxy>();
                }
                return _proxies;
            }
        }
        /// <summary>
        /// Rg[`
        /// </summary>
        /// <param name="writer"></param>
        public override void RenderControl(HtmlTextWriter writer)
        {
            List<StyleSheetReference> styleSheets = collectReferences();
            for (int i = 0; i < styleSheets.Count; i++)
            {
                StyleSheetReference r = styleSheets[i];
                string vpath = this.Page.ResolveUrl(r.Path);
                string tag = "<link rel=\"Stylesheet\" type=\"text/css\" href=\"" + vpath + "\" />";
                writer.Write(tag);
            }
            base.RenderControl(writer);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="e"></param>
        [SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers")]
        protected override void OnInit(EventArgs e)
        {
            base.OnInit(e);

            if (!DesignMode)
            {
                Page page = this.Page;
                StyleSheetManager existingInstance = StyleSheetManager.GetCurrent(page);

                if (existingInstance != null)
                {
                    throw new Exception("a");
                }
                page.Items[typeof(StyleSheetManager)] = this;

            }
        }
        /// <summary>
        /// ̃Rg[Ɋ܂܂X^CV[gQƂƃvLVɊ܂܂X^CQƂdȂXg𓾂
        /// </summary>
        /// <returns></returns>
        List<StyleSheetReference> collectReferences()
        {
            List<StyleSheetReference> list = new List<StyleSheetReference>();
            //base͂̂܂
            for (int i = 0; i < _styleSheets.Count; i++)
            {
                StyleSheetReference r = _styleSheets[i];
                list.Add(r);
            }
            //proxy͏d폜
            foreach (StyleSheetManagerProxy proxy in Proxies)
            {
                foreach(StyleSheetReference r in proxy.StyleSheets)
                {
                    if (list.FindIndex(delegate(StyleSheetReference rr) { return rr.Path == r.Path; }) < 0)
                    {
                        list.Add(r);
                    }
                }
            }
            return list;

        }
        /// <summary>
        /// ݑ݂B̃Rg[
        /// </summary>
        /// <param name="page"></param>
        /// <returns></returns>
        public static StyleSheetManager GetCurrent(Page page)
        {
            if (page == null)
            {
                throw new ArgumentNullException("page");
            }

            return page.Items[typeof(StyleSheetManager)] as StyleSheetManager;
        }
        /// <summary>
        /// vLVo^
        /// </summary>
        /// <param name="proxy"></param>
        public void RegisterProxy(StyleSheetManagerProxy proxy)
        {



            if (!Proxies.Contains(proxy))
            {
                Proxies.Add(proxy);
            }
        }

    }
}
