using System;
using System.Collections.Generic;
using System.Text;
using OFW.Util;
using OFW.Log;

namespace OFW.Log.LogServiceReference
{
    /// <summary>
    /// OT[rX̎Q
    /// </summary>
    public class LogServiceReference : OFW.Log.LogWriter
    {
        string url;
        string user;
        string password;
        LogService.LogService service;
        /// <summary>
        /// w肳ꂽݒ蕶ɂ肱̃IuWFNgB
        /// </summary>
        /// <param name="configString"></param>
        public override void Init(string configString)
        {
            string[] configs = configString.Split(';');
            foreach (string configElement in configs)
            {
                if (configElement.StartsWith("url"))
                {
                    string[] parts = configElement.Split('=');
                    this.url = parts[1];
                }
                else if (configElement.StartsWith("user"))
                {
                    string[] parts = configElement.Split('=');
                    this.user= parts[1];
                }
                else if (configElement.StartsWith("password"))
                {
                    string[] parts = configElement.Split('=');
                    this.password = parts[1];
                }

            }
        }
        /// <summary>
        /// ڑJ
        /// </summary>
        void Open()
        {
            service = new OFW.Log.LogServiceReference.LogService.LogService();
            service.Url = this.url;
            if (this.user != "")
            {
                service.Credentials = new System.Net.NetworkCredential(this.user , this.password);

            }
            service.CookieContainer = new System.Net.CookieContainer();
        }
        /// <summary>
        /// ڑ
        /// </summary>
        void Close()
        {
            service = null;
        }
        /// <summary>
        /// Oo
        /// </summary>
        /// <param name="level">o̓x</param>
        /// <param name="userId">[U[ID</param>
        /// <param name="moduleName">W[</param>
        /// <param name="methodName">\bh</param>
        /// <param name="message">ǉbZ[W</param>
        public override void Write(LogLevel level, string userId, string moduleName, string methodName, string message)
        {
            this.Open();
            service.Write((OFW.Log.LogServiceReference.LogService.LogLevel)level, userId,moduleName,methodName, message);
            this.Close();
        }
        public override void WriteCaptured(IEnumerable<LogCaptureItem> items)
        {
            List<string> batch = new List<string>();
            OFW.Serializer.JSONSerializer serializer = new OFW.Serializer.JSONSerializer(typeof(LogCaptureItem));

            foreach (LogCaptureItem item in items)
            {
                string batchItem = serializer.Serialize(item);
                batch.Add(batchItem);
            }

            this.Open();
            service.WriteBatch(batch.ToArray());
            this.Close();
        }
    }
}
