using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Net.Configuration;
using System.Net.Mail;
using System.Diagnostics;
using System.Configuration;
using System.Xml;
using System.Collections;
using System.IO;
using OFW.Config;
namespace OFW.ErrorMail
{
    /// <summary>
    /// ftHg̃G[[łB
    /// </summary>
    class DefaultErrorMail
    {
        /// <summary>
        /// ftHgFromAhXłB
        /// </summary>
        private static readonly MailAddress defaultFrom = new MailAddress("alert-owner@admarketplace.co.jp", "VXeG[I", Encoding.GetEncoding("iso-2022-jp"));

        /// <summary>
        /// ftHgToAhXłB
        /// </summary>
        private static readonly MailAddress defaultTo = new MailAddress("alert_adv@pj.admarketplace.co.jp");

        /// <summary>
        /// ftHgCcAhXłB
        /// </summary>
        private static readonly MailAddress defaultCc = new MailAddress("it_mobile@pj.admarketplace.co.jp");

        /// <summary>
        /// ftHǧłB
        /// </summary>
        private static readonly string defaultSubject = "AD-Visor NEXTFVXeG[";

        /// <summary>
        /// ftHg̖{łB
        /// </summary>
        private static readonly string defaultBody = "AD-Visor NEXTɂăVXeG[iob`G[j܂B";

        /// <summary>
        /// ftHgl[Iȍ\ZNV쐬܂B
        /// </summary>
        /// <returns>쐬ꂽ\ZNV</returns>
        public static ErrorMailSection MakeErrorMailSection()
        {
            ErrorMailSection section = new ErrorMailSection();
            section.From = defaultFrom;
            section.To.Add(defaultTo);
            section.CC.Add(defaultCc);
            section.Subject = defaultSubject;
            return section;
        }

        /// <summary>
        /// [bZ[W̃ftHg̖{쐬܂B
        /// </summary>
        /// <param name="comment">RgꍇAǉRg</param>
        /// <returns>쐬ꂽftHg̖{</returns>
        public static string MakeDefaultBody(string comment)
        {
            // {
            StringBuilder sb = new StringBuilder();
            sb.AppendLine(defaultBody);
            sb.AppendLine();

            // Rgꍇ̓Rgt
            if (comment != null && comment != string.Empty)
            {
                sb.AppendLine(comment);
                sb.AppendLine();
            }

            sb.AppendLine("T[o[: " + System.Environment.MachineName);
            sb.AppendLine("vO: " + System.Diagnostics.Process.GetCurrentProcess().ProcessName);
            sb.AppendLine(": " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
            sb.AppendLine();

            sb.AppendLine("[G[e]");

            return sb.ToString();
        }
    }

    /// <summary>
    /// G[ɑM郁[łB
    /// </summary>
    /// <remarks>
    /// G[[static\bhSendgpđMł܂B
    /// ẴNXCX^XKv͂܂B<br/>
    /// ̃NXgpꍇAAvP[V\t@C&lt;configuration&gt;&lt;configSections&gt;A
    /// &lt;system.net&gt;&lt;errorMail&gt;̐ݒ肪KvłB<br/>
    /// <font color="red"><b>&lt;errorMail&gt;͏ȗꍇAvOŒ̃ftHglgp܂A
    /// ͖{ԗp̒lł̂ŃeXg͐΂ɎgpAK&lt;errorMail&gt;LqĂB</b></font><br/>
    /// ݒe͈ȉ̂悤ɂȂ܂B
    /// <code>
    /// &lt;configSections&gt;
    /// @&lt;section name="errorMail" type="dac.adv.common.ErrorMailConfigurationHandler, ErrorMail"/&gt;
    /// &lt;/configSections&gt;
    /// &lt;system.net&gt;
    ///   &lt;mailSettings&gt;
    ///     &lt;smtp deliveryMethod="Network"&gt;
    ///       &lt;network host="smtp.nanika.com" defaultCredentials="false" userName="user" password="pass"/&gt;
    ///     &lt;/smtp&gt;
    ///   &lt;/mailSettings&gt;
    /// &lt;/system.net&gt;
    /// &lt;errorMail&gt;
    ///   &lt;address&gt;
    ///     &lt;from name="G[ʒm" address="system@nanika.com" /&gt;
    ///     &lt;to name="Ǘ" address="dareka@dokoka.com" /&gt;
    ///   &lt;/address&gt;
    ///   &lt;subject&gt;f[^A[JCuG[&lt;/subject&gt;
    ///   &lt;comment&gt;̃[̓eXgp̃[ł̂ŖĂB&lt;/comment&gt;
    /// &lt;/errorMail&gt;
    /// </code>
    /// &lt;configSections&gt;&lt;section&gt; - \t@Cnh`(ȉ̑̂܂܋Lq܂)<br/>
    /// @name - "errorMail"<br/>
    /// @type - "dac.adv.common.ErrorMailConfigurationHandler, ErrorMail"<br/>
    /// &lt;system.net&gt;&lt;mailSettings&gt;&lt;smtp&gt;&lt;network&gt;<br/>
    /// @host - SMTPT[o<br/>
    /// @defaultCredentials - "false"(F؏)<br/>
    /// @userName - SMTPT[o[OC[U<br/>
    /// @password - SMTPT[o[OCpX[h<br/>
    /// &lt;errorMail&gt;<br/>
    /// @&lt;address&gt; - AhX<br/>
    /// @@&lt;from&gt;<br/>
    /// @@@name - FromAhX\<br/>
    /// @@@address - FromAhX<br/>
    /// @@&lt;to&gt;<br/>
    /// @@@name - ToAhX\<br/>
    /// @@@address - ToAhX<br/>
    /// &lt;subject&gt; - <br/>
    /// &lt;comment&gt; - {Rg<br/>
    /// </remarks>
    /// <example>
    /// <code>
    /// try
    /// {
    ///     ...
    /// }
    /// catch (Exception e)
    /// {
    ///     // G[ɃG[[𑗐M
    ///     // ł͑M郁bZ[WO莩IɕҏWĂ
    ///     string message = ErrorMessage.FormatErrorMessage(e);
    ///     ErrorMail.Send(message);
    /// }
    /// </code>
    /// </example>
    public class ErrorMail
    {
        /// <summary>
        /// G[[𑗐M܂B
        /// </summary>
        /// <param name="message">G[bZ[W</param>
        public static void Send(string message)
        {
            try
            {
                // App.configAcommon.config̍\t@CSMTPNCAg쐬A擾
                SmtpClient smtpClient = GetSmtpClient();

                // App.configAcommon.config̍\t@CAftHgl}[Wč\ZNV쐬
                ErrorMailSection configSection = MargeErrorMailSection();

                // [bZ[WҏW
                MailMessage mailMessage = new MailMessage();
                EditMailMessage(mailMessage, configSection, message);

                // [𑗐M
                smtpClient.Send(mailMessage);
            }
            catch (Exception e)
            {
                Trace.TraceWarning(e.ToString());
            }
        }

        /// <summary>
        /// SmtpClient擾܂B
        /// </summary>
        /// <returns>擾SmtpClient</returns>
        private static SmtpClient GetSmtpClient()
        {
            // ܂App.configɊÂftHgSmtpClient쐬
            SmtpClient smtpClient = new SmtpClient();

            // DeliveryMethodSpecifiedPickupDirectory̏ꍇPickupDirectoryLocationA
            // ȊO(NetworkPickupDirectoryFromIis)̏ꍇHost`FbN
            // App.configZbgĂ邩`FbN
            bool isDefault = true;
            if (smtpClient.DeliveryMethod == SmtpDeliveryMethod.SpecifiedPickupDirectory)
            {
                if (smtpClient.PickupDirectoryLocation == null || smtpClient.PickupDirectoryLocation == string.Empty)
                    isDefault = false;
            }
            else
            {
                if (smtpClient.Host == null || smtpClient.Host == string.Empty)
                    isDefault = false;
            }

            // App.configZbgĂȂꍇcommon.configZbg
            if (!isDefault)
            {
                ConfigFile configFile = ConfigFactory.GetConfig();
                Configuration config = configFile.GetCommonConfig();
                if (config != null)
                {
                    SmtpSection smtpSection = (SmtpSection)config.GetSection("system.net/mailSettings/smtp");
                    smtpClient.DeliveryMethod = smtpSection.DeliveryMethod;
                    smtpClient.Host = smtpSection.Network.Host;
                    smtpClient.Port = smtpSection.Network.Port;
                    smtpClient.UseDefaultCredentials = smtpSection.Network.DefaultCredentials;
                    smtpClient.Credentials = new NetworkCredential(smtpSection.Network.UserName, smtpSection.Network.Password);
                    smtpClient.PickupDirectoryLocation = smtpSection.SpecifiedPickupDirectory.PickupDirectoryLocation;
                }
            }

            return smtpClient;
        }

        /// <summary>
        /// [ҏWgݗĂ܂B
        /// </summary>
        /// <param name="mailMessage">ҏW郁[bZ[W</param>
        /// <param name="section">\ZNV</param>
        /// <param name="message">{ɒǉ郁bZ[W</param>
        private static void EditMailMessage(MailMessage mailMessage, ErrorMailSection section, string message)
        {
            // From̃Zbg
            mailMessage.From = section.From;

            // TõZbg
            for (int i = 0; i < section.To.Count; i++)
                mailMessage.To.Add(section.To[i]);

            // Cc̃Zbg
            for (int i = 0; i < section.CC.Count; i++)
                mailMessage.CC.Add(section.CC[i]);

            // Bcc̃Zbg
            for (int i = 0; i < section.Bcc.Count; i++)
                mailMessage.Bcc.Add(section.Bcc[i]);

            // Reply-TõZbg
            mailMessage.ReplyTo = section.ReplyTo;

            // Sender̃Zbg
            mailMessage.Sender = section.Sender;

            // Subject̃Zbg(Ƀ}Vǉ)
            mailMessage.Subject = "<" + System.Environment.MachineName + ">" + section.Subject;

            // ̕R[h
            mailMessage.SubjectEncoding = Encoding.GetEncoding("iso-2022-jp");

            // BodỹZbg
            // ftHg̖{
            string body = DefaultErrorMail.MakeDefaultBody(section.Comment);
            // {ւ̒ǉbZ[W
            body += message;

            // 7bitŃGR[h邽Bodył͂ȂAlternateViewgp
            mailMessage.Body = string.Empty;
            Encoding encoding = Encoding.GetEncoding("iso-2022-jp");
            byte[] buffer = encoding.GetBytes(body);
            AlternateView view = new AlternateView(new System.IO.MemoryStream(buffer), "text/plain; charset=iso-2022-jp");
            view.TransferEncoding = System.Net.Mime.TransferEncoding.SevenBit;
            mailMessage.AlternateViews.Add(view);
        }

        /// <summary>
        /// vÕftHglAApp.configAcommon.config̓e}[W
        /// G[[̍\ZNV擾܂B
        /// </summary>
        /// <returns>쐬ꂽG[[̍\ZNV</returns>
        private static ErrorMailSection MargeErrorMailSection()
        {
            // App.configErrorMailSection쐬
            ConfigFile configFile = ConfigFactory.GetConfig();
            Configuration appConfig = configFile.GetBaseConfig();
            ErrorMailSection appSection = new ErrorMailSection(appConfig);

            // common.configErrorMailSection쐬
            Configuration commonConfig = configFile.GetCommonConfig();
            ErrorMailSection commonSection = new ErrorMailSection(commonConfig);

            // vÕftHglErrorMailSection쐬
            ErrorMailSection defaultSection = DefaultErrorMail.MakeErrorMailSection();

            // [ɏ]Ċe\ZNV̓eappSectionɃ}[W
            // [͗D揇App.config->common.config->default̏Ń`FbN
            // ŏɑ݂eZbg
            // RNVłĂǉƂ͂Ȃ炸uɂȂ
            // ACcABccAReply-ToASenderACommentɊւĂ͕K{ڂł͂Ȃ
            // App.conigAcommon.configɃf[^ȂƂ݂Ȃꍇ(FromAhXToAhXȂꍇƂ)
            // defaultZbg邱ƂƂ

            bool isData = false;

            // From
            if (appSection.From == null)
                appSection.From = commonSection.From;
            if (appSection.From == null)
                appSection.From = defaultSection.From;
            else
                isData = true;

            // To
            if (appSection.To.Count == 0)
                appSection.To = commonSection.To;
            if (appSection.To.Count == 0)
                appSection.To = defaultSection.To;
            else
                isData = true;

            // Cc
            if (appSection.CC.Count == 0)
                appSection.CC = commonSection.CC;
            if (!isData && appSection.CC.Count == 0)
                appSection.CC = defaultSection.CC;

            // Bcc
            if (appSection.Bcc.Count == 0)
                appSection.Bcc = commonSection.Bcc;
            if (!isData && appSection.Bcc.Count == 0)
                appSection.Bcc = defaultSection.Bcc;

            // Reply-To
            if (appSection.ReplyTo == null)
                appSection.ReplyTo = commonSection.ReplyTo;
            if (!isData && appSection.ReplyTo == null)
                appSection.ReplyTo = defaultSection.ReplyTo;

            // Sender
            if (appSection.Sender == null)
                appSection.Sender = commonSection.Sender;
            if (!isData && appSection.Sender == null)
                appSection.Sender = defaultSection.Sender;

            // Subject
            if (appSection.Subject == null)
                appSection.Subject = commonSection.Subject;
            if (appSection.Subject == null)
                appSection.Subject = defaultSection.Subject;

            // Comment
            if (appSection.Comment == null)
                appSection.Comment = commonSection.Comment;
            if (!isData && appSection.Comment == null)
                appSection.Comment = defaultSection.Comment;

            return appSection;
        }
    }

    /// <summary>
    /// \t@C̃G[[\ZNV("errorMail")̃f[^NXłB
    /// </summary>
    public class ErrorMailSection
    {
        /// <summary>
        /// FromAhXłB
        /// </summary>
        public MailAddress From = null;

        /// <summary>
        /// ToAhX̃RNVłB
        /// </summary>
        public MailAddressCollection To = new MailAddressCollection();

        /// <summary>
        /// CcAhX̃RNVłB
        /// </summary>
        public MailAddressCollection CC = new MailAddressCollection();

        /// <summary>
        /// BccAhX̃RNVłB
        /// </summary>
        public MailAddressCollection Bcc = new MailAddressCollection();

        /// <summary>
        /// Reply-ToAhXłB
        /// </summary>
        public MailAddress ReplyTo = null;

        /// <summary>
        /// SenderAhXłB
        /// </summary>
        public MailAddress Sender = null;

        /// <summary>
        /// [̌łB
        /// </summary>
        public string Subject = null;

        /// <summary>
        /// [̖{ɑ}RgłB
        /// </summary>
        public string Comment = null;

        /// <summary>
        /// ̃NX̃ftHgRXgN^łB
        /// </summary>
        public ErrorMailSection()
        {
        }

        /// <summary>
        /// \t@Cw肵ẴNX̃CX^X܂B
        /// </summary>
        /// <param name="config">\t@C</param>
        public ErrorMailSection(Configuration config)
        {
            if (config == null)
                return;

            DefaultSection section = (DefaultSection)config.GetSection("errorMail");
            if (section == null)
                return;

            SetField(section);
        }

        /// <summary>
        /// \ZNVNX̊etB[hɒlZbg܂B
        /// </summary>
        /// <param name="section">\ZNV</param>
        private void SetField(DefaultSection section)
        {
            using (XmlReader reader = XmlReader.Create(new StringReader(section.SectionInformation.GetRawXml())))
            {
                while (reader.Read())
                {
                    if (reader.IsStartElement())
                    {
                        switch (reader.Name)
                        {
                            case "from":
                                From = MakeMailAddress(reader);
                                break;
                            case "to":
                                To.Add(MakeMailAddress(reader));
                                break;
                            case "cc":
                                CC.Add(MakeMailAddress(reader));
                                break;
                            case "bcc":
                                Bcc.Add(MakeMailAddress(reader));
                                break;
                            case "replyto":
                                ReplyTo = MakeMailAddress(reader);
                                break;
                            case "sender":
                                Sender = MakeMailAddress(reader);
                                break;
                            case "subject":
                                Subject = reader.ReadString();
                                break;
                            case "comment":
                                Comment = reader.ReadString().Replace('\r', '\n').Replace("\n\n", "\n").Trim(new char[] { '\n' }).Replace("\n", "\r\n");
                                break;
                        }
                    }
                }
            }
        }

        /// <summary>
        /// AhX\XML̃m[h烁[AhX쐬܂B
        /// </summary>
        /// <param name="reader">XML[_[</param>
        /// <returns>쐬ꂽ[AhX</returns>
        private MailAddress MakeMailAddress(XmlReader reader)
        {
            if (reader.GetAttribute("name") == null)
                return new MailAddress(reader.GetAttribute("address"));
            else
                return new MailAddress(reader.GetAttribute("address"), reader.GetAttribute("name"), Encoding.GetEncoding("iso-2022-jp"));
        }

        /// <summary>
        /// ̃NX̃tB[h̓e\Ԃ܂B
        /// </summary>
        /// <returns>tB[h̓e\</returns>
        public string ToStringField()
        {
            StringBuilder sb = new StringBuilder();

            AppendMailAddressToString("From", From, sb);
            AppendMailAddressCollectionToString("To", To, sb);
            AppendMailAddressCollectionToString("CC", CC, sb);
            AppendMailAddressCollectionToString("Bcc", Bcc, sb);
            AppendMailAddressToString("ReplyTo", ReplyTo, sb);
            AppendMailAddressToString("Sender", Sender, sb);
            sb.AppendLine("Subject: " + (Subject == null ? "null" : Subject));
            sb.AppendLine("Comment: " + (Comment == null ? "null" : Comment));

            return sb.ToString();
        }

        /// <summary>
        /// obt@Ƀ[AhX̓eǉ܂B
        /// </summary>
        /// <param name="fieldName">AhXtB[h̖</param>
        /// <param name="address">ǉAhX</param>
        /// <param name="sb">ǉ镶obt@</param>
        private void AppendMailAddressToString(string fieldName, MailAddress address, StringBuilder sb)
        {
            sb.Append(fieldName + ": ");
            if (address == null)
                sb.AppendLine("null");
            else
            {
                sb.Append("DisplayName=" + address.DisplayName);
                sb.AppendLine(", Address=" + address.Address);
            }
        }

        /// <summary>
        /// obt@Ƀ[AhXRNV̓eǉ܂B
        /// </summary>
        /// <param name="fieldName">AhXtB[h̖</param>
        /// <param name="addresses">ǉAhXRNV</param>
        /// <param name="sb">ǉ镶obt@</param>
        private void AppendMailAddressCollectionToString(string fieldName, MailAddressCollection addresses, StringBuilder sb)
        {
            sb.AppendLine(fieldName + ":");
            foreach (MailAddress address in addresses)
            {
                sb.Append("  DisplayName=" + address.DisplayName);
                sb.AppendLine(", Address=" + address.Address);
            }
        }
    }

    /// <summary>
    /// G[[̍\t@C̍\ZNṼnhłB
    /// </summary>
    /// <remarks>
    /// ̃NX͌ݍ\t@C̃ZNV`邽߂ɂ܂̂
    /// vOł͎gp܂B
    /// </remarks>
    public class ErrorMailConfigurationHandler : IConfigurationSectionHandler
    {
        /// <summary>
        /// \ZNVnh쐬܂B
        /// </summary>
        /// <param name="parent"></param>
        /// <param name="configContext">\ReLXg IuWFNg</param>
        /// <param name="section">쐬ꂽZNV nh IuWFNg</param>
        /// <returns></returns>
        public Object Create(Object parent, Object configContext, XmlNode section)
        {
            MailMessage message = new MailMessage();

            // Rg[̓ǂݍ

            // AhX
            XmlNode address = section.SelectNodes(@"/errorMail/address").Item(0);
            foreach (XmlNode node in address)
            {
                if (node.Attributes == null) continue;

                MailAddress mailAddress = null;
                if (node.Attributes["name"] == null)
                    mailAddress = new MailAddress(node.Attributes["address"].InnerText);
                else
                    mailAddress = new MailAddress(node.Attributes["address"].InnerText, node.Attributes["name"].InnerText, Encoding.GetEncoding("iso-2022-jp"));

                switch (node.Name)
                {
                    case "from":
                        message.From = mailAddress;
                        break;
                    case "to":
                        message.To.Add(mailAddress);
                        break;
                    case "cc":
                        message.CC.Add(mailAddress);
                        break;
                    case "bcc":
                        message.Bcc.Add(mailAddress);
                        break;
                    case "replyto":
                        message.ReplyTo = mailAddress;
                        break;
                    case "sender":
                        message.Sender = mailAddress;
                        break;
                }
            }

            // 
            XmlNode subject = section.SelectNodes(@"/errorMail/subject").Item(0);
            if (subject != null)
                message.Subject = subject.InnerText;

            // {Rg
            XmlNode comment = section.SelectNodes(@"/errorMail/comment").Item(0);
            if (comment != null)
                message.Body = comment.InnerText.Replace('\r', '\n').Replace("\n\n", "\n").Trim(new char[] { '\n' }).Replace("\n", "\r\n");

            return message;
        }
    }

    /// <summary>
    /// G[bZ[W쐬邽߂̃NXłB
    /// </summary>
    public class ErrorMessage
    {
        /// <summary>
        /// G[bZ[WgݗĂ܂B
        /// ɂKvȏ(bZ[WAX^bNg[X)Iɍ쐬܂B
        /// ܂SqlExceptionɂΉĂ܂B
        /// </summary>
        /// <param name="e">O</param>
        /// <returns>gݗĂG[bZ[W</returns>
        public static string FormatErrorMessage(Exception e)
        {
            string msg = e.GetType().ToString();
            msg += " " + e.Message;
            msg += "\r\nTargetSite=" + e.TargetSite;

            if (e.GetType() == typeof(System.Data.SqlClient.SqlException))
            {
                System.Data.SqlClient.SqlException sqlException = (System.Data.SqlClient.SqlException)e;

                msg += "\r\n\r\n[SQL Server]";
                msg += "\r\nErrorCode=" + sqlException.ErrorCode;

                for (int i = 0; i < sqlException.Errors.Count; i++)
                {
                    msg += "\r\n\r\n<< " + i + " >>";
                    msg += "\r\n  Source=" + sqlException.Errors[i].Source;
                    msg += "\r\n  Number=" + sqlException.Errors[i].Number;
                    msg += "\r\n  State=" + sqlException.Errors[i].State;
                    msg += "\r\n  Class=" + sqlException.Errors[i].Class;
                    msg += "\r\n  Server=" + sqlException.Errors[i].Server;
                    msg += "\r\n  Message=" + sqlException.Errors[i].Message;
                    msg += "\r\n  Procedure=" + sqlException.Errors[i].Procedure;
                    msg += "\r\n  LineNumber=" + sqlException.Errors[i].LineNumber;
                }
            }

            msg += "\r\n\r\n[StackTrace]\r\n" + e.StackTrace;
            return msg;
        }
    }
}
