using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using OFW.Database;
using OFW.Database.TableCommand;

namespace OFW.Database
{
    /// <summary>
    /// c[f[^̃ANZX
    /// </summary>
    /// <typeparam name="TEntity">GeBeB̌^</typeparam>
    /// <typeparam name="TProperty">vpeB̌^</typeparam>
    public class TreeDataAccess<TEntity, TProperty> : ITreeDataAccess
        where TEntity : OFW.Models.ITreeNode, OFW.Models.IEntity, new()
        where TProperty : OFW.Models.IEntityProperty, new()
    {
        /// <summary>
        /// f[^ڑ
        /// </summary>
        protected OFW.Database.Connection connection;
        /// <summary>
        /// Ώۂ̃e[uvpeB
        /// </summary>
        protected TProperty property;
        private int connectCounter;
        /// <summary>
        /// \z
        /// </summary>
        public TreeDataAccess()
        {
            this.property = new TProperty();
            connectCounter = 0;

        }
        /// <summary>
        /// \z
        /// </summary>
        public TreeDataAccess(Connection connection)
        {
            this.connection = connection;
            this.property = new TProperty();
            connectCounter = 1;

        }
        /// <summary>
        /// w肵OڑɐڑB
        /// </summary>
        /// <param name="names">ڑ̖O</param>
        protected void connect(params string[] names)
        {
            try
            {
                if (connectCounter == 0)
                {
                    connection = ConnectionFactory.GetConnectionByName(names);
                    connection.Open();
                }

            }
            finally
            {
                // connection MUST disconnect when each "finally" block,
                // so I prepare "connection stack" for disconnect.
                connectCounter++;
            }
        }
        /// <summary>
        /// ڑ
        /// </summary>
        protected void disconnect()
        {
            connectCounter--;
            if (connectCounter <= 0)
            {
                this.connection.Close();
            }
        }

        /// <summary>
        /// wm[hID̎qm[h擾
        /// </summary>
        /// <param name="parentNode">Ώۃm[h</param>
        /// <returns>wm[h̎qm[h̃Xg</returns>
        public List<TEntity> findChildNodes(TEntity parentNode)
        {
            try
            {
                List<TEntity> list = new List<TEntity>();
                this.connect();
                OFW.Database.Command command = this.createFindChildNodesCommand(parentNode);
                using (DataSet childSet = connection.ExecuteQuery(command))
                {
                    foreach(DataRow row in childSet.Tables[0].Rows)
                    {
                        TEntity child = new TEntity();
                        child.Map(row);
                        list.Add(child);
                    }
                }
                return list;

            }
            finally
            {
                this.disconnect();
            }
        }
        /// <summary>
        /// Ώۃm[h擾
        /// </summary>
        /// <param name="keySpec">擾L[i[m[h</param>
        /// <returns>Ώۃm[h</returns>
        public TEntity findOne(TEntity keySpec)
        {
            try
            {
                TEntity node = default(TEntity);
                this.connect();
                OFW.Database.Command command = this.createFindOneCommand(keySpec);
                using (DataSet childSet = connection.ExecuteQuery(command))
                {
                    foreach (DataRow row in childSet.Tables[0].Rows)
                    {
                        node = new TEntity();
                        node.Map(row);
                    }
                }
                return node;

            }
            finally
            {
                this.disconnect();
            }
        }
        /// <summary>
        /// SẴm[h擾
        /// </summary>
        /// <returns></returns>
        public List<TEntity> findAll()
        {
            try
            {
                List<TEntity> list = new List<TEntity>();
                this.connect();

                OFW.Database.Command command = this.createFindAllCommand();
                using (DataSet childSet = connection.ExecuteQuery(command))
                {
                    foreach (DataRow row in childSet.Tables[0].Rows)
                    {
                        TEntity child = new TEntity();
                        child.Map(row);
                        list.Add(child);
                    }
                }
                return list;

            }
            finally
            {
                this.disconnect();
            }
        }
        /// <summary>
        /// m[hۑ
        /// </summary>
        /// <param name="node"></param>
        /// <returns></returns>
        public int save(TEntity node)
        {
            try
            {
                this.connect();
                if (node.IsNew)
                {
                    return this.insert(node);

                }
                else
                {
                    return this.update(node);
                }
            }
            finally
            {
                this.disconnect();
            }
        }

        /// <summary>
        /// m[h̒ǉ
        /// 
        /// parentIdɐem[hIDݒ肷Kv
        /// </summary>
        /// <param name="node">ǉm[h</param>
        /// <returns>ǉ</returns>
        public int insert(TEntity node)
        {
            try
            {
                this.connect();
                setupId(ref node);

                OFW.Database.Command insertCommand = this.createInsertCommand(node);
                return this.connection.ExecuteUpdate(insertCommand);
            }
            finally
            {
                this.disconnect();
            }
        }
        /// <summary>
        /// ID
        /// </summary>
        /// <param name="node"></param>
        protected virtual void setupId(ref TEntity node)
        {
        }

        /// <summary>
        /// m[h̍XV(pX͂̂܂܂œeύX)
        /// </summary>
        /// <param name="node">XVm[h</param>
        /// <returns>XV</returns>
        public int update(TEntity node)
        {
            try
            {
                this.connect();
                OFW.Database.Command command = this.createUpdateCommand(node);
                return this.connection.ExecuteUpdate(command);
            }
            finally
            {
                this.disconnect();
            }
        }
        /// <summary>
        /// m[h̍폜
        /// </summary>
        /// <param name="node">폜m[h</param>
        /// <returns>폜</returns>
        public int delete(TEntity node)
        {
            try
            {
                this.connect();
                OFW.Database.Command command = this.createDeleteCommand(node);
                return this.connection.ExecuteUpdate(command);
            }
            finally
            {
                this.disconnect();
            }
        }
        /// <summary>
        /// 擾pcommand
        /// </summary>
        /// <returns>擾pcommand</returns>
        protected virtual OFW.Database.Command createFindAllCommand()
        {
            string query = @"SELECT parent.name AS parent_name, child.*
FROM [{0}] child
LEFT OUTER JOIN [{0}] parent
ON child.left_side >  parent.left_side and child.left_side < parent.right_side
AND parent.left_side = (SELECT MAX(left_side)
                          FROM [{0}]
                         WHERE child.left_side > left_side
                           AND child.left_side < right_side)
where child.deleted = 0
order by child.left_side";

            OFW.Database.Command command = new OFW.Database.Command(
                string.Format(query, this.property.EntityName),
                CommandType.Text
                );
            return command;

        }
        /// <summary>
        /// 擾pcommand
        /// </summary>
        /// <param name="keySpec">擾Ώ</param>
        /// <returns>擾pcommand</returns>
        protected virtual OFW.Database.Command createFindOneCommand(TEntity keySpec)
        {
            string query = @"SELECT parent.name AS parent_name, child.*
FROM [{0}] child
LEFT OUTER JOIN [{0}] parent
ON child.left_side >  parent.left_side and child.left_side < parent.right_side
AND parent.left_side = (SELECT MAX(left_side)
                          FROM [{0}]
                         WHERE child.left_side > left_side
                           AND child.left_side < right_side)

where child.id = @id
and  child.deleted = 0
";

            OFW.Database.Command command = new OFW.Database.Command(
                string.Format(query, this.property.EntityName),
                CommandType.Text
                );
            command.SetParameter(new OFW.Database.Parameter("@id", DbType.String, keySpec.id));
            return command;

        }
        /// <summary>
        /// qm[h擾pcommand
        /// </summary>
        /// <param name="parentNode">擾ΏID</param>
        /// <returns>qm[h擾pcommand</returns>
        protected virtual OFW.Database.Command createFindChildNodesCommand(TEntity parentNode)
        {
            string query = @"SELECT parent.name AS parent_name, child.*
FROM [{0}] child
LEFT OUTER JOIN [{0}] parent
ON child.left_side >  parent.left_side and child.left_side < parent.right_side
AND parent.left_side = (SELECT MAX(left_side)
                          FROM [{0}]
                         WHERE child.left_side > left_side
                           AND child.left_side < right_side)

where ((@id = 0 and parent.id is null ) or ( parent.id = @id and parent.deleted = 0) )
and  child.deleted = 0

order by child.left_side";

            OFW.Database.Command command = new OFW.Database.Command(
                string.Format(query, this.property.EntityName),
                CommandType.Text
                );
            if (parentNode == null)
            {
                command.SetParameter(new OFW.Database.Parameter("@id",DbType.Int32,0));
            }
            else
            {
                command.SetParameter(new OFW.Database.Parameter("@id", DbType.Int32, parentNode.id));
            }
            return command;
        }
        /// <summary>
        /// f[^}pcommand
        /// </summary>
        /// <param name="node">}m[h</param>
        /// <returns>f[^}pcommand</returns>
        protected virtual OFW.Database.Command createInsertCommand(TEntity node)
        {
            string q = @"
declare @r int;
if not exists( select * from [{0}] where name = @parent_name  )
begin
  select @r = max(right_side) + 1
  from [{0}]
end
else
begin
  select @r = right_side
  from [{0}]
  where [{0}].name = @parent_name;
end
UPDATE [{0}] SET right_side = right_side + 2 WHERE right_side >= @r;
UPDATE [{0}] SET left_side = left_side + 2 WHERE left_side >= @r;
if exists( select * from [{0}] where id = @id ) begin
    {1}
end
else begin
    {2}
end
";
            OFW.Database.TableCommand.TableInsertCommand insertCommandBuilder = createInsertCommandBuilder(node);
            OFW.Database.Command insertCommand = insertCommandBuilder.GetCommand();
            OFW.Database.TableCommand.TableUpdateCommand updateCommandBuilder = createUpdateCommandBuilder(node);
            OFW.Database.Command updateCommand = updateCommandBuilder.GetCommand();

            OFW.Database.Command command = new OFW.Database.Command(
                string.Format(q, this.property.EntityName, updateCommand.Text, insertCommand.Text),
                CommandType.Text
                );
            if (node.parent == null)
            {
                command.Parameters.Add(new Parameter("@parent_name", ""));
            }
            else
            {
                command.Parameters.Add(new Parameter("@parent_name", node.parent.name));
            }
            command.Parameters.AddRange(insertCommand.Parameters);

            return command;

        }
        /// <summary>
        /// InsertpR}h
        /// </summary>
        /// <param name="node"></param>
        /// <returns></returns>
        protected OFW.Database.TableCommand.TableInsertCommand createInsertCommandBuilder(TEntity node)
        {
            OFW.Database.TableCommand.TableInsertCommand commandBuilder = new OFW.Database.TableCommand.TableInsertCommand(this.property.EntityName);
            foreach (FieldProperties.FieldProperty p in property.Fields())
            {
                if (p.DoUpdate)
                {
                    if (p.FieldName == "left_side")
                    {
                        commandBuilder.AddInsert(new TableCommand.TableCommandColumn(p, "@r"));
                    }
                    else if (p.FieldName == "right_side")
                    {
                        commandBuilder.AddInsert(new TableCommand.TableCommandColumn(p, "@r + 1"));
                    }
                    else if (p.FieldName == "created_at")
                    {
                        commandBuilder.AddInsert(new TableCommand.TableCommandColumn(p, "getdate()"));
                    }
                    else if (p.FieldName == "modified_at")
                    {
                        commandBuilder.AddInsert(new TableCommand.TableCommandColumn(p, "getdate()"));
                    }
                    else
                    {
                        commandBuilder.AddInsert(p, node.GetValue(p.FieldName));
                    }
                }
            }
            return commandBuilder;
        }
        /// <summary>
        /// XVpR}h
        /// </summary>
        /// <param name="node"></param>
        /// <returns></returns>
        protected OFW.Database.TableCommand.TableUpdateCommand createUpdateCommandBuilder(TEntity node)
        {
            OFW.Database.TableCommand.TableUpdateCommand commandBuilder = new OFW.Database.TableCommand.TableUpdateCommand(this.property.EntityName);
            foreach (FieldProperties.FieldProperty p in property.Fields())
            {
                if (p.DoUpdate)
                {
                    if (p.FieldName == "left_side")
                    {
                        commandBuilder.AddUpdate(new TableCommand.TableCommandColumn(p, "@r"));
                    }
                    else if (p.FieldName == "right_side")
                    {
                        commandBuilder.AddUpdate(new TableCommand.TableCommandColumn(p, "@r + 1"));
                    }
                    else if (p.FieldName == "created_at")
                    {
                    }
                    else if (p.FieldName == "modified_at")
                    {
                        commandBuilder.AddUpdate(new TableCommand.TableCommandColumn(p, "getdate()"));
                    }
                    else if (p.FieldName == "deleted")
                    {
                        commandBuilder.AddUpdate(new TableCommand.TableCommandColumn(p, "0"));
                    }
                    else if (p.FieldName == "id")
                    {
                        commandBuilder.AddWhere(new ColumnValueCondition(p, "@" + p.FieldName, node.GetValue(p.FieldName), "="));
                    }
                    else
                    {
                        commandBuilder.AddUpdate(p, node.GetValue(p.FieldName));
                    }
                }
            }
            return commandBuilder;
        }
        /// <summary>
        /// f[^XVpcommand(c[\͂̂܂܂Ńf[^̒gXV)
        /// </summary>
        /// <param name="node">XVm[h</param>
        /// <returns>f[^XVpcommand</returns>
        public virtual OFW.Database.Command createUpdateCommand(TEntity node)
        {

            OFW.Database.TableCommand.TableUpdateCommand updateCommandBuilder = new OFW.Database.TableCommand.TableUpdateCommand(this.property.EntityName);
            foreach (FieldProperties.FieldProperty p in property.Fields())
            {
                if (p.DoUpdate)
                {
                    //left_sideright_side,created_at͖B
                    if (p.FieldName == "left_side")
                    {
                    }
                    else if (p.FieldName == "right_side")
                    {
                    }
                    else if (p.FieldName == "created_at")
                    {
                    }
                    else if (p.FieldName == "modified_at")
                    {
                        updateCommandBuilder.AddUpdate(new TableCommand.TableCommandColumn(p, "getdate()"));
                    }
                    else
                    {
                        updateCommandBuilder.AddUpdate(p, node.GetValue(p.FieldName));
                    }
                }
                if (p.IsPrimaryKey)
                {
                    updateCommandBuilder.AddWhere(new ColumnValueCondition(p, "@PK_" + p.FieldName, node.GetValue(p.FieldName), "="));
                }

            }

            return updateCommandBuilder.GetCommand();
        }
        /// <summary>
        /// f[^폜pcommand(_폜)
        /// </summary>
        /// <param name="node">폜m[h</param>
        /// <returns>f[^폜pcommand</returns>
        public virtual OFW.Database.Command createDeleteCommand(TEntity node)
        {
            string query = @"declare @l int;
declare @r int;
declare @w int;

SELECT @l = left_side, @r = right_side, @w = right_side - left_side + 1
FROM [{0}]
WHERE id = @id;

UPDATE [{0}] SET deleted = 1,modified_at = getdate() WHERE left_side between @l and @r;

UPDATE [{0}] SET right_side = right_side - @w , modified_at = getdate() WHERE right_side >= @r and deleted = 0;
UPDATE [{0}] SET left_side = left_side - @w, modified_at = getdate() WHERE left_side >= @r  and deleted = 0;
";

            OFW.Database.Command command = new OFW.Database.Command(
                string.Format(query, this.property.EntityName),
                CommandType.Text
                );
            command.SetParameter(new OFW.Database.Parameter("@id",DbType.Int32,node.id));
            return command;
        }

        #region IDisposable o
        /// <summary>
        /// Dispose
        /// </summary>
        public void Dispose()
        {
            if (this.connection != null)
            {
                try
                {
                    this.connection.Close();
                }
                catch (Exception)
                {
                    
                    throw;
                }
                this.connection = null;
            }
        }

        #endregion



        #region ITreeDataAccess o
        /// <summary>
        /// qvf
        /// </summary>
        /// <param name="parentNode"></param>
        /// <returns></returns>
        public List<OFW.Models.ITreeNode> findChildNodes(OFW.Models.ITreeNode parentNode)
        {
            List<TEntity> list= findChildNodes((TEntity)parentNode);
            List<OFW.Models.ITreeNode> result = new List<OFW.Models.ITreeNode>();
            foreach (TEntity entity in list)
            {
                result.Add(entity);
            }
            return result;
        }
        /// <summary>
        /// keyɈv̂
        /// </summary>
        /// <param name="keySpec"></param>
        /// <returns></returns>
        public OFW.Models.ITreeNode findOne(OFW.Models.ITreeNode keySpec)
        {
            return findOne((TEntity)keySpec);
        }
        /// <summary>
        /// m[hۑ
        /// </summary>
        /// <param name="node"></param>
        /// <returns></returns>
        public int save(OFW.Models.ITreeNode node)
        {
            return save((TEntity)node);
        }
        /// <summary>
        /// m[h폜
        /// </summary>
        /// <param name="node"></param>
        /// <returns></returns>
        public int delete(OFW.Models.ITreeNode node)
        {
            return delete((TEntity)node);
        }
        /// <summary>
        /// Vm[h
        /// </summary>
        /// <returns></returns>
        public OFW.Models.ITreeNode newNode()
        {
            return new TEntity();
        }

        #endregion
    }
}
